/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.Pattern;

public final class Matcher {
    Pattern parentPattern;
    int[] groups;
    int from;
    int to;
    CharSequence text;
    static final int ENDANCHOR = 1;
    static final int NOANCHOR = 0;
    int acceptMode = 0;
    int first = -1;
    int last = -1;
    int oldLast = -1;
    int lastAppendPosition = 0;
    int[] locals;

    Matcher() {
    }

    Matcher(Pattern parent, CharSequence text) {
        this.parentPattern = parent;
        this.text = text;
        int parentGroupCount = Math.max(parent.groupCount, 10);
        this.groups = new int[parentGroupCount * 2];
        this.locals = new int[parent.localCount];
        this.reset();
    }

    public Pattern pattern() {
        return this.parentPattern;
    }

    public Matcher reset() {
        int i;
        this.first = -1;
        this.last = -1;
        this.oldLast = -1;
        for (i = 0; i < this.groups.length; ++i) {
            this.groups[i] = -1;
        }
        for (i = 0; i < this.locals.length; ++i) {
            this.locals[i] = -1;
        }
        this.lastAppendPosition = 0;
        return this;
    }

    public Matcher reset(CharSequence input) {
        this.text = input;
        return this.reset();
    }

    public int start() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.first;
    }

    public int start(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        return this.groups[group * 2];
    }

    public int end() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.last;
    }

    public int end(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        return this.groups[group * 2 + 1];
    }

    public String group() {
        return this.group(0);
    }

    public String group(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        if (this.groups[group * 2] == -1 || this.groups[group * 2 + 1] == -1) {
            return null;
        }
        return ((Object)this.getSubSequence(this.groups[group * 2], this.groups[group * 2 + 1])).toString();
    }

    public int groupCount() {
        return this.parentPattern.groupCount - 1;
    }

    public boolean matches() {
        this.reset();
        return this.match(0, this.getTextLength(), 1);
    }

    public boolean find() {
        if (this.last == this.first) {
            ++this.last;
        }
        if (this.last > this.to) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = -1;
            }
            return false;
        }
        return this.find(this.last, this.getTextLength());
    }

    public boolean find(int start) {
        int limit = this.getTextLength();
        if (start < 0 || start > limit) {
            throw new IndexOutOfBoundsException("Illegal start index");
        }
        this.reset();
        return this.find(start, limit);
    }

    public boolean lookingAt() {
        this.reset();
        return this.match(0, this.getTextLength(), 0);
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        int cursor = 0;
        String s = replacement;
        StringBuffer result = new StringBuffer();
        while (cursor < replacement.length()) {
            char nextChar = replacement.charAt(cursor);
            if (nextChar == '\\') {
                nextChar = replacement.charAt(++cursor);
                result.append(nextChar);
                ++cursor;
                continue;
            }
            if (nextChar == '$') {
                int nextDigit;
                int refNum;
                if ((refNum = replacement.charAt(++cursor) - 48) < 0 || refNum > 9) {
                    throw new IllegalArgumentException("Illegal group reference");
                }
                ++cursor;
                boolean done = false;
                while (!done && cursor < replacement.length() && (nextDigit = replacement.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                    int newRefNum = refNum * 10 + nextDigit;
                    if (this.groupCount() < newRefNum) {
                        done = true;
                        continue;
                    }
                    refNum = newRefNum;
                    ++cursor;
                }
                if (this.group(refNum) == null) continue;
                result.append(this.group(refNum));
                continue;
            }
            result.append(nextChar);
            ++cursor;
        }
        sb.append(this.getSubSequence(this.lastAppendPosition, this.first));
        sb.append(result.toString());
        this.lastAppendPosition = this.last;
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        sb.append(((Object)this.getSubSequence(this.lastAppendPosition, this.getTextLength())).toString());
        return sb;
    }

    public String replaceAll(String replacement) {
        this.reset();
        boolean result = this.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                this.appendReplacement(sb, replacement);
            } while (result = this.find());
            this.appendTail(sb);
            return sb.toString();
        }
        return ((Object)this.text).toString();
    }

    public String replaceFirst(String replacement) {
        StringBuffer sb = new StringBuffer();
        this.reset();
        if (this.find()) {
            this.appendReplacement(sb, replacement);
        }
        this.appendTail(sb);
        return sb.toString();
    }

    private boolean find(int from, int to) {
        from = from < 0 ? 0 : from;
        this.to = to;
        this.first = from;
        this.last = -1;
        this.oldLast = this.oldLast < 0 ? from : this.oldLast;
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = -1;
        }
        this.acceptMode = 0;
        boolean result = this.parentPattern.root.match(this, from, this.text);
        if (!result) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return result;
    }

    private boolean match(int from, int to, int anchor) {
        from = from < 0 ? 0 : from;
        this.to = to;
        this.first = from;
        this.last = -1;
        this.oldLast = this.oldLast < 0 ? from : this.oldLast;
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = -1;
        }
        this.acceptMode = anchor;
        boolean result = this.parentPattern.matchRoot.match(this, from, this.text);
        if (!result) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return result;
    }

    int getTextLength() {
        return this.text.length();
    }

    CharSequence getSubSequence(int beginIndex, int endIndex) {
        return this.text.subSequence(beginIndex, endIndex);
    }

    char charAt(int i) {
        return this.text.charAt(i);
    }
}

