/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.function.CustomByteArrayInputStream;
import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFCalculator
extends PDFGenericFunction
implements PDFFunction {
    static final Map op2code;
    static final Integer FALSE;
    static final Integer TRUE;
    static final Character PROC_OPEN;
    static final Character PROC_CLOSE;
    Object[] commands;
    private float[] domain;
    private float[] range;

    public String getType() {
        return "CALCULATOR";
    }

    public PDFCalculator(byte[] byArray, float[] fArray, float[] fArray2) {
        this.range = fArray2;
        this.domain = fArray;
        CustomByteArrayInputStream customByteArrayInputStream = new CustomByteArrayInputStream(byArray);
        try {
            this.readToken(customByteArrayInputStream);
            this.commands = this.parse(customByteArrayInputStream);
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception + " with Calculator function");
        }
    }

    public String[] compute(float[] fArray) {
        int n = this.range.length / 2;
        float[] fArray2 = new float[n];
        String[] stringArray = new String[n];
        try {
            int n2;
            Number[] numberArray = new Number[100];
            int n3 = 0;
            int n4 = this.domain.length / 2;
            for (n2 = 0; n2 < n4; ++n2) {
                fArray[n2] = this.min(this.max(fArray[n2], this.domain[n2 * 2]), this.domain[n2 * 2 + 1]);
                numberArray[n3++] = new Double(fArray[n2]);
            }
            n3 = this.execute(this.commands, numberArray, n3);
            if (this.domain.length / 2 == 1) {
                n4 = this.range.length / 2;
                for (n2 = 0; n2 < n4; ++n2) {
                    fArray2[n2] = numberArray[n4 - n2 - 1].floatValue();
                    stringArray[n - n2 - 1] = String.valueOf(this.min(this.max(fArray2[n2], this.range[n2 * 2]), this.range[n2 * 2 + 1]));
                }
            } else {
                n4 = this.range.length / 2;
                for (n2 = 0; n2 < n4; ++n2) {
                    fArray2[n2] = numberArray[n2].floatValue();
                    stringArray[n - n2 - 1] = String.valueOf(this.min(this.max(fArray2[n2], this.range[n2 * 2]), this.range[n2 * 2 + 1]));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public float[] computeFloat(float[] fArray) {
        int n = this.range.length / 2;
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        try {
            int n2;
            Number[] numberArray = new Number[100];
            int n3 = 0;
            int n4 = this.domain.length / 2;
            for (n2 = 0; n2 < n4; ++n2) {
                fArray[n2] = this.min(this.max(fArray[n2], this.domain[n2 * 2]), this.domain[n2 * 2 + 1]);
                numberArray[n3++] = new Double(fArray[n2]);
            }
            n3 = this.execute(this.commands, numberArray, n3);
            if (this.domain.length / 2 == 1) {
                n4 = this.range.length / 2;
                for (n2 = 0; n2 < n4; ++n2) {
                    fArray2[n2] = numberArray[n4 - n2 - 1].floatValue();
                    fArray3[n - n2 - 1] = this.min(this.max(fArray2[n2], this.range[n2 * 2]), this.range[n2 * 2 + 1]);
                }
            } else {
                n4 = this.range.length / 2;
                for (n2 = 0; n2 < n4; ++n2) {
                    fArray2[n2] = numberArray[n2].floatValue();
                    fArray3[n - n2 - 1] = this.min(this.max(fArray2[n2], this.range[n2 * 2]), this.range[n2 * 2 + 1]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fArray3;
    }

    Object readToken(CustomByteArrayInputStream customByteArrayInputStream) {
        Object object;
        int n;
        while ((n = customByteArrayInputStream.read()) != -1 && Character.isWhitespace((char)n)) {
        }
        if (n == 123) {
            object = PROC_OPEN;
        } else if (n == 125 || n == -1) {
            object = PROC_CLOSE;
        } else if (n >= 97 && n <= 122) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append((char)n);
            while ((n = customByteArrayInputStream.read()) >= 97 && n <= 122) {
                stringBuffer.append((char)n);
            }
            customByteArrayInputStream.unread(n);
            String string = stringBuffer.toString();
            Integer n2 = (Integer)op2code.get(string);
            object = new Operation(string, n2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append((char)n);
            boolean bl = false;
            while (true) {
                if ((n = customByteArrayInputStream.read()) >= 48 && n <= 57) {
                    stringBuffer.append((char)n);
                    continue;
                }
                if (n != 46) break;
                bl = true;
            }
            customByteArrayInputStream.unread(n);
            String string = stringBuffer.toString();
            object = bl ? (Number)new Double(string) : (Number)new Integer(string);
        }
        return object;
    }

    Object[] parse(CustomByteArrayInputStream customByteArrayInputStream) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(100);
        while (true) {
            Object object;
            if ((object = this.readToken(customByteArrayInputStream)) == PROC_OPEN) {
                arrayList.add(this.parse(customByteArrayInputStream));
                continue;
            }
            if (object == PROC_CLOSE) break;
            if (object instanceof Number) {
                arrayList.add(object);
                continue;
            }
            if (!(object instanceof Operation)) continue;
            Operation operation = (Operation)object;
            if (operation.code == 34) {
                operation.iftrue = (Object[])arrayList.remove(arrayList.size() - 1);
            } else if (operation.code == 35) {
                operation.iffalse = (Operation[])arrayList.remove(arrayList.size() - 1);
                operation.iftrue = (Operation[])arrayList.remove(arrayList.size() - 1);
            }
            arrayList.add(operation);
        }
        return arrayList.toArray();
    }

    int execute(Object[] objectArray, Number[] numberArray, int n) {
        if (objectArray == null) {
            return n;
        }
        Number number = null;
        int n2 = objectArray.length;
        block44: for (int i = 0; i < n2; ++i) {
            Object object = objectArray[i];
            if (object instanceof Number) {
                numberArray[n++] = (Number)object;
                continue;
            }
            Operation operation = (Operation)object;
            Number number2 = n > 0 ? (Number)numberArray[n - 1] : (Number)null;
            switch (operation.code) {
                case 0: {
                    numberArray[n - 1] = new Double(Math.abs(number2.doubleValue()));
                    continue block44;
                }
                case 1: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() + number2.doubleValue());
                    --n;
                    continue block44;
                }
                case 2: {
                    numberArray[n - 1] = new Double(Math.atan(number2.doubleValue()));
                    continue block44;
                }
                case 3: {
                    numberArray[n - 1] = new Double(Math.ceil(number2.doubleValue()));
                    continue block44;
                }
                case 4: {
                    numberArray[n - 1] = new Double(Math.cos(number2.doubleValue()));
                    continue block44;
                }
                case 5: {
                    numberArray[n - 1] = new Integer(number2.intValue());
                    continue block44;
                }
                case 6: {
                    numberArray[n - 1] = new Double(number2.doubleValue());
                    continue block44;
                }
                case 7: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() / number2.doubleValue());
                    --n;
                    continue block44;
                }
                case 8: {
                    numberArray[n - 2] = new Double(Math.pow(numberArray[n - 2].doubleValue(), number2.doubleValue()));
                    --n;
                    continue block44;
                }
                case 9: {
                    numberArray[n - 1] = new Double(Math.floor(number2.doubleValue()));
                    continue block44;
                }
                case 10: {
                    numberArray[n - 2] = new Integer(numberArray[n - 2].intValue() / number2.intValue());
                    --n;
                    continue block44;
                }
                case 11: {
                    numberArray[n - 1] = new Double(Math.log(number2.doubleValue()));
                    continue block44;
                }
                case 12: {
                    numberArray[n - 1] = new Double(Math.log(number2.doubleValue()) / Math.log(10.0));
                    continue block44;
                }
                case 13: {
                    numberArray[n - 2] = new Integer(number2.intValue() % numberArray[n - 2].intValue());
                    --n;
                    continue block44;
                }
                case 14: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() * number2.doubleValue());
                    --n;
                    continue block44;
                }
                case 15: {
                    numberArray[n - 1] = new Double(-number2.doubleValue());
                    continue block44;
                }
                case 16: {
                    numberArray[n - 1] = new Double(Math.sin(number2.doubleValue()));
                    continue block44;
                }
                case 17: {
                    numberArray[n - 1] = new Double(Math.sqrt(number2.doubleValue()));
                    continue block44;
                }
                case 18: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() - number2.doubleValue());
                    --n;
                    continue block44;
                }
                case 19: {
                    numberArray[n - 1] = new Integer(Math.round(number2.floatValue()));
                    continue block44;
                }
                case 20: {
                    numberArray[n - 1] = new Integer((int)number2.doubleValue());
                    continue block44;
                }
                case 21: {
                    numberArray[n - 2] = new Integer(numberArray[i - 2].intValue() & number2.intValue());
                    --n;
                    continue block44;
                }
                case 22: {
                    numberArray[n - 2] = new Integer(numberArray[n - 2].intValue() << number2.intValue());
                    --n;
                    continue block44;
                }
                case 23: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() == number2.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 24: {
                    numberArray[n++] = FALSE;
                    continue block44;
                }
                case 25: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() >= number2.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 26: {
                    if (numberArray[i - 2] == null) {
                        if (number != null) {
                            numberArray[n - 2] = number.doubleValue() > number2.doubleValue() ? TRUE : FALSE;
                        }
                    } else {
                        numberArray[n - 2] = numberArray[i - 2].doubleValue() > number2.doubleValue() ? TRUE : FALSE;
                    }
                    --n;
                    continue block44;
                }
                case 27: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() <= number2.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 28: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() < number2.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 29: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() != number2.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 30: {
                    numberArray[n - 1] = number2 == TRUE ? FALSE : (number2 == FALSE ? TRUE : new Integer(~number2.intValue()));
                    continue block44;
                }
                case 31: {
                    numberArray[n - 2] = new Integer(numberArray[i - 2].intValue() | number2.intValue());
                    --n;
                    continue block44;
                }
                case 32: {
                    numberArray[n++] = TRUE;
                    continue block44;
                }
                case 33: {
                    numberArray[n - 2] = new Integer(numberArray[i - 2].intValue() ^ number2.intValue());
                    --n;
                    continue block44;
                }
                case 34: {
                    --n;
                    if (number2.intValue() == 0) continue block44;
                    n = this.execute(operation.iftrue, numberArray, n);
                    continue block44;
                }
                case 35: {
                    --n;
                    n = this.execute(number2.intValue() != 0 ? operation.iftrue : operation.iffalse, numberArray, n);
                    continue block44;
                }
                case 36: {
                    int n3 = number2.intValue();
                    System.arraycopy(numberArray, --n - n3, numberArray, n, n3);
                    n += n3;
                    continue block44;
                }
                case 37: {
                    numberArray[n - 1] = numberArray[n - 2];
                    numberArray[n - 2] = number2;
                    continue block44;
                }
                case 38: {
                    --n;
                    continue block44;
                }
                case 39: {
                    numberArray[n++] = number2;
                    number = number2;
                    continue block44;
                }
                case 40: {
                    int n3 = number2.intValue();
                    numberArray[--n] = numberArray[n - n3 - 1];
                    ++n;
                    continue block44;
                }
                case 41: {
                    int n3 = numberArray[n - 2].intValue();
                    int n4 = number2.intValue();
                }
            }
        }
        return n;
    }

    static {
        String[] stringArray = new String[]{"abs", "add", "atan", "ceiling", "cos", "cvi", "cvr", "div", "exp", "floor", "idiv", "ln", "log", "mod", "mul", "neg", "sin", "sqrt", "sub", "round", "truncate", "and", "bitshift", "eq", "false", "ge", "gt", "le", "lt", "ne", "not", "or", "true", "xor", "if", "ifelse", "copy", "exch", "pop", "dup", "index", "roll"};
        int n = stringArray.length;
        op2code = new HashMap(n * 2);
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            op2code.put(stringArray[i], new Integer(i));
        }
        FALSE = new Integer(0);
        TRUE = new Integer(1);
        PROC_OPEN = new Character('{');
        PROC_CLOSE = new Character('}');
    }

    static class Operation {
        public String op;
        public int code;
        public Object[] iftrue;
        public Object[] iffalse;

        public Operation(String string, int n) {
            this.op = string;
            this.code = n;
        }

        public String toString() {
            return this.op + '/' + this.code;
        }
    }
}

