/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.util.Map;
import org.jpedal.function.PDFCalculator;
import org.jpedal.function.PDFExponential;
import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.function.PDFSampled;
import org.jpedal.function.PDFStitching;
import org.jpedal.io.PdfObjectReader;

public class FunctionFactory {
    public static boolean debugShadingFunctions = false;

    public static PDFFunction getFunction(byte[] byArray, Map map, float[] fArray, float[] fArray2, int n, PdfObjectReader pdfObjectReader) {
        PDFGenericFunction pDFGenericFunction = null;
        switch (n) {
            case 0: {
                pDFGenericFunction = new PDFSampled(byArray, map, fArray, fArray2, pdfObjectReader);
                break;
            }
            case 2: {
                pDFGenericFunction = new PDFExponential(map, fArray, fArray2, pdfObjectReader);
                break;
            }
            case 3: {
                pDFGenericFunction = new PDFStitching(map, fArray, fArray2, pdfObjectReader);
                break;
            }
            case 4: {
                pDFGenericFunction = new PDFCalculator(byArray, fArray, fArray2);
            }
        }
        if (debugShadingFunctions) {
            System.out.println("Shading Type = " + pDFGenericFunction.getType() + " <");
        }
        return pDFGenericFunction;
    }
}

