/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.jpedal.utils.ToInteger;

public class PdfFont
implements Serializable {
    public Font javaFont = null;
    protected String embeddedFontName = null;
    protected String embeddedFamilyName = null;
    protected String copyright = null;
    private float missingWidth = -1.0f;
    public PdfJavaGlyphs glyphs = new PdfJavaGlyphs();
    private String[] cachedValue = new String[256];
    protected boolean cleanupFonts = false;
    protected String substituteFont = null;
    protected boolean renderPage = false;
    private static final float xscale = 0.001f;
    protected int embeddedEnc = 1;
    protected String[] diffs;
    public boolean isFontEmbedded = false;
    protected boolean TTstreamisCID = false;
    protected String fontID = "";
    protected int maxCharCount = 256;
    protected boolean hasEncoding = true;
    private boolean isDoubleByte = false;
    protected int fontTypes;
    protected String substituteFontFile = null;
    protected String substituteFontName = null;
    private int spaceChar = -1;
    private String[] diffTable;
    private int fontFlag = 0;
    private float[] widthTable;
    private float possibleSpaceWidth = -1.0f;
    protected PdfObjectReader currentPdfFile;
    protected ClassLoader loader = this.getClass().getClassLoader();
    public double[] FontMatrix = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    public float[] FontBBox = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    protected boolean isHex = false;
    private String[] unicodeMappings;
    protected int fontEnc = -1;
    protected boolean isCIDFont = false;
    protected String[] CMAP;
    protected String CIDfontEncoding;
    private float defaultWidth = 1.0f;
    protected boolean isFontSubstituted = false;
    protected boolean hasFontEncoding;
    protected int italicAngle = 0;
    private static boolean isCidJarPresent;

    public PdfFont() {
    }

    public void createFont(String string) throws Exception {
    }

    public PdfFont(PdfObjectReader pdfObjectReader) {
        this.init(pdfObjectReader);
    }

    public static void setStandardFontMappings() {
        String string;
        String string2;
        int n;
        int n2 = StandardFonts.files_names.length;
        for (n = 0; n < n2; ++n) {
            string2 = StandardFonts.files_names_bis[n].toLowerCase();
            if (string2.equals(string = StandardFonts.javaFonts[n].toLowerCase()) || FontMappings.fontSubstitutionAliasTable.containsKey(string2)) continue;
            FontMappings.fontSubstitutionAliasTable.put(string2, string);
        }
        for (n = 0; n < n2; ++n) {
            string2 = StandardFonts.files_names[n].toLowerCase();
            if (!string2.equals(string = StandardFonts.javaFonts[n].toLowerCase()) && !FontMappings.fontSubstitutionAliasTable.containsKey(string2)) {
                FontMappings.fontSubstitutionAliasTable.put(string2, string);
            }
            StandardFonts.javaFontList.put(StandardFonts.files_names[n], "x");
        }
        FontMappings.fontSubstitutionAliasTable.put("arialmt", "arial");
        FontMappings.fontSubstitutionAliasTable.put("arial-boldmt", "arialbd");
    }

    public boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    public boolean isDoubleByte() {
        return this.isDoubleByte;
    }

    protected final void setCIDFontDefaultWidth(String string) {
        this.defaultWidth = Float.parseFloat(string) / 1000.0f;
    }

    protected final void setCIDFontWidths(String string) {
        string = string.substring(1, string.length() - 1).trim();
        this.widthTable = new float[65536];
        for (int i = 0; i < 65536; ++i) {
            this.widthTable[i] = -1.0f;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " []", true);
        block1: while (stringTokenizer.hasMoreTokens() && stringTokenizer.hasMoreTokens()) {
            String string2;
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            int n = Integer.parseInt(string2);
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            if (string2.equals("[")) {
                while (true) {
                    if ((string2 = stringTokenizer.nextToken()).equals(" ")) {
                        continue;
                    }
                    if (string2.equals("]")) continue block1;
                    this.widthTable[n] = Float.parseFloat(string2) / 1000.0f;
                    ++n;
                }
            }
            int n2 = 1 + Integer.parseInt(string2);
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            for (int i = n; i < n2; ++i) {
                this.widthTable[i] = Float.parseFloat(string2) / 1000.0f;
            }
        }
    }

    public final boolean isCIDFont() {
        return this.isCIDFont;
    }

    protected final void init(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        if (this.isCIDFont) {
            this.maxCharCount = 65536;
        }
        this.glyphs.init(this.maxCharCount, this.isCIDFont);
    }

    private final String getUnicodeMapping(int n) {
        if (this.unicodeMappings == null) {
            return null;
        }
        return this.unicodeMappings[n];
    }

    protected final void putFontEncoding(int n) {
        this.fontEnc = n;
        StandardFonts.checkLoaded(n);
    }

    public final String getUnicodeValue(String string, int n) {
        String string2 = this.getUnicodeMapping(n);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public final String getGlyphValue(int n) {
        if (this.cachedValue[n] != null) {
            return this.cachedValue[n];
        }
        String string = null;
        if (this.isCIDFont) {
            String string2 = this.getUnicodeMapping(n);
            if (string2 != null) {
                string = string2;
            }
            if (string == null) {
                String string3 = this.CIDfontEncoding;
                if (this.diffTable != null) {
                    string = this.diffTable[n];
                } else if (string3 != null) {
                    String string4;
                    if (string3.startsWith("Identity-")) {
                        string = String.valueOf((char)n);
                    } else if (this.CMAP != null && (string4 = this.CMAP[n]) != null) {
                        string = string4;
                    }
                }
                if (string == null) {
                    string = String.valueOf((char)n);
                }
            }
        } else {
            string = this.getStandardGlyphValue(n);
        }
        this.cachedValue[n] = string;
        return string;
    }

    private final Map handleCIDEncoding(String string) throws PdfFontException {
        Object object;
        String string2 = "";
        boolean bl = false;
        BufferedReader bufferedReader = null;
        Map map = null;
        if (string.indexOf(" R") != -1 && (object = (String)(map = this.currentPdfFile.readObject(string, false, null)).get("CMapName")) != null) {
            byte[] byArray = this.currentPdfFile.readStream(string, true);
            string = object;
            bufferedReader = new BufferedReader(new StringReader(new String(byArray)));
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (bufferedReader == null) {
            this.CIDfontEncoding = string;
        }
        if (string.startsWith("Identity-")) {
            this.isDoubleByte = true;
            this.glyphs.setIsIdentity(true);
        } else {
            this.glyphs.setIsIdentity(false);
            if (!isCidJarPresent && bufferedReader == null) {
                isCidJarPresent = true;
                object = PdfFont.class.getResourceAsStream("/org/jpedal/res/cid/00_ReadMe.pdf");
                if (object == null) {
                    throw new PdfFontException("cid.jar not on classpath");
                }
            }
            this.CMAP = new String[65536];
            if (string.equals("ETenms-B5-H")) {
                string = "ETen-B5-H";
            } else if (string.equals("ETenms-B5-V")) {
                string = "ETen-B5-V";
            }
            try {
                if (bufferedReader == null) {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/cid/" + string), "Cp1252"));
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("1.Problem reading encoding for CID font " + this.fontID + " encoding=" + string + " Check CID.jar installed");
            }
            if (string.equals("UniJIS-UCS2-H")) {
                this.isDoubleByte = true;
            }
            if (bufferedReader != null) {
                while (true) {
                    try {
                        string2 = bufferedReader.readLine();
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] Error reading line fron font");
                    }
                    if (string2 == null) break;
                    if (string2.indexOf("endcidrange") != -1) {
                        bl = false;
                    }
                    if (bl) {
                        object = new StringTokenizer(string2, " <>[]");
                        boolean bl2 = false;
                        if (string2.indexOf(91) != -1) {
                            bl2 = true;
                        }
                        int n = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                        int n2 = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                        int n3 = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                        for (int i = n; i < n2 + 1; ++i) {
                            if (bl2) {
                                n3 = Integer.parseInt(((StringTokenizer)object).nextToken(), 16);
                                this.CMAP[i] = String.valueOf((char)n3);
                                continue;
                            }
                            this.CMAP[i] = String.valueOf((char)n3);
                            ++n3;
                        }
                    }
                    if (string2.indexOf("begincidrange") == -1) continue;
                    bl = true;
                }
            }
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("2.Problem reading encoding for CID font " + this.fontID + ' ' + string + " Check CID.jar installed");
            }
        }
        return map;
    }

    public final String getStandardGlyphValue(int n) {
        String string = this.getUnicodeMapping(n);
        if (string != null) {
            return string;
        }
        String string2 = "";
        int n2 = this.getFontEncoding(true);
        String string3 = this.getMappedChar(n, true);
        if (string3 != null) {
            String string4 = StandardFonts.getUnicodeName(this.fontEnc + string3);
            if (string4 != null) {
                string2 = string4;
            } else {
                string4 = StandardFonts.getUnicodeName(string3);
                if (string4 != null) {
                    string2 = string4;
                } else if (string3.length() == 1) {
                    string2 = string3;
                } else if (string3.length() > 1) {
                    int n3;
                    char c = string3.charAt(0);
                    char c2 = string3.charAt(1);
                    if (c == 'B' | c == 'C' | c == 'c' | c == 'G') {
                        string3 = string3.substring(1);
                        try {
                            n3 = this.isHex ? Integer.valueOf(string3, 16) : Integer.parseInt(string3);
                            string2 = String.valueOf((char)n3);
                        }
                        catch (Exception exception) {
                            string2 = "";
                        }
                    } else {
                        string2 = "";
                    }
                    int n4 = n3 = (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') && (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') ? 1 : 0;
                    if (string2.length() == 0 && this.fontTypes == 3 && string3.length() == 2 && n3 != 0) {
                        try {
                            string2 = String.valueOf((char)Integer.parseInt(string3, 16));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string2.length() == 0 && this.fontTypes == 3) {
                        string2 = String.valueOf((char)n);
                    }
                } else {
                    string2 = "";
                }
            }
        } else if (n2 > -1) {
            string2 = StandardFonts.getEncodedChar(n2, n);
        }
        return string2;
    }

    public final Font getJavaFont(int n) {
        String string;
        int n2 = 0;
        boolean bl = false;
        String string2 = null;
        Object var5_5 = null;
        String string3 = string = this.glyphs.fontName;
        if (string != null) {
            string3 = string.toLowerCase();
        }
        if (string3.equals("arialmt")) {
            string = string3 = "arial";
        } else if (string3.equals("arial-boldmt")) {
            string = string3 = "arial Bold";
        }
        if (var5_5 != null) {
            string = var5_5;
            string3 = string.toLowerCase();
        }
        if (PdfJavaGlyphs.fontList != null) {
            int n3 = PdfJavaGlyphs.fontList.length;
            for (int i = 0; i < n3; ++i) {
                System.out.println(PdfJavaGlyphs.fontList[i] + "<>" + string3);
                if (PdfJavaGlyphs.fontList[i].indexOf(string3) == -1) continue;
                bl = true;
                string = PdfJavaGlyphs.fontList[i];
                i = n3;
            }
        }
        if (!bl && string2 == null) {
            String string4 = string.toLowerCase();
            if (string4.indexOf("heavy") != -1) {
                n2 = 1;
            } else if (string4.indexOf("bold") != -1) {
                n2 = 1;
            } else if (string4.indexOf("roman") != -1) {
                n2 = 0;
            }
            if (string4.indexOf("italic") != -1) {
                n2 += 2;
            } else if (string4.indexOf("oblique") != -1) {
                n2 += 2;
            }
        }
        if (bl) {
            return new Font(string, n2, n);
        }
        System.out.println("No match with " + this.glyphs.getBaseFontName() + ' ' + ' ' + string3 + ' ' + string2 + ' ' + n2);
        System.exit(1);
        return null;
    }

    public final void setDefaultDisplayFont(String string) {
        this.glyphs.defaultFont = string;
    }

    public final Font getJavaFontX(int n) {
        return new Font(this.glyphs.font_family_name, this.glyphs.style, n);
    }

    protected final void readGenericFontMetadata(Map map) {
        String string;
        int n;
        Object object;
        LogWriter.writeMethod("{readGenericFontMetadata " + this.fontID + '}', 0);
        String string2 = (String)map.get("FontMatrix");
        if (string2 != null) {
            object = new StringTokenizer(string2, "[] ");
            for (int i = 0; i < 6; ++i) {
                this.FontMatrix[i] = Float.parseFloat(((StringTokenizer)object).nextToken());
            }
        }
        if ((object = (String)map.get("FontBBox")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "[] ");
            for (n = 0; n < 4; ++n) {
                this.FontBBox[n] = Float.parseFloat(stringTokenizer.nextToken());
            }
        }
        if ((string = this.currentPdfFile.getValue((String)map.get("BaseFont"))) == null) {
            string = this.currentPdfFile.getValue((String)map.get("FontName"));
        }
        string = string == null ? this.fontID : string.substring(1);
        if (this.cleanupFonts || PdfStreamDecoder.runningStoryPad) {
            string = this.cleanupFontName(string);
        }
        this.glyphs.fontName = string;
        n = string.indexOf(43);
        if (n == 6) {
            this.glyphs.fontName = string.substring(n + 1);
        }
        this.glyphs.setBaseFontName(string);
    }

    public final String getFontName() {
        StandardFonts.loadStandardFontWidth(this.glyphs.fontName);
        return this.glyphs.fontName;
    }

    public final String getBaseFontName() {
        return this.glyphs.getBaseFontName();
    }

    public final void setBaseFontName(String string) {
        this.glyphs.setBaseFontName(string);
    }

    public final void setFontName(String string) {
        this.glyphs.fontName = string;
    }

    public final float getCurrentFontSpaceWidth() {
        int n = this.spaceChar;
        float f = n != -1 ? this.getWidth(n) : this.possibleSpaceWidth;
        if (f == -1.0f) {
            f = 0.2f;
        }
        return f;
    }

    protected final int getFontEncoding(boolean bl) {
        int n = this.fontEnc;
        if (n == -1 && bl) {
            n = 1;
        }
        return n;
    }

    public final float getWidth(int n) {
        float f = -1.0f;
        if (this.widthTable != null) {
            f = this.widthTable[n];
        }
        if (f == -1.0f) {
            if (this.isCIDFont) {
                f = this.defaultWidth;
            } else {
                Float f2;
                String string = this.getMappedChar(n, false);
                if (string != null && string.equals(".notdef")) {
                    string = StandardFonts.getUnicodeChar(this.getFontEncoding(true), n);
                }
                f = (f2 = StandardFonts.getStandardWidth(this.glyphs.fontName, string)) != null ? f2.floatValue() : (this.missingWidth != -1.0f ? this.missingWidth * 0.001f : 0.0f);
            }
        }
        return f;
    }

    public Map createCIDFont(Map map, Map map2) throws PdfFontException {
        Object object;
        Object object2;
        Object object3;
        Object v;
        String string;
        String string2;
        Object v2;
        Map map3 = null;
        Map map4 = null;
        this.cachedValue = new String[65536];
        String string3 = (String)map.get("Encoding");
        if (string3 != null) {
            map4 = this.handleCIDEncoding(string3);
        }
        if ((v2 = map.get("ToUnicode")) != null) {
            if (v2 instanceof String) {
                string2 = (String)v2;
                if (string2.indexOf(" R") != -1) {
                    this.readUnicode(this.currentPdfFile.readStream(string2, true), this.fontID);
                }
            } else {
                this.readUnicode((byte[])((Map)v2).get("DecodedStream"), this.fontID);
            }
        }
        if ((string2 = this.currentPdfFile.getValue((String)map2.get("W"))) != null) {
            this.setCIDFontWidths(string2);
        }
        if ((string = this.currentPdfFile.getValue((String)map2.get("DW"))) != null) {
            this.setCIDFontDefaultWidth(string);
        }
        if ((v = map2.get("CIDToGIDMap")) != null) {
            if (v instanceof String) {
                object3 = (String)v;
                if (((String)object3).endsWith(" R")) {
                    object2 = this.currentPdfFile.readStream((String)object3, true);
                    int n = 0;
                    object = new int[((Object)object2).length / 2];
                    for (int i = 0; i < ((Object)object2).length; i += 2) {
                        int n2;
                        object[n] = n2 = ((object2[i] & 0xFF) << 8) + (object2[i + 1] & 0xFF);
                        ++n;
                    }
                    this.glyphs.setGIDtoCID((int[])object);
                } else if (((String)object3).equals("/Identity")) {
                    this.handleCIDEncoding("Identity-");
                } else {
                    LogWriter.writeLog("not yet supported in demo.");
                    System.err.println("not yet supported in demo.");
                }
            } else {
                LogWriter.writeLog("not yet supported in demo.");
                System.err.println("not yet supported in demo.");
            }
        }
        object3 = map2.get("CIDSystemInfo");
        object2 = new Hashtable();
        object2 = object3 instanceof Map ? (Map)object3 : this.currentPdfFile.readObject((String)object3, false, null);
        String string4 = (String)object2.get("Ordering");
        if (string4 != null) {
            if (string4.indexOf("Japan") != -1) {
                this.substituteFontFile = "kochi-mincho.ttf";
                this.substituteFontName = "Kochi Mincho";
                this.TTstreamisCID = false;
            } else if (string4.indexOf("Korean") != -1) {
                System.err.println("Unsupported font encoding " + string4);
            } else if (string4.indexOf("Chinese") != -1) {
                System.err.println("Chinese " + string4);
            }
            if (this.substituteFontName != null) {
                LogWriter.writeLog("Using font " + this.substituteFontName + " for " + string4);
            }
        }
        if ((object = (Object)map2.get("FontDescriptor")) != null) {
            map3 = null;
            if (object instanceof String) {
                String string5 = (String)object;
                if (string5.length() > 1) {
                    map3 = this.currentPdfFile.readObject(string5, false, null);
                }
            } else {
                map3 = (Map)object;
            }
            if (map3 != null) {
                this.readGenericFontMetadata(map3);
            }
        }
        return map3;
    }

    protected final void selectDefaultFont() {
    }

    public void readWidths(Map map) throws Exception {
        LogWriter.writeMethod("{readWidths}" + map, 0);
        String string = this.currentPdfFile.getValue((String)map.get("FirstChar"));
        int n = 1;
        if (string != null) {
            n = ToInteger.getInteger(string);
        }
        String string2 = this.currentPdfFile.getValue((String)map.get("LastChar"));
        float f = 0.0f;
        String string3 = this.currentPdfFile.getValue((String)map.get("Widths"));
        if (string3 != null) {
            this.widthTable = new float[this.maxCharCount];
            for (int i = 0; i < this.maxCharCount; ++i) {
                this.widthTable[i] = -1.0f;
            }
            String string4 = string3.substring(1, string3.length() - 1).trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            int n2 = ToInteger.getInteger(string2);
            float f2 = (float)(1.0 / this.FontMatrix[0]);
            if (f2 < 0.0f) {
                f2 = -f2;
            }
            for (int i = n; i < n2 + 1; ++i) {
                float f3;
                if (!stringTokenizer.hasMoreTokens()) {
                    f3 = 0.0f;
                    continue;
                }
                f3 = this.fontTypes == 3 ? Float.parseFloat(stringTokenizer.nextToken()) / f2 : Float.parseFloat(stringTokenizer.nextToken()) * 0.001f;
                this.widthTable[i] = f3;
                if (!(f3 > 0.0f)) continue;
                f += f3;
            }
        }
    }

    public Map createFont(Map map, String string, boolean bl, Map map2, ObjectStore objectStore) throws Exception {
        int n;
        Object object;
        Object object2;
        Object v;
        LogWriter.writeMethod("{readNonCIDFont}" + map + "{render=" + bl, 0);
        if (PdfJavaGlyphs.fontList == null & bl) {
            PdfJavaGlyphs.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            int n2 = PdfJavaGlyphs.fontList.length;
            for (int i = 0; i < n2; ++i) {
                PdfJavaGlyphs.fontList[i] = PdfJavaGlyphs.fontList[i].toLowerCase();
            }
        }
        this.fontID = string;
        this.renderPage = bl;
        this.readGenericFontMetadata(map);
        String string2 = (String)map.get("Subtype");
        if (string2 == null) {
            string2 = "";
        }
        if ((v = map.get("ToUnicode")) != null) {
            if (v instanceof String) {
                this.readUnicode(this.currentPdfFile.readStream((String)v, true), string);
            } else {
                this.readUnicode((byte[])((Map)v).get("DecodedStream"), string);
            }
        }
        String string3 = (String)map.get("FirstChar");
        int n3 = 1;
        if (string3 != null) {
            n3 = ToInteger.getInteger(string3);
        }
        String string4 = (String)map.get("LastChar");
        float f = 0.0f;
        int n4 = 0;
        String string5 = this.currentPdfFile.getValue((String)map.get("Widths"));
        if (string5 != null) {
            this.widthTable = new float[this.maxCharCount];
            for (int i = 0; i < this.maxCharCount; ++i) {
                this.widthTable[i] = -1.0f;
            }
            object2 = string5.substring(1, string5.length() - 1).trim();
            object = new StringTokenizer((String)object2);
            int n5 = ToInteger.getInteger(string4) + 1;
            float f2 = (float)(1.0 / this.FontMatrix[0]);
            f2 = -f2;
            for (n = n3; n < n5; ++n) {
                float f3 = !((StringTokenizer)object).hasMoreTokens() ? 0.0f : (this.fontTypes == 3 ? Float.parseFloat(((StringTokenizer)object).nextToken()) / f2 : Float.parseFloat(((StringTokenizer)object).nextToken()) * 0.001f);
                this.widthTable[n] = f3;
                if (!(f3 > 0.0f)) continue;
                f += f3;
                ++n4;
            }
        }
        if ((object2 = map.get("Encoding")) != null) {
            if (object2 instanceof String) {
                this.handleFontEncoding((String)object2, null, string2);
            } else {
                this.handleFontEncoding("", (Map)object2, string2);
            }
        } else {
            this.handleNoEncoding(0);
        }
        if (n4 > 0) {
            this.possibleSpaceWidth = f / (float)(2 * n4);
        }
        object = null;
        Object v2 = map.get("FontDescriptor");
        if (v2 instanceof String) {
            String string6 = (String)v2;
            if (string6 != null && string6.length() > 1) {
                object = this.currentPdfFile.readObject(string6, false, null);
            }
        } else {
            object = (Map)v2;
        }
        if (object != null) {
            int n6 = 0;
            String string7 = (String)object.get("Flags");
            if (string7 != null) {
                n6 = Integer.parseInt(string7);
            }
            this.fontFlag = n6;
            this.glyphs.remapFont = false;
            n = this.fontFlag;
            if ((n & 4) == 4) {
                this.glyphs.remapFont = true;
            }
            if ((string7 = this.currentPdfFile.getValue((String)object.get("MissingWidth"))) != null) {
                this.missingWidth = Float.parseFloat(string7);
            }
        }
        return object;
    }

    private int handleNoEncoding(int n) {
        String string = this.getBaseFontName();
        if (string.equals("ZapfDingbats") || string.equals("ZaDb")) {
            this.putFontEncoding(5);
            this.glyphs.defaultFont = "Zapf Dingbats";
            StandardFonts.checkLoaded(5);
            n = 5;
        } else if (string.equals("Symbol")) {
            this.putFontEncoding(4);
            n = 4;
        } else {
            this.putFontEncoding(1);
        }
        this.hasEncoding = false;
        return n;
    }

    private final void handleFontEncoding(String string, Map map, String string2) {
        this.hasFontEncoding = true;
        int n = this.getFontEncoding(false);
        String string3 = "";
        int n2 = n;
        if (n2 == -1) {
            n2 = string2.equals("/TrueType") ? 0 : 1;
        }
        if (string.indexOf(32) != -1 | map != null) {
            String string4;
            String string5;
            if (map == null) {
                map = this.currentPdfFile.readObject(string, false, null);
            }
            if ((string5 = this.currentPdfFile.getValue((String)map.get("BaseEncoding"))) == null && (string4 = (String)map.get("rawValue")) != null) {
                string5 = string4;
            }
            string4 = this.currentPdfFile.getValue((String)map.get("Differences"));
            if (string5 != null) {
                if (string5.startsWith("/")) {
                    string5 = string5.substring(1);
                }
                string3 = string5;
                this.hasEncoding = true;
            } else {
                n2 = this.handleNoEncoding(n2);
            }
            if (string4 != null) {
                this.glyphs.setIsSubsetted(true);
                string4 = Strip.removeArrayDeleminators(string4);
                int n3 = 0;
                String string6 = " \r\n";
                StringTokenizer stringTokenizer = new StringTokenizer(string4, " /\r\n", true);
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    if (string6.indexOf(string7) != -1) continue;
                    if (string7.equals("/")) {
                        string7 = stringTokenizer.nextToken();
                        while (string6.indexOf(string7) != -1) {
                            string7 = stringTokenizer.nextToken();
                        }
                        if ((string7 = StandardFonts.convertNumberToGlyph(string7)).startsWith("space")) {
                            this.spaceChar = n3;
                        }
                        this.putMappedChar(n3, string7);
                        ++n3;
                        char c = string7.charAt(0);
                        if (!(c == 'B' | c == 'c' | c == 'C' | c == 'G')) continue;
                        int n4 = 1;
                        int n5 = string7.length();
                        while (!this.isHex && n4 < n5) {
                            this.isHex = Character.isLetter(string7.charAt(n4++));
                        }
                        continue;
                    }
                    if (!Character.isDigit(string7.charAt(0))) continue;
                    n3 = Integer.parseInt(string7);
                }
            }
        } else {
            string3 = string;
        }
        if (string3.indexOf("MacRomanEncoding") != -1) {
            n2 = 0;
        } else if (string3.indexOf("WinAnsiEncoding") != -1) {
            n2 = 2;
        } else if (string3.indexOf("MacExpertEncoding") != -1) {
            n2 = 3;
        } else if (string3.indexOf("STD") == -1 & n2 == -1) {
            LogWriter.writeLog("Encoding type " + string3 + " not implemented");
        }
        if (n2 > -1) {
            this.putFontEncoding(n2);
        }
    }

    protected final void putMappedChar(int n, String string) {
        if (this.diffTable == null) {
            this.diffTable = new String[this.maxCharCount];
        }
        if (this.diffTable[n] == null) {
            this.diffTable[n] = string;
        }
    }

    public double getType3Ydisplacement(int n) {
        return 0.0;
    }

    public final String getMappedChar(int n, boolean bl) {
        String string = null;
        if (this.diffTable != null) {
            string = this.diffTable[n];
        }
        if (bl && string != null && string.equals(".notdef")) {
            string = " ";
        }
        if (string == null && n < 335) {
            string = StandardFonts.getUnicodeChar(this.getFontEncoding(true), n);
        }
        if (string == null && n > 40 && this.getFontEncoding(true) == 2) {
            string = "bullet";
        }
        if (this.isFontEmbedded && string == null) {
            if (this.diffs != null) {
                string = this.diffs[n];
            }
            if (string == null && n < 335) {
                string = StandardFonts.getUnicodeChar(this.embeddedEnc, n);
            }
        }
        return string;
    }

    public final String getEmbeddedChar(int n) {
        String string = null;
        if (this.isFontEmbedded) {
            if (this.diffs != null) {
                string = this.diffs[n];
            }
            if (string == null && n < 256) {
                string = StandardFonts.getUnicodeChar(this.embeddedEnc, n);
            }
        }
        return string;
    }

    protected final void readUnicode(byte[] byArray, String string) {
        int n = 0;
        BufferedReader bufferedReader = null;
        ByteArrayInputStream byteArrayInputStream = null;
        this.unicodeMappings = new String[this.maxCharCount];
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            String string2 = null;
            if (bufferedReader != null) {
                while (true) {
                    String string3;
                    if (string2 == null) {
                        string3 = bufferedReader.readLine();
                    } else {
                        string3 = string2;
                        string2 = null;
                    }
                    if (string3 != null) {
                        int n2;
                        int n3;
                        String string4;
                        int n4;
                        if (string3.indexOf("endbf") != -1) {
                            n = 0;
                        }
                        if (n == 1) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string3, " <>[]");
                            if (stringTokenizer.countTokens() > 1) {
                                n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                                string4 = stringTokenizer.nextToken();
                                String string5 = "";
                                if (string4.length() < 4) {
                                    n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                                    string5 = String.valueOf((char)n3);
                                } else {
                                    for (n2 = 0; n2 < string4.length(); n2 += 4) {
                                        n3 = Integer.parseInt(string4.substring(n2, n2 + 4), 16);
                                        string5 = string5 + String.valueOf((char)n3);
                                    }
                                }
                                this.unicodeMappings[n4] = string5;
                            }
                        } else if (n == 2 && string3.length() > 0) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string3, " <>[]");
                            n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                            int n5 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                            string4 = "";
                            while (stringTokenizer.hasMoreTokens()) {
                                string4 = string4 + stringTokenizer.nextToken();
                            }
                            int n6 = 0;
                            for (n2 = n4; n2 < n5 + 1; ++n2) {
                                String string6 = "";
                                int n7 = string4.length();
                                for (int i = 0; i < n7; i += 4) {
                                    n3 = Integer.parseInt(string4.substring(i, i + 4), 16);
                                    if (n2 + 4 > n7) {
                                        n3 += n6;
                                    }
                                    string6 = string6 + String.valueOf((char)n3);
                                }
                                this.unicodeMappings[n2] = string6;
                                ++n6;
                            }
                        }
                        if (string3.indexOf("beginbfchar") != -1) {
                            n = 1;
                            int n8 = string3.indexOf(60);
                            if (n8 == -1) continue;
                            string2 = string3.substring(n8);
                            continue;
                        }
                        if (string3.indexOf("beginbfrange") == -1) continue;
                        n = 2;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception setting up text object " + exception);
        }
        if (bufferedReader != null) {
            try {
                byteArrayInputStream.close();
                bufferedReader.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception setting up text object " + iOException);
            }
        }
    }

    public final int getFontType() {
        return this.fontTypes;
    }

    public String getSubstituteFont() {
        return this.substituteFontName;
    }

    public boolean isValidCodeRange(int n) {
        if (this.CMAP == null) {
            return false;
        }
        return this.CMAP[n] != null;
    }

    public float getGlyphWidth(String string, int n, String string2) {
        if (this.fontTypes == 2) {
            return this.glyphs.getTTWidth(string, n, string2, false);
        }
        return 0.0f;
    }

    public void setSubtype(int n) {
        this.fontTypes = n;
    }

    public void setSubstituted(boolean bl) {
        this.isFontSubstituted = bl;
    }

    public PdfJavaGlyphs getGlyphData() {
        return this.glyphs;
    }

    public Font setFont(String string, int n) {
        return this.glyphs.setFont(string, n);
    }

    public boolean is1C() {
        return this.glyphs.is1C();
    }

    public boolean isFontSubsetted() {
        return this.glyphs.isSubsetted;
    }

    public void setValuesForGlyph(int n, String string, String string2, String string3) {
        this.glyphs.setValuesForGlyph(n, string, string2, string3);
    }

    String cleanupFontName(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '-') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    static {
        PdfFont.setStandardFontMappings();
    }
}

