/*
 * Decompiled with CFR 0.152.
 */
package BlowfishJ;

import BlowfishJ.BinConverter;
import BlowfishJ.BlowfishECB;

public class BlowfishCBC
extends BlowfishECB {
    int m_nIVLo;
    int m_nIVHi;

    public long getCBCIV() {
        return BinConverter.makeLong(this.m_nIVLo, this.m_nIVHi);
    }

    public void getCBCIV(byte[] dest) {
        this.getCBCIV(dest, 0);
    }

    public void getCBCIV(byte[] dest, int nOfs) {
        BinConverter.intToByteArray(this.m_nIVHi, dest, nOfs);
        BinConverter.intToByteArray(this.m_nIVLo, dest, nOfs + 4);
    }

    public void setCBCIV(long lNewCBCIV) {
        this.m_nIVHi = BinConverter.longHi32(lNewCBCIV);
        this.m_nIVLo = BinConverter.longLo32(lNewCBCIV);
    }

    public void setCBCIV(byte[] newCBCIV) {
        this.setCBCIV(newCBCIV, 0);
    }

    public void setCBCIV(byte[] newCBCIV, int nOfs) {
        this.m_nIVHi = BinConverter.byteArrayToInt(newCBCIV, nOfs);
        this.m_nIVLo = BinConverter.byteArrayToInt(newCBCIV, nOfs + 4);
    }

    public BlowfishCBC(byte[] key) {
        super(key);
        this.m_nIVLo = 0;
        this.m_nIVHi = 0;
    }

    public BlowfishCBC(byte[] key, int nOfs, int nLen) {
        super(key, nOfs, nLen);
        this.m_nIVLo = 0;
        this.m_nIVHi = 0;
    }

    public BlowfishCBC(byte[] key, long lInitCBCIV) {
        super(key);
        this.setCBCIV(lInitCBCIV);
    }

    public BlowfishCBC(byte[] key, int nOfs, int nLen, long lInitCBCIV) {
        super(key, nOfs, nLen);
        this.setCBCIV(lInitCBCIV);
    }

    public BlowfishCBC(byte[] key, byte[] initCBCIV) {
        super(key);
        this.setCBCIV(initCBCIV);
    }

    public BlowfishCBC(byte[] key, int nOfs, int nLen, byte[] initCBCIV, int nIVOfs) {
        super(key, nOfs, nLen);
        this.setCBCIV(initCBCIV, nIVOfs);
    }

    public void cleanUp() {
        this.m_nIVLo = 0;
        this.m_nIVHi = 0;
        super.cleanUp();
    }

    public int encrypt(byte[] inBuf, int nInPos, byte[] outBuf, int nOutPos, int nLen) {
        nLen -= nLen % 8;
        int nC = nInPos + nLen;
        int[] pbox = this.m_pbox;
        int nPBox0 = pbox[0];
        int nPBox1 = pbox[1];
        int nPBox2 = pbox[2];
        int nPBox3 = pbox[3];
        int nPBox4 = pbox[4];
        int nPBox5 = pbox[5];
        int nPBox6 = pbox[6];
        int nPBox7 = pbox[7];
        int nPBox8 = pbox[8];
        int nPBox9 = pbox[9];
        int nPBox10 = pbox[10];
        int nPBox11 = pbox[11];
        int nPBox12 = pbox[12];
        int nPBox13 = pbox[13];
        int nPBox14 = pbox[14];
        int nPBox15 = pbox[15];
        int nPBox16 = pbox[16];
        int nPBox17 = pbox[17];
        int[] sbox1 = this.m_sbox1;
        int[] sbox2 = this.m_sbox2;
        int[] sbox3 = this.m_sbox3;
        int[] sbox4 = this.m_sbox4;
        int nIVHi = this.m_nIVHi;
        int nIVLo = this.m_nIVLo;
        while (nInPos < nC) {
            int nHi = inBuf[nInPos++] << 24;
            nHi |= inBuf[nInPos++] << 16 & 0xFF0000;
            nHi |= inBuf[nInPos++] << 8 & 0xFF00;
            nHi |= inBuf[nInPos++] & 0xFF;
            int nLo = inBuf[nInPos++] << 24;
            nLo |= inBuf[nInPos++] << 16 & 0xFF0000;
            nLo |= inBuf[nInPos++] << 8 & 0xFF00;
            nLo |= inBuf[nInPos++] & 0xFF;
            nHi ^= nIVHi;
            nLo ^= nIVLo;
            nLo ^= (sbox1[(nHi ^= nPBox0) >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox1;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox2;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox3;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox4;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox5;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox6;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox7;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox8;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox9;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox10;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox11;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox12;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox13;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox14;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox15;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox16;
            outBuf[nOutPos++] = (byte)((nLo ^= nPBox17) >>> 24);
            outBuf[nOutPos++] = (byte)(nLo >>> 16);
            outBuf[nOutPos++] = (byte)(nLo >>> 8);
            outBuf[nOutPos++] = (byte)nLo;
            outBuf[nOutPos++] = (byte)(nHi >>> 24);
            outBuf[nOutPos++] = (byte)(nHi >>> 16);
            outBuf[nOutPos++] = (byte)(nHi >>> 8);
            outBuf[nOutPos++] = (byte)nHi;
            nIVHi = nLo;
            nIVLo = nHi;
        }
        this.m_nIVHi = nIVHi;
        this.m_nIVLo = nIVLo;
        return nLen;
    }

    public void encrypt(byte[] inBuf, byte[] outBuf) {
        this.encrypt(inBuf, 0, outBuf, 0, outBuf.length);
    }

    public void encrypt(byte[] buf) {
        this.encrypt(buf, 0, buf, 0, buf.length);
    }

    public void encrypt(int[] inBuf, int nInPos, int[] outBuf, int nOutPos, int nLen) {
        int nC = nInPos + nLen;
        while (nInPos < nC) {
            BinConverter.intToByteArray(inBuf[nInPos++], this.m_blockBuf, 0);
            BinConverter.intToByteArray(inBuf[nInPos++], this.m_blockBuf, 4);
            this.encrypt(this.m_blockBuf);
            outBuf[nOutPos++] = BinConverter.byteArrayToInt(this.m_blockBuf, 0);
            outBuf[nOutPos++] = BinConverter.byteArrayToInt(this.m_blockBuf, 4);
        }
    }

    public void encrypt(int[] inBuf, int[] outBuf) {
        this.encrypt(inBuf, 0, outBuf, 0, inBuf.length);
    }

    public void encrypt(int[] buf) {
        this.encrypt(buf, 0, buf, 0, buf.length);
    }

    public void encrypt(long[] inBuf, int nInPos, long[] outBuf, int nOutPos, int nLen) {
        int nC = nInPos + nLen;
        while (nInPos < nC) {
            BinConverter.longToByteArray(inBuf[nInPos++], this.m_blockBuf, 0);
            this.encrypt(this.m_blockBuf);
            outBuf[nOutPos++] = BinConverter.byteArrayToInt(this.m_blockBuf, 0);
        }
    }

    public void encrypt(long[] inBuf, long[] outBuf) {
        this.encrypt(inBuf, 0, outBuf, 0, inBuf.length);
    }

    public void encrypt(long[] buf) {
        this.encrypt(buf, 0, buf, 0, buf.length);
    }

    public int decrypt(byte[] inBuf, int nInPos, byte[] outBuf, int nOutPos, int nLen) {
        nLen -= nLen % 8;
        int nC = nInPos + nLen;
        int[] pbox = this.m_pbox;
        int nPBox0 = pbox[0];
        int nPBox1 = pbox[1];
        int nPBox2 = pbox[2];
        int nPBox3 = pbox[3];
        int nPBox4 = pbox[4];
        int nPBox5 = pbox[5];
        int nPBox6 = pbox[6];
        int nPBox7 = pbox[7];
        int nPBox8 = pbox[8];
        int nPBox9 = pbox[9];
        int nPBox10 = pbox[10];
        int nPBox11 = pbox[11];
        int nPBox12 = pbox[12];
        int nPBox13 = pbox[13];
        int nPBox14 = pbox[14];
        int nPBox15 = pbox[15];
        int nPBox16 = pbox[16];
        int nPBox17 = pbox[17];
        int[] sbox1 = this.m_sbox1;
        int[] sbox2 = this.m_sbox2;
        int[] sbox3 = this.m_sbox3;
        int[] sbox4 = this.m_sbox4;
        int nIVHi = this.m_nIVHi;
        int nIVLo = this.m_nIVLo;
        while (nInPos < nC) {
            int nHi = inBuf[nInPos++] << 24;
            nHi |= inBuf[nInPos++] << 16 & 0xFF0000;
            nHi |= inBuf[nInPos++] << 8 & 0xFF00;
            nHi |= inBuf[nInPos++] & 0xFF;
            int nLo = inBuf[nInPos++] << 24;
            nLo |= inBuf[nInPos++] << 16 & 0xFF0000;
            nLo |= inBuf[nInPos++] << 8 & 0xFF00;
            int n = nInPos++;
            int nTmpHi = nHi;
            int nTmpLo = nLo |= inBuf[n] & 0xFF;
            nLo ^= (sbox1[(nHi ^= nPBox17) >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox16;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox15;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox14;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox13;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox12;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox11;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox10;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox9;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox8;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox7;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox6;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox5;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox4;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox3;
            nLo ^= (sbox1[nHi >>> 24] + sbox2[nHi >>> 16 & 0xFF] ^ sbox3[nHi >>> 8 & 0xFF]) + sbox4[nHi & 0xFF] ^ nPBox2;
            nHi ^= (sbox1[nLo >>> 24] + sbox2[nLo >>> 16 & 0xFF] ^ sbox3[nLo >>> 8 & 0xFF]) + sbox4[nLo & 0xFF] ^ nPBox1;
            nLo ^= nPBox0;
            outBuf[nOutPos++] = (byte)((nLo ^= nIVHi) >>> 24);
            outBuf[nOutPos++] = (byte)(nLo >>> 16);
            outBuf[nOutPos++] = (byte)(nLo >>> 8);
            outBuf[nOutPos++] = (byte)nLo;
            outBuf[nOutPos++] = (byte)((nHi ^= nIVLo) >>> 24);
            outBuf[nOutPos++] = (byte)(nHi >>> 16);
            outBuf[nOutPos++] = (byte)(nHi >>> 8);
            outBuf[nOutPos++] = (byte)nHi;
            nIVHi = nTmpHi;
            nIVLo = nTmpLo;
        }
        this.m_nIVHi = nIVHi;
        this.m_nIVLo = nIVLo;
        return nLen;
    }

    public void decrypt(byte[] inBuf, byte[] outBuf) {
        this.decrypt(inBuf, 0, outBuf, 0, outBuf.length);
    }

    public void decrypt(byte[] buf) {
        this.decrypt(buf, 0, buf, 0, buf.length);
    }

    public void decrypt(int[] inBuf, int nInPos, int[] outBuf, int nOutPos, int nLen) {
        int nC = nInPos + nLen;
        while (nInPos < nC) {
            BinConverter.intToByteArray(inBuf[nInPos++], this.m_blockBuf, 0);
            BinConverter.intToByteArray(inBuf[nInPos++], this.m_blockBuf, 4);
            this.decrypt(this.m_blockBuf);
            outBuf[nOutPos++] = BinConverter.byteArrayToInt(this.m_blockBuf, 0);
            outBuf[nOutPos++] = BinConverter.byteArrayToInt(this.m_blockBuf, 4);
        }
    }

    public void decrypt(int[] inBuf, int[] outBuf) {
        this.decrypt(inBuf, 0, outBuf, 0, inBuf.length);
    }

    public void decrypt(int[] buf) {
        this.decrypt(buf, 0, buf, 0, buf.length);
    }

    public void decrypt(long[] inBuf, int nInPos, long[] outBuf, int nOutPos, int nLen) {
        int nC = nInPos + nLen;
        while (nInPos < nC) {
            BinConverter.longToByteArray(inBuf[nInPos++], this.m_blockBuf, 0);
            this.decrypt(this.m_blockBuf);
            outBuf[nOutPos++] = BinConverter.byteArrayToInt(this.m_blockBuf, 0);
        }
    }

    public void decrypt(long[] inBuf, long[] outBuf) {
        this.decrypt(inBuf, 0, outBuf, 0, inBuf.length);
    }

    public void decrypt(long[] buf) {
        this.decrypt(buf, 0, buf, 0, buf.length);
    }
}

