/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public final class SaveQIFDialog
extends JDialog {
    boolean valid = false;
    PLCash parent;
    private JScrollPane jScrollPane1;
    private JLabel jLabel1;
    public JComboBox accountComboBox;
    public JCheckBox accountListCheckBox;
    private JTextArea instructionsTextArea;
    public JCheckBox securityListCheckBox;
    public JCheckBox allCheckBox;
    private JButton okButton;
    public JCheckBox memorizedCheckBox;
    private JButton cancelButton;
    public JCheckBox categoryListCheckBox;
    public JCheckBox transactionsCheckBox;
    public JCheckBox pricesCheckBox;

    public SaveQIFDialog(PLCash pLCash, boolean bl) {
        super((Frame)pLCash, bl);
        this.parent = pLCash;
        this.initComponents();
        this.setSize(pLCash.getSize().width / 2, pLCash.getSize().height / 2);
        this.setLocationRelativeTo(pLCash);
        this.accountComboBox.addItem("*** All Accounts ***");
        pLCash.accountHandler.setupComboBox(this.accountComboBox, "");
        this.accountComboBox.setSelectedIndex(0);
        this.setup();
    }

    private void setup() {
        String string = "It is generally best to save everything in one file. If you have no reason to do otherwise, save all accounts and all associated lists in one QIF file. This is the easiest format with which to restore all your accounts and lists in another copy of " + "PLCash" + " or another program.\n\nThere are circumstances where it is better to save only one account file or list, but this can produce difficult-to-diagnose problems if it is not done correctly. If you are not sure, save everything in one file.";
        this.instructionsTextArea.setText(string);
        this.instructionsTextArea.setCaretPosition(0);
        this.onAll(true);
    }

    private void onOK() {
        this.valid = true;
        this.setVisible(false);
    }

    private void onCancel() {
        this.setVisible(false);
    }

    private void onAll() {
        this.onAll(this.allCheckBox.isSelected());
    }

    private void onAll(boolean bl) {
        this.allCheckBox.setSelected(bl);
        this.transactionsCheckBox.setSelected(bl);
        this.categoryListCheckBox.setSelected(bl);
        this.securityListCheckBox.setSelected(bl);
        this.accountListCheckBox.setSelected(bl);
        this.memorizedCheckBox.setSelected(bl);
        this.pricesCheckBox.setSelected(bl);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.instructionsTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.accountComboBox = new JComboBox();
        this.transactionsCheckBox = new JCheckBox();
        this.memorizedCheckBox = new JCheckBox();
        this.accountListCheckBox = new JCheckBox();
        this.categoryListCheckBox = new JCheckBox();
        this.securityListCheckBox = new JCheckBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.pricesCheckBox = new JCheckBox();
        this.allCheckBox = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SaveQIFDialog.this.closeDialog(windowEvent);
            }
        });
        this.jScrollPane1.setBorder(new TitledBorder("Helpful Hints"));
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setMargin(new Insets(8, 8, 8, 8));
        this.jScrollPane1.setViewportView(this.instructionsTextArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setText("Choose which accounts:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.accountComboBox, gridBagConstraints);
        this.transactionsCheckBox.setSelected(true);
        this.transactionsCheckBox.setText("Account Transactions");
        this.transactionsCheckBox.setToolTipText("Save transactions for selected account(s)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.transactionsCheckBox, gridBagConstraints);
        this.memorizedCheckBox.setText("Memorized Transactions");
        this.memorizedCheckBox.setToolTipText("Save memorized transactions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.memorizedCheckBox, gridBagConstraints);
        this.accountListCheckBox.setText("Account List");
        this.accountListCheckBox.setToolTipText("Save account list");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.accountListCheckBox, gridBagConstraints);
        this.categoryListCheckBox.setText("Category List");
        this.categoryListCheckBox.setToolTipText("Save list of defined categories");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.categoryListCheckBox, gridBagConstraints);
        this.securityListCheckBox.setText("Security List");
        this.securityListCheckBox.setToolTipText("Save list of defined securities");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.securityListCheckBox, gridBagConstraints);
        this.okButton.setText("Save");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveQIFDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveQIFDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.pricesCheckBox.setText("Prices");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.pricesCheckBox, gridBagConstraints);
        this.allCheckBox.setText("All");
        this.allCheckBox.setToolTipText("Save all items ");
        this.allCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveQIFDialog.this.allCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.allCheckBox, gridBagConstraints);
        this.pack();
    }

    private void allCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.onAll();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.onCancel();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.onOK();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

