/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;

public final class ReportGenerator {
    String cssStyle = "<style type='text/css'>\n<!-- \ntd { padding-right : 2px ; padding-left : 2px ;  }\n.topborder { border-top : 1px solid #000000;  }\n.bottomborder { border-bottom : 1px solid #000000;  }\nbody * { font-size:12px; }\n//-->\n</style>\n";
    PLCash parent;
    ReportGeneratorForm reportForm;
    Account[] accountList = null;
    String[] selectedCategoryList = null;
    String[] fullCategoryList = null;
    String[] rowColors;
    String headerColor;
    String title;
    String reportTitleTag = "<!-- REPORT_TITLE -->";
    int dispRow;
    HashSet selectedCategoryHash = null;
    public String webPage;
    public String tsvPage;
    public double sign = 1.0;
    private String oldCatName = "";
    double[][] matrix;
    int matSumPos;
    int matXSize;
    int matYSize;
    int xWidth;
    double[] categoryTotals;
    double[] overallDebits;
    double[] overallCredits;
    double credits;
    double debits;
    Long[] binDates;
    int type;
    int earliestColumn;
    int latestColumn;
    TreeMap intervalMap;
    long startDate = 0L;
    long endDate = 0L;
    public SearchEngine searchEngine = null;
    Vector transactionList;
    int recordsExamined = 0;
    int matches = 0;
    String[] transactionHeader = new String[]{"Account", "Date", "Number", "Payee", "Category", "Memo", "Cleared", "Price", "Shares", "Commission", "Security", "Amount"};
    String[] transHeaderFieldJustifications = new String[]{"", "align=right", "align=right", "", "", "", "align=center", "align=right", "align=right", "align=right", "", "align=right"};

    public ReportGenerator(PLCash pLCash, ReportGeneratorForm reportGeneratorForm) {
        this.parent = pLCash;
        this.reportForm = reportGeneratorForm;
        this.type = reportGeneratorForm.reportDesign.db_interval;
        this.title = reportGeneratorForm.reportDesign.db_reportTitle;
        this.intervalMap = new TreeMap();
        this.rowColors = new String[]{this.parent.commonCode.toHTMLColorString(this.parent.programValues.db_OddRowColor), this.parent.commonCode.toHTMLColorString(this.parent.programValues.db_EvenRowColor)};
        this.headerColor = this.parent.commonCode.toHTMLColorString(this.parent.programValues.db_HeaderColor);
    }

    public boolean process() {
        this.transactionList = new Vector();
        this.startDate = this.reportForm.reportDesign.db_startDate;
        this.endDate = this.reportForm.reportDesign.db_endDate;
        this.binDates = DateRangeCalculator.computeBinDates(this.type, this.startDate, this.endDate);
        this.accountList = this.reportForm.getAccountList();
        this.selectedCategoryList = this.reportForm.getSelectedCategoryList();
        this.fullCategoryList = this.reportForm.getFullCategoryList();
        this.selectedCategoryHash = this.reportForm.getSelectedCategoryHash();
        if (this.accountList.length == 0) {
            this.reportForm.changeTabs("Accounts");
            JOptionPane.showMessageDialog(null, "Please select at least one account.", "No accounts selected", 0);
            return false;
        }
        if (this.selectedCategoryList.length == 0) {
            this.reportForm.changeTabs("Categories");
            JOptionPane.showMessageDialog(null, "Please select at least one category.", "No categories selected", 0);
            return false;
        }
        if (!this.reportForm.readFilterItems()) {
            this.reportForm.changeTabs("Report");
            JOptionPane.showMessageDialog(null, "Please select at least one transaction type.", "No transaction types selected", 0);
            return false;
        }
        if (this.reportForm.reportDesign.db_enableSearching) {
            this.searchEngine = new SearchEngine(this.parent, this.reportForm);
        }
        for (int i = 0; i < this.accountList.length; ++i) {
            this.processAccount(this.accountList[i]);
        }
        this.webPage = this.reportForm.reportDesign.db_CategoryReportFormat ? this.formatCategoryReport() : this.formatTransactionReport();
        this.tsvPage = this.convertToTSV(this.webPage);
        this.summarizeSearch();
        return true;
    }

    public String summarizeSearch() {
        return "Records examined " + this.recordsExamined + ", matches " + this.matches;
    }

    private void processAccount(Account account) {
        for (int i = 0; i < account.size(); ++i) {
            this.processTransaction(account.getTransaction(i));
        }
    }

    private void processTransaction(Transaction transaction) {
        ++this.recordsExamined;
        long l = transaction.getTime();
        if (l < this.startDate || l > this.endDate) {
            return;
        }
        String string = transaction.db_Category;
        if (string.trim().length() == 0) {
            string = "Uncategorized";
        } else if (string.length() > 0 && string.charAt(0) == '[') {
            string = "Transfer";
        }
        Long l2 = this.getBaseDate(l);
        if (this.selectedCategoryHash.contains(string)) {
            this.insertItemInTree(transaction, l2, string);
        } else {
            String string2 = this.getBaseCategory(string, null);
            if (string2 != null && this.selectedCategoryHash.contains(string2)) {
                this.insertItemInTree(transaction, l2, string);
            }
        }
    }

    private String convertToTSV(String string) {
        String string2 = string.replaceAll("\\n", "");
        string2 = string2.replaceAll(this.reportTitleTag + ".*?" + this.reportTitleTag, "");
        string2 = string2.replaceAll("<title>.*?</title>", "");
        string2 = string2.replaceAll("</td><td.*?>", "\t");
        string2 = string2.replaceAll("</tr>", this.parent.commonCode.eol);
        string2 = string2.replaceAll("<.*?>", "");
        string2 = string2.replaceAll("&nbsp;", " ");
        return string2;
    }

    private boolean filterItems(Transaction transaction) {
        boolean bl = false;
        CategoryItem categoryItem = (CategoryItem)this.parent.categoryHandler.getDataObject(transaction.db_Category);
        if (categoryItem != null && (this.reportForm.reportDesign.db_filterIncomeItem && categoryItem.Income || this.reportForm.reportDesign.db_filterExpenseItem && !categoryItem.Income || this.reportForm.reportDesign.db_filterTaxableItem && categoryItem.TaxRelated)) {
            bl = true;
        }
        if (!bl) {
            bl = transaction.db_Amount < 0.0 ? this.reportForm.reportDesign.db_filterOutlayItem : this.reportForm.reportDesign.db_filterDepositItem;
        }
        if (!bl) {
            boolean bl2 = bl = transaction.db_Category.length() > 0 && transaction.db_Category.charAt(0) == '[' && this.reportForm.reportDesign.db_filterTransferItem;
        }
        if (bl && this.searchEngine != null) {
            bl = this.searchEngine.examine(transaction);
        }
        return bl;
    }

    private Long getBaseDate(long l) {
        int n = 0;
        for (n = this.binDates.length - 1; n >= 0 && l < this.binDates[n]; --n) {
        }
        return this.binDates[n];
    }

    private String getBaseCategory(String string, String string2) {
        int n = string.indexOf(":");
        if (n < 0) {
            return string2;
        }
        return string.substring(0, n);
    }

    private void insertItemInTree(Transaction transaction, Long l, String string) {
        if (this.filterItems(transaction)) {
            this.transactionList.add(transaction);
            ++this.matches;
            if (!this.intervalMap.containsKey(l)) {
                this.intervalMap.put(l, new TreeMap());
            }
            TreeMap treeMap = (TreeMap)this.intervalMap.get(l);
            double d = 0.0;
            if (!treeMap.containsKey(string)) {
                treeMap.put(string, new BalanceItem());
            }
            ((BalanceItem)treeMap.get(string)).add(transaction.db_Amount);
        }
    }

    private void fillMatrix() {
        this.matXSize = this.binDates.length;
        this.matYSize = this.fullCategoryList.length;
        this.overallCredits = new double[this.matXSize + 1];
        this.overallDebits = new double[this.matXSize + 1];
        this.matSumPos = this.matXSize;
        this.matrix = new double[this.matXSize + 1][this.matYSize];
        this.earliestColumn = this.matXSize - 1;
        this.latestColumn = 0;
        for (int i = 0; i < this.matXSize; ++i) {
            Long l = this.binDates[i];
            if (!this.intervalMap.containsKey(l)) continue;
            TreeMap treeMap = (TreeMap)this.intervalMap.get(l);
            this.fillColumn(i, treeMap);
            if (this.earliestColumn > i) {
                this.earliestColumn = i;
            }
            if (this.latestColumn >= i) continue;
            this.latestColumn = i;
        }
    }

    private void fillColumn(int n, TreeMap treeMap) {
        for (int i = 0; i < this.matYSize; ++i) {
            String string = this.fullCategoryList[i];
            if (!treeMap.containsKey(string)) continue;
            double d = ((BalanceItem)treeMap.get(string)).getCreditSum();
            double d2 = ((BalanceItem)treeMap.get(string)).getDebitSum();
            int n2 = n;
            this.overallDebits[n2] = this.overallDebits[n2] + d2;
            int n3 = this.matXSize;
            this.overallDebits[n3] = this.overallDebits[n3] + d2;
            int n4 = n;
            this.overallCredits[n4] = this.overallCredits[n4] + d;
            int n5 = this.matXSize;
            this.overallCredits[n5] = this.overallCredits[n5] + d;
            this.matrix[n][i] = d2 + d;
            double[] dArray = this.matrix[this.matSumPos];
            int n6 = i;
            dArray[n6] = dArray[n6] + this.matrix[n][i];
        }
    }

    private void createCategoryHeaderRow(StringBuffer stringBuffer) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = this.parent.commonCode.wrapTag("b", "Category");
        stringBuffer2.append(this.parent.commonCode.wrapTag("td", "align=center class=bottomborder", string));
        String string2 = "";
        String string3 = "";
        long[] lArray = new long[this.xWidth];
        long[] lArray2 = new long[this.xWidth];
        long l = DateRangeCalculator.baseTimeForTime(this.type, this.startDate);
        for (n = 0; n < this.xWidth; ++n) {
            lArray[n] = l;
            l = DateRangeCalculator.nextPeriodTime(this.type, l, this.endDate);
            lArray2[n] = DateRangeCalculator.addDay(l, -1);
        }
        if (this.type > 0) {
            for (n = this.earliestColumn; n <= this.latestColumn; ++n) {
                l = lArray[n];
                long l2 = lArray2[n];
                string2 = n == 0 ? this.parent.commonCode.displayDateForTime(this.startDate) : this.parent.commonCode.displayDateForTime(l);
                string3 = n == this.matXSize - 1 ? this.parent.commonCode.displayDateForTime(this.endDate) : this.parent.commonCode.displayDateForTime(l2);
                String string4 = string2 + "-<br/>" + string3;
                string4 = this.parent.commonCode.wrapTag("b", string4);
                stringBuffer2.append(this.parent.commonCode.wrapTag("td", "align=center class=bottomborder", string4));
            }
        }
        long l3 = this.startDate < lArray[this.earliestColumn] ? lArray[this.earliestColumn] : this.startDate;
        long l4 = this.endDate > lArray2[this.latestColumn] ? lArray2[this.latestColumn] : this.endDate;
        string2 = this.parent.commonCode.displayDateForTime(l3);
        string3 = this.parent.commonCode.displayDateForTime(l4);
        String string5 = string2 + "-<br/>" + string3;
        string5 = this.parent.commonCode.wrapTag("b", string5);
        stringBuffer2.append(this.parent.commonCode.wrapTag("td", "align=center nowrap class=bottomborder", string5));
        stringBuffer.append(this.parent.commonCode.wrapTag("tr", "bgcolor=" + this.headerColor, stringBuffer2.toString()));
    }

    private String createTransactionHeaderRow() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.transactionHeader.length; ++i) {
            if (!this.reportForm.reportDesign.db_extendedFormat && i >= 7 && i < 11) continue;
            stringBuffer.append(this.parent.commonCode.wrapTag("td", "align=center nowrap class=bottomborder bgcolor=" + this.headerColor, this.parent.commonCode.wrapTag("b", this.transactionHeader[i])));
        }
        return this.parent.commonCode.wrapTag("tr", stringBuffer.toString());
    }

    private String formatTransactionReportCell(int n, String string) {
        if (string.length() == 0) {
            string = "&nbsp;";
        }
        return this.parent.commonCode.wrapTag("td", this.transHeaderFieldJustifications[n] + " nowrap", string);
    }

    private String createTransactionDataRow(Transaction transaction, int n) {
        double d;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.formatTransactionReportCell(0, transaction.acc.db_Name));
        stringBuffer.append(this.formatTransactionReportCell(1, transaction.displayDate));
        stringBuffer.append(this.formatTransactionReportCell(2, transaction.db_Number));
        stringBuffer.append(this.formatTransactionReportCell(3, transaction.db_Payee));
        stringBuffer.append(this.formatTransactionReportCell(4, transaction.db_Category));
        stringBuffer.append(this.formatTransactionReportCell(5, transaction.db_Memo));
        stringBuffer.append(this.formatTransactionReportCell(6, transaction.db_Cleared ? "R" : ""));
        if (this.reportForm.reportDesign.db_extendedFormat) {
            stringBuffer.append(this.formatTransactionReportCell(7, this.formatCurrencyCell2(transaction.db_Price, false, false)));
            stringBuffer.append(this.formatTransactionReportCell(8, this.formatCurrencyCell2(transaction.db_Shares, false, true)));
            stringBuffer.append(this.formatTransactionReportCell(9, this.formatCurrencyCell2(transaction.db_Commission, false, false)));
            stringBuffer.append(this.formatTransactionReportCell(10, transaction.db_Security));
        }
        if ((d = transaction.db_Amount * this.sign) < 0.0) {
            this.debits += d;
        } else {
            this.credits += d;
        }
        stringBuffer.append(this.formatTransactionReportCell(11, this.formatCurrencyCell2(d, false, false)));
        return this.parent.commonCode.wrapTag("tr", "bgcolor=" + this.rowColors[this.dispRow++ % 2], stringBuffer.toString());
    }

    private String formatTransactionReport() {
        Object object;
        Collections.sort(this.transactionList);
        this.credits = 0.0;
        this.debits = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.createTransactionHeaderRow());
        int n = 0;
        for (n = 0; n < this.transactionList.size(); ++n) {
            object = (Transaction)this.transactionList.get(n);
            stringBuffer.append(this.createTransactionDataRow((Transaction)object, n));
        }
        stringBuffer.append(this.makeTotalRow("Credits", this.credits, n++, true));
        stringBuffer.append(this.makeTotalRow("Debits", this.debits, n++, false));
        stringBuffer.append(this.makeTotalRow("Balance", this.credits + this.debits, n++, false));
        object = this.parent.commonCode.wrapTag("table", "border=0 cellSpacing=0", stringBuffer.toString());
        object = this.parent.commonCode.wrapTag("center", (String)object);
        object = this.reportTitleTag + this.pageTitle() + this.reportTitleTag + (String)object;
        object = this.parent.commonCode.wrapTag("body", (String)object);
        object = this.cssStyle + (String)object;
        object = this.parent.commonCode.wrapTag("title", this.title) + (String)object;
        object = this.parent.commonCode.wrapTag("html", (String)object);
        return object;
    }

    private String pageTitle() {
        String string = this.parent.commonCode.wrapTag("h3", this.title);
        string = this.parent.commonCode.wrapTag("center", string);
        return string;
    }

    private String makeTotalRow(String string, double d, int n, boolean bl) {
        int n2;
        String string2 = bl ? " class=topborder" : "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parent.commonCode.wrapTag("td", "nowrap" + string2, this.parent.commonCode.wrapTag("b", string)));
        int n3 = n2 = this.reportForm.reportDesign.db_extendedFormat ? 2 : 6;
        while (n2 < this.transactionHeader.length) {
            stringBuffer.append(this.parent.commonCode.wrapTag("td", string2, "&nbsp;"));
            ++n2;
        }
        stringBuffer.append(this.parent.commonCode.wrapTag("td", "nowrap align=right" + string2, this.formatCurrencyCell2(d, true, false)));
        return this.parent.commonCode.wrapTag("tr", "bgcolor=" + this.rowColors[this.dispRow++ % 2], stringBuffer.toString());
    }

    private int specialXHandling(int n) {
        if (n == this.latestColumn + 1 && this.latestColumn + 1 < this.xWidth - 1) {
            n = this.xWidth - 1;
        }
        return n;
    }

    private int setMaxIndex() {
        return this.latestColumn + (this.type > 0 ? 1 : 0);
    }

    private String formatCategoryReport() {
        int n;
        this.fillMatrix();
        this.dispRow = 0;
        this.categoryTotals = new double[this.matXSize + 1];
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        this.xWidth = this.type == 0 ? this.matXSize : this.matXSize + 1;
        int n2 = this.setMaxIndex();
        for (n = this.earliestColumn; n <= n2; n += 1) {
            stringBuffer2.append(this.parent.commonCode.wrapTag("td", "&nbsp;"));
        }
        this.createCategoryHeaderRow(stringBuffer);
        n = 0;
        boolean bl = false;
        String string = "";
        StringBuffer stringBuffer3 = new StringBuffer();
        for (int i = 0; i < this.matYSize; ++i) {
            String string2;
            CharSequence charSequence;
            boolean bl2;
            string = this.fullCategoryList[i];
            boolean bl3 = bl2 = string.indexOf(":") == -1;
            if (!bl2 && (charSequence = this.getBaseCategory(string, null)) != null && !((String)charSequence).equals(this.oldCatName)) {
                string2 = this.parent.commonCode.wrapTag("td", "nowrap", (String)charSequence) + stringBuffer2.toString();
                stringBuffer3.append(this.parent.commonCode.wrapTag("tr", "bgcolor=" + this.rowColors[this.dispRow++ % 2], string2));
                this.oldCatName = charSequence;
            }
            if (!bl2 && this.matrix[this.matSumPos][i] == 0.0) continue;
            if (this.testForTotal(string, n != 0, bl, false, stringBuffer, stringBuffer3)) {
                stringBuffer3 = new StringBuffer();
                n = 0;
                bl = false;
            }
            charSequence = new StringBuffer();
            string2 = this.mayTab(this.fullCategoryList[i]);
            ((StringBuffer)charSequence).append(this.parent.commonCode.wrapTag("td", "nowrap", string2));
            for (int j = this.earliestColumn; j <= n2; ++j) {
                j = this.specialXHandling(j);
                double d = this.matrix[j][i];
                int n3 = j;
                this.categoryTotals[n3] = this.categoryTotals[n3] + d;
                if (this.categoryTotals[j] != 0.0) {
                    n = 1;
                    if (!bl2) {
                        bl = true;
                    }
                }
                ((StringBuffer)charSequence).append(this.formatCurrencyCell(this.matrix[j][i], false, false, false));
            }
            if (bl2 && !n) {
                stringBuffer3.append(this.parent.commonCode.wrapTag("tr", "bgcolor=" + this.rowColors[this.dispRow % 2], this.parent.commonCode.wrapTag("td", string2) + stringBuffer2.toString()));
            } else {
                stringBuffer3.append(this.parent.commonCode.wrapTag("tr", "bgcolor=" + this.rowColors[this.dispRow % 2], ((StringBuffer)charSequence).toString()));
            }
            ++this.dispRow;
        }
        this.testForTotal(string, n != 0, bl, true, stringBuffer, stringBuffer3);
        this.makeOverallTotalRow(stringBuffer, "Credits", this.overallCredits, null, true);
        this.makeOverallTotalRow(stringBuffer, "Debits", this.overallDebits, null, false);
        this.makeOverallTotalRow(stringBuffer, "Balance", this.overallCredits, this.overallDebits, false);
        String string3 = this.parent.commonCode.wrapTag("table", "border=0 cellspacing=0", stringBuffer.toString());
        string3 = this.parent.commonCode.wrapTag("center", string3);
        string3 = this.reportTitleTag + this.pageTitle() + this.reportTitleTag + string3;
        string3 = this.parent.commonCode.wrapTag("body", string3);
        string3 = this.cssStyle + string3;
        string3 = this.parent.commonCode.wrapTag("title", this.title) + string3;
        string3 = this.parent.commonCode.wrapTag("html", string3);
        return string3;
    }

    private void makeOverallTotalRow(StringBuffer stringBuffer, String string, double[] dArray, double[] dArray2, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = this.parent.commonCode.wrapTag("b", string);
        String string3 = bl ? " class=topBorder" : "";
        stringBuffer2.append(this.parent.commonCode.wrapTag("td", "nowrap " + string3, string2));
        int n = this.setMaxIndex();
        for (int i = this.earliestColumn; i <= n; ++i) {
            i = this.specialXHandling(i);
            double d = dArray[i];
            if (dArray2 != null) {
                d += dArray2[i];
            }
            stringBuffer2.append(this.formatCurrencyCell(d, true, bl, false));
        }
        stringBuffer.append(this.parent.commonCode.wrapTag("tr", "bgcolor=" + this.rowColors[this.dispRow++ % 2] + " nowrap", stringBuffer2.toString()));
    }

    private String mayTab(String string) {
        String string2 = string;
        int n = 0;
        n = string.indexOf(":");
        if (n != -1) {
            string2 = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + string.substring(n + 1);
        }
        return string2;
    }

    private boolean testForTotal(String string, boolean bl, boolean bl2, boolean bl3, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        boolean bl4;
        String string2 = "Total ";
        String string3 = this.getBaseCategory(string, string);
        boolean bl5 = bl4 = bl3 || !string3.equals(this.oldCatName);
        if (bl4) {
            if (bl && this.oldCatName.length() > 0) {
                if (!bl2) {
                    stringBuffer2 = new StringBuffer();
                    string2 = "";
                }
                this.showTotals(string2, this.oldCatName, stringBuffer2);
                stringBuffer.append(stringBuffer2);
            }
            this.oldCatName = string3;
        }
        return bl4;
    }

    private void showTotals(String string, String string2, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string3 = this.parent.commonCode.wrapTag("b", string + string2);
        stringBuffer2.append(this.parent.commonCode.wrapTag("td", "nowrap class=topborder", string + string2));
        int n = this.setMaxIndex();
        for (int i = this.earliestColumn; i <= n; ++i) {
            i = this.specialXHandling(i);
            stringBuffer2.append(this.formatCurrencyCell(this.categoryTotals[i], false, true, false));
        }
        stringBuffer.append(this.parent.commonCode.wrapTag("tr", "bgcolor=" + this.rowColors[this.dispRow % 2], stringBuffer2.toString()));
        ++this.dispRow;
        this.categoryTotals = new double[this.matXSize + 1];
    }

    private String formatCurrencyCell(double d, boolean bl, boolean bl2, boolean bl3) {
        String string = bl2 ? " class=topborder" : "";
        return this.parent.commonCode.wrapTag("td", "align=right nowrap" + string, this.formatCurrencyCell2(d, bl, bl3));
    }

    private String formatCurrencyCell2(double d, boolean bl, boolean bl2) {
        String string = this.parent.commonCode.wrapHTMLColorOnDouble(d, new Color(0, 0, 0), new Color(255, 0, 0), bl2);
        if (bl) {
            string = this.parent.commonCode.wrapTag("b", string);
        }
        return string;
    }
}

