/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public final class QIFFileHandler {
    final int STATE_INIT = 100;
    final int STATE_ACCOUNT = 101;
    final int STATE_TYPE = 102;
    TreeMap transData;
    boolean accountListIncluded = false;
    PLCash parent;

    public QIFFileHandler(PLCash pLCash) {
        this.parent = pLCash;
        this.transData = new TreeMap();
    }

    private void treePut(TreeMap treeMap, String string, String string2) {
        int n = 1;
        String string3 = string;
        while (treeMap.containsKey(string3)) {
            string3 = string + ++n;
        }
        treeMap.put(string3, string2);
    }

    private int getAccType(String string) {
        int n = -1;
        if (string != null && string != "") {
            String[] stringArray = string.split(":");
            if (stringArray.length >= 2) {
                String string2 = stringArray[1];
                n = Account.typeForTag(string2);
            }
            if (n < 0) {
                // empty if block
            }
        }
        return n;
    }

    private void readAllQIFLines(File file) {
        try {
            String string;
            String string2 = this.parent.programValues.db_DataFilePath;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Account account = new Account(this.parent);
            int n = 101;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() <= 0) continue;
                char c = string.charAt(0);
                String string3 = string.substring(1);
                if (c == '!') {
                    int n2;
                    if (string3.equals("Option:AutoSwitch")) {
                        bl = true;
                        continue;
                    }
                    if (string3.equals("Clear:AutoSwitch")) {
                        bl = false;
                        continue;
                    }
                    if (string3.equals("Account")) {
                        n = 101;
                        this.writeQIFGenAccount(string2, account, file);
                        account = new Account(this.parent);
                        account.acctQIFData = new TreeMap();
                        this.transData.clear();
                        continue;
                    }
                    if (string3.indexOf("Type:") != 0 || (n2 = this.getAccType(string3)) < 0) continue;
                    if (n != 101) {
                        this.writeQIFGenAccount(string2, account, file);
                        account = new Account(this.parent);
                        account.acctQIFData = new TreeMap();
                    }
                    account.setType(n2);
                    switch (n2) {
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            this.parent.accountHandler.removeAccount(account.db_Name);
                            break;
                        }
                        default: {
                            this.parent.accountHandler.addAccount(account.db_Name, account, string2);
                        }
                    }
                    n = n2;
                    this.transData.clear();
                    continue;
                }
                switch (n) {
                    case 101: {
                        if (c == '^') {
                            this.parent.accountHandler.setAccountInfoFromQIFData(account, account.acctQIFData);
                        } else if (c == 'N') {
                            Account account2 = this.parent.accountHandler.getAccountByName(string3 = string3.trim());
                            if (account2 != null) {
                                account = account2;
                            } else {
                                account = new Account(this.parent);
                                account.acctQIFData = new TreeMap();
                                this.parent.accountHandler.addAccount(string3, account, string2);
                            }
                        }
                        if (account.acctQIFData == null) {
                            account.acctQIFData = new TreeMap();
                        }
                        this.treePut(account.acctQIFData, "" + c, string3);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (c == '^') {
                            account.createFromQIFData(this.transData);
                            this.transData.clear();
                            break;
                        }
                        this.treePut(this.transData, "" + c, string3);
                        break;
                    }
                    case 9: {
                        if (c == '^') {
                            this.parent.memHandler.createFromQIFData(this.transData);
                            this.transData.clear();
                            break;
                        }
                        this.treePut(this.transData, "" + c, string3);
                        break;
                    }
                    case 7: {
                        if (c == '^') {
                            this.parent.categoryHandler.createFromQIFData(this.transData);
                            this.transData.clear();
                            break;
                        }
                        this.treePut(this.transData, "" + c, string3);
                        break;
                    }
                    case 8: {
                        if (c == '^') {
                            this.parent.securityHandler.createFromQIFData(this.transData);
                            this.transData.clear();
                            break;
                        }
                        this.treePut(this.transData, "" + c, string3);
                        break;
                    }
                    case 10: {
                        if (c == '^') {
                            this.parent.pricesHandler.createFromQIFData(this.transData);
                            this.transData.clear();
                            break;
                        }
                        this.treePut(this.transData, "" + c, string3);
                        break;
                    }
                }
            }
            this.writeQIFGenAccount(string2, account, file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeQIFGenAccount(String string, Account account, File file) {
        String string2;
        if (account == null || account.transactionList.size() == 0) {
            return;
        }
        for (string2 = account.db_Name; string2 == null || string2.length() == 0; string2 = string2.trim()) {
            AccountNameDialog accountNameDialog = new AccountNameDialog((Frame)this.parent, true);
            string2 = accountNameDialog.go(file.toString());
        }
        account.db_Name = string2;
        if ((account = this.parent.accountHandler.addAccount(account.db_Name, account, string)) == null) {
            return;
        }
        account.getBalance();
        account.setDataChanged();
        account.setFileRead();
        account.writeTSV();
        account.transactionList.clear();
        account.clearDataChanged();
        account.clearFileRead();
    }

    public static void readQIFFile(File file, PLCash pLCash) {
        QIFFileHandler qIFFileHandler = new QIFFileHandler(pLCash);
        qIFFileHandler.readAllQIFLines(file);
    }

    public static void importQIF(PLCash pLCash) {
        JFileChooser jFileChooser = new JFileChooser();
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        exampleFileFilter.addExtension("qif");
        exampleFileFilter.addExtension("QIF");
        exampleFileFilter.setDescription("QIF data files");
        jFileChooser.setFileFilter(exampleFileFilter);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setCurrentDirectory(new File(pLCash.programValues.db_QIFFilePath));
        jFileChooser.setDialogTitle("Import QIF data File(s)");
        int n = jFileChooser.showOpenDialog(pLCash);
        if (n == 0) {
            pLCash.programValues.db_QIFFilePath = jFileChooser.getCurrentDirectory().toString();
            QIFFileHandler.readQIFFile(jFileChooser.getSelectedFile(), pLCash);
            pLCash.accountEditorPane.refreshLists();
            pLCash.updatePrices();
            pLCash.accountPanel.setupTable();
        }
    }

    public static void exportQIF(PLCash pLCash) {
        JFileChooser jFileChooser = new JFileChooser();
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        exampleFileFilter.addExtension("qif");
        exampleFileFilter.addExtension("QIF");
        exampleFileFilter.setDescription("QIF data files");
        jFileChooser.setFileFilter(exampleFileFilter);
        jFileChooser.setCurrentDirectory(new File(pLCash.programValues.db_QIFFilePath));
        jFileChooser.setDialogTitle("Export QIF data File");
        int n = jFileChooser.showSaveDialog(pLCash);
        if (n == 0) {
            int n2;
            boolean bl = jFileChooser.getSelectedFile().exists();
            if (bl && (n2 = JOptionPane.showConfirmDialog(pLCash, "The file\n" + jFileChooser.getSelectedFile().toString() + "\nalready exists. OK to overwrite?", "File Exists", 1)) != 0) {
                return;
            }
            SaveQIFDialog saveQIFDialog = new SaveQIFDialog(pLCash, true);
            saveQIFDialog.setVisible(true);
            if (saveQIFDialog.valid) {
                pLCash.programValues.db_QIFFilePath = jFileChooser.getCurrentDirectory().toString();
                QIFFileHandler.writeQIFFile(jFileChooser.getSelectedFile(), pLCash, saveQIFDialog);
            }
            saveQIFDialog.dispose();
        }
    }

    public static void writeQIFFile(File file, PLCash pLCash, SaveQIFDialog saveQIFDialog) {
        QIFFileHandler qIFFileHandler = new QIFFileHandler(pLCash);
        qIFFileHandler.createQIFFile(file, saveQIFDialog);
    }

    private void appendStrLF(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
        stringBuffer.append(this.parent.commonCode.lineSep);
    }

    private void assembleQIFTag(StringBuffer stringBuffer, String string, double d) {
        stringBuffer.append(string);
        stringBuffer.append(String.format("%.4f", d));
        stringBuffer.append(this.parent.commonCode.lineSep);
    }

    private void assembleQIFTag(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(this.parent.commonCode.lineSep);
    }

    private void assembleQIFTagIfNonZero(StringBuffer stringBuffer, String string, double d) {
        if (d > 0.0) {
            this.assembleQIFTag(stringBuffer, string, d);
        }
    }

    private void assembleQIFTagIfExists(StringBuffer stringBuffer, String string, String string2) {
        if (string2.length() > 0) {
            this.assembleQIFTag(stringBuffer, string, string2);
        }
    }

    private void assembleQIFFlag(StringBuffer stringBuffer, String string, boolean bl) {
        if (bl) {
            stringBuffer.append(string);
            stringBuffer.append(this.parent.commonCode.lineSep);
        }
    }

    private void createAccountListEntry(StringBuffer stringBuffer, Account account) {
        this.assembleQIFTag(stringBuffer, "N", account.db_Name);
        this.assembleQIFTag(stringBuffer, "T", account.db_SubType);
        this.assembleQIFTag(stringBuffer, "D", account.db_Description);
        this.assembleQIFTagIfNonZero(stringBuffer, "L", account.db_CreditLimit);
        this.appendStrLF(stringBuffer, "^");
    }

    private void createTransactionListHeaderEntry(StringBuffer stringBuffer, Account account) {
        this.assembleQIFTag(stringBuffer, "N", account.db_Name);
        this.assembleQIFTag(stringBuffer, "D", account.db_Description);
        this.assembleQIFTag(stringBuffer, "T", Account.tagForType(account.type));
        this.assembleQIFTagIfNonZero(stringBuffer, "L", account.db_CreditLimit);
        this.appendStrLF(stringBuffer, "^");
    }

    private void createAccountTransactionEntry(StringBuffer stringBuffer, Transaction transaction, Account account) {
        this.assembleQIFTag(stringBuffer, "D", this.parent.commonCode.qifDateStringForTime(transaction.getTime(), false));
        this.assembleQIFTagIfExists(stringBuffer, "N", transaction.db_Number);
        double d = transaction.db_Amount;
        if (account.type == 3) {
            d = Math.abs(d);
            this.assembleQIFTagIfExists(stringBuffer, "Y", transaction.db_Security);
            this.assembleQIFTag(stringBuffer, "I", transaction.db_Price);
            this.assembleQIFTag(stringBuffer, "Q", Math.abs(transaction.db_Shares));
            this.assembleQIFTagIfNonZero(stringBuffer, "O", transaction.db_Commission);
            this.assembleQIFTag(stringBuffer, "$", d);
        }
        this.assembleQIFTag(stringBuffer, "U", d);
        this.assembleQIFTag(stringBuffer, "T", d);
        this.assembleQIFTag(stringBuffer, "C", transaction.db_Cleared ? "X" : "");
        this.assembleQIFTagIfExists(stringBuffer, "P", transaction.db_Payee);
        this.assembleQIFTagIfExists(stringBuffer, "L", transaction.db_Category);
        this.assembleQIFTagIfExists(stringBuffer, "M", transaction.db_Memo);
        this.assembleAddress(stringBuffer, "A", transaction.db_Address);
        if (transaction.splits != null) {
            for (int i = 0; i < transaction.splits.size(); ++i) {
                Transaction transaction2 = (Transaction)transaction.splits.get(i);
                this.assembleQIFTag(stringBuffer, "S", transaction2.db_Category);
                this.assembleQIFTag(stringBuffer, "E", transaction2.db_Memo);
                this.assembleQIFTag(stringBuffer, "$", transaction2.db_Amount);
            }
        }
        this.appendStrLF(stringBuffer, "^");
    }

    private void oneAccountTransactionList(StringBuffer stringBuffer, String string) {
        Account account = this.parent.accountHandler.getAccountByName(string);
        if (account != null) {
            if (this.accountListIncluded) {
                this.appendStrLF(stringBuffer, "!Account");
                this.createTransactionListHeaderEntry(stringBuffer, account);
                this.appendStrLF(stringBuffer, "!Type:" + Account.tagForType(account.type));
            }
            int n = account.getTransactionList().size();
            for (int i = 0; i < n; ++i) {
                Transaction transaction = account.getTransaction(i);
                this.createAccountTransactionEntry(stringBuffer, transaction, account);
            }
        }
    }

    private void allAccountsTransactionList(StringBuffer stringBuffer) {
        String[] stringArray = this.parent.accountHandler.getAccountNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.oneAccountTransactionList(stringBuffer, stringArray[i]);
        }
    }

    private void createCategoryItemTag(StringBuffer stringBuffer, CategoryItem categoryItem) {
        this.assembleQIFTag(stringBuffer, "N", categoryItem.Category);
        this.assembleQIFTagIfExists(stringBuffer, "D", categoryItem.Description);
        this.assembleQIFFlag(stringBuffer, "T", categoryItem.TaxRelated);
        this.assembleQIFFlag(stringBuffer, "I", categoryItem.Income);
        this.assembleQIFTagIfNonZero(stringBuffer, "B", categoryItem.BudgetAmount);
        this.assembleQIFTagIfExists(stringBuffer, "R", categoryItem.TaxSchedInfo);
        this.appendStrLF(stringBuffer, "^");
    }

    private void createCategoryList(StringBuffer stringBuffer, TreeMap treeMap) {
        String[] stringArray = treeMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            this.createCategoryItemTag(stringBuffer, (CategoryItem)treeMap.get(stringArray[i]));
        }
    }

    private void createSecurityItemTag(StringBuffer stringBuffer, SecurityItem securityItem) {
        this.appendStrLF(stringBuffer, "!Type:Security");
        this.assembleQIFTag(stringBuffer, "N", securityItem.Security);
        this.assembleQIFTag(stringBuffer, "S", securityItem.Symbol);
        this.assembleQIFTag(stringBuffer, "T", securityItem.Type);
        this.appendStrLF(stringBuffer, "^");
    }

    private void createSecurityList(StringBuffer stringBuffer, TreeMap treeMap) {
        String[] stringArray = treeMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            this.createSecurityItemTag(stringBuffer, (SecurityItem)treeMap.get(stringArray[i]));
        }
    }

    private void createPricesItemTag(StringBuffer stringBuffer, PricesItem pricesItem) {
        this.appendStrLF(stringBuffer, "!Type:Prices");
        stringBuffer.append("\"" + pricesItem.db_Symbol + "\"");
        stringBuffer.append("," + String.valueOf(pricesItem.db_Price) + ",");
        stringBuffer.append("\"" + this.parent.commonCode.qifDateStringForTime(pricesItem.getTime(), true) + "\"" + this.parent.commonCode.lineSep);
        this.appendStrLF(stringBuffer, "^");
    }

    private void createPricesList(StringBuffer stringBuffer, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.createPricesItemTag(stringBuffer, (PricesItem)vector.get(i));
        }
    }

    private void assembleAddress(StringBuffer stringBuffer, String string, String string2) {
        if (string2.length() > 0) {
            String[] stringArray = string2.split("\\\\n");
            for (int i = 0; i < stringArray.length; ++i) {
                this.assembleQIFTag(stringBuffer, string, stringArray[i]);
            }
        }
    }

    private void createMemorizedItemTag(StringBuffer stringBuffer, MemorizedItem memorizedItem) {
        this.assembleQIFTag(stringBuffer, "K", memorizedItem.Type);
        this.assembleQIFTag(stringBuffer, "T", memorizedItem.Amount);
        this.assembleQIFTag(stringBuffer, "C", memorizedItem.Cleared ? "X" : "");
        this.assembleQIFTag(stringBuffer, "P", memorizedItem.Payee);
        this.assembleQIFTag(stringBuffer, "L", memorizedItem.Category);
        this.assembleQIFTag(stringBuffer, "M", memorizedItem.Memo);
        this.assembleAddress(stringBuffer, "A", memorizedItem.Address);
        if (memorizedItem.getSplits() != null) {
            for (int i = 0; i < memorizedItem.getSplits().size(); ++i) {
                Transaction transaction = (Transaction)memorizedItem.getSplits().get(i);
                this.assembleQIFTag(stringBuffer, "S", transaction.db_Category);
                this.assembleQIFTag(stringBuffer, "E", transaction.db_Memo);
                this.assembleQIFTag(stringBuffer, "$", transaction.db_Amount);
            }
        }
        this.appendStrLF(stringBuffer, "^");
    }

    private void createMemorizedList(StringBuffer stringBuffer, TreeMap treeMap) {
        String[] stringArray = treeMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            this.createMemorizedItemTag(stringBuffer, (MemorizedItem)treeMap.get(stringArray[i]));
        }
    }

    private void createQIFFile(File file, SaveQIFDialog saveQIFDialog) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        this.accountListIncluded = saveQIFDialog.accountListCheckBox.isSelected();
        if (saveQIFDialog.categoryListCheckBox.isSelected()) {
            this.appendStrLF(stringBuffer, "!Type:Cat");
            this.createCategoryList(stringBuffer, this.parent.categoryHandler.dataMap);
        }
        if (this.accountListIncluded) {
            this.appendStrLF(stringBuffer, "!Option:AutoSwitch");
            this.appendStrLF(stringBuffer, "!Account");
            object = this.parent.accountHandler.getAccountNames();
            for (int i = 0; i < ((String[])object).length; ++i) {
                Account account = this.parent.accountHandler.getAccountByName(object[i]);
                this.createAccountListEntry(stringBuffer, account);
            }
            this.appendStrLF(stringBuffer, "!Clear:AutoSwitch");
        }
        if (saveQIFDialog.securityListCheckBox.isSelected()) {
            this.createSecurityList(stringBuffer, this.parent.securityHandler.dataMap);
        }
        if (saveQIFDialog.transactionsCheckBox.isSelected()) {
            if (this.accountListIncluded) {
                this.appendStrLF(stringBuffer, "!Option:AutoSwitch");
            }
            if (saveQIFDialog.accountComboBox.getSelectedIndex() == 0) {
                this.allAccountsTransactionList(stringBuffer);
            } else {
                object = (String)saveQIFDialog.accountComboBox.getSelectedItem();
                object = ((String)object).replaceFirst("(\\[)(.*)(\\])", "$2");
                this.oneAccountTransactionList(stringBuffer, (String)object);
            }
        }
        if (saveQIFDialog.memorizedCheckBox.isSelected()) {
            this.appendStrLF(stringBuffer, "!Type:Memorized");
            this.createMemorizedList(stringBuffer, this.parent.memHandler.dataMap);
        }
        if (saveQIFDialog.pricesCheckBox.isSelected()) {
            this.createPricesList(stringBuffer, this.parent.pricesHandler.dataVector);
        }
        try {
            object = new FileWriter(file);
            ((Writer)object).write(stringBuffer.toString());
            ((OutputStreamWriter)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void decodeAddress(TreeMap treeMap, Transaction transaction) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        String string = "";
        while (treeMap.containsKey("A" + string)) {
            stringBuffer.append((String)treeMap.get("A" + string) + "\\n");
            string = String.valueOf(++n);
        }
        if (stringBuffer.length() > 0) {
            transaction.db_Address = stringBuffer.toString();
        }
    }

    public void decodeSplits(TreeMap treeMap, Transaction transaction) {
        int n = 1;
        String string = "";
        while (treeMap.containsKey("S" + string)) {
            String string2 = this.parent.commonCode.safeTreeGet(treeMap, "S" + string);
            String string3 = this.parent.commonCode.safeTreeGet(treeMap, "E" + string);
            String string4 = this.parent.commonCode.safeTreeGet(treeMap, "$" + string);
            double d = this.parent.commonCode.zeroFailParseDouble(string4);
            Transaction transaction2 = new Transaction(this.parent, transaction.acc, transaction.getTime(), string2, string3, d);
            transaction.addSplit(transaction2, true, false);
            string = String.valueOf(++n);
        }
    }
}

