/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JComboBox;

public final class PriorityComboBox
extends JComboBox {
    public boolean busy = false;
    private final int maxItems = 64;

    PriorityComboBox() {
        this.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PriorityComboBox.this.processKey(keyEvent);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PriorityComboBox.this.traceAction(actionEvent);
            }
        });
    }

    private void traceAction(ActionEvent actionEvent) {
    }

    private void processKey(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n') {
            String string = this.getEditor().getItem().toString();
            this.setSelectedItem(string);
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        this.addItemToList(object);
        this.fireActionEvent();
    }

    public void addItemToList(Object object) {
        if (!this.busy) {
            this.busy = true;
            String string = object.toString();
            if (this.getItemCount() > 0) {
                this.deleteItem2(string);
                this.insertItemAt(object, 0);
            } else {
                this.addItem(object);
            }
            this.trimList();
            super.setSelectedItem(object);
            this.busy = false;
        }
    }

    private void trimList() {
        while (this.getItemCount() > 64) {
            this.removeItemAt(this.getItemCount() - 1);
        }
    }

    public void deleteItem(String string) {
        if (!this.busy) {
            this.busy = true;
            this.deleteItem2(string);
            this.busy = false;
        }
    }

    private void deleteItem2(String string) {
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            if (!string.equals(this.getItemAt(i).toString())) continue;
            this.removeItemAt(i);
        }
    }

    public void setDataList(Object[] objectArray) {
        this.busy = true;
        this.removeAllItems();
        for (int i = 0; i < objectArray.length; ++i) {
            this.addItem(objectArray[i]);
        }
        this.trimList();
        if (this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
        this.busy = false;
    }

    public String[] getDataList() {
        Vector vector = new Vector();
        for (int i = 0; i < this.getItemCount(); ++i) {
            vector.add(this.getItemAt(i));
        }
        return vector.toArray(new String[vector.size()]);
    }
}

