/*
 * Decompiled with CFR 0.152.
 */
public final class NumberAsWords {
    static final String[] mil_orders = new String[]{"", "Thousand", "Million", "Trillion"};
    static final String[] digits = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"};
    static final String[] tens = new String[]{"", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"};

    private static String createHundreds(long l) {
        String string = "";
        if (l >= 100L) {
            string = NumberAsWords.createHundreds(l / 100L);
            string = string + "Hundred ";
        }
        if ((l %= 100L) >= 20L) {
            string = string + tens[(int)l / 10];
            if (l % 10L != 0L) {
                string = string + "-" + digits[(int)(l % 10L)];
            }
            string = string + " ";
        } else if (l != 0L) {
            string = string + digits[(int)l] + " ";
        }
        return string;
    }

    private static String recurseConvert(long l, int n) {
        String string = "";
        if (n == 0) {
            String string2;
            if (l >= 100L) {
                string = NumberAsWords.recurseConvert(l / 100L, n + 1);
            }
            if ((string2 = "" + l % 100L).length() < 2) {
                string2 = "0" + string2;
            }
            string = string + "and " + string2 + "/100";
        } else {
            if (l >= 1000L) {
                string = NumberAsWords.recurseConvert(l / 1000L, n + 1);
                string = string + mil_orders[n] + " ";
            }
            if (l % 1000L != 0L) {
                string = string + NumberAsWords.createHundreds(l % 1000L);
            }
        }
        return string;
    }

    public static String convert(double d) {
        d = Math.abs(d);
        String string = "";
        long l = (long)((d + 0.005) * 100.0);
        string = NumberAsWords.recurseConvert(l, 0);
        return string;
    }
}

