/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public final class NewCategoryDialog
extends JDialog {
    String helpString = "To create a new category, choose a parent category if you want the new category to have a parent, type in a category name, check the other options, then press \"Accept.\"\n\nYou can change these values later using the category editor at \"Files ... View/Edit lists ... Category List\".";
    PLCash parent;
    String parentCategory = "";
    boolean valid = false;
    boolean createdCategory = false;
    CategoryItem item = null;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JComboBox parentCatComboBox;
    private JCheckBox incomeCheckBox;
    private JLabel jLabel2;
    private JTextField taxSchedTextField;
    private JButton okButton;
    private JCheckBox taxRelatedCheckBox;
    private JTextField newCatTextField;
    private JButton cancelButton;
    private JTextArea helpTextArea;
    private JPanel jPanel1;
    private JTextField budgetTextField;
    private JTextField descriptionTextField;
    private JLabel jLabel5;

    public NewCategoryDialog(PLCash pLCash, boolean bl) {
        super((Frame)pLCash, bl);
        this.parent = pLCash;
        this.initComponents();
        this.setSize(pLCash.getSize().width / 2, pLCash.getSize().height / 2);
        this.setLocationRelativeTo(pLCash);
        this.setTitle("New Category");
    }

    public void display(String string) {
        this.helpTextArea.setText(this.helpString);
        String[] stringArray = this.parent.categoryHandler.getCategoryList(true, true, true, false);
        Vector<String> vector = new Vector<String>();
        vector.add("");
        vector.addAll(Arrays.asList(stringArray));
        this.parentCatComboBox.setModel(new DefaultComboBoxModel(vector));
        this.parentCatComboBox.setSelectedIndex(0);
        String[] stringArray2 = string.split(":");
        if (stringArray2 != null) {
            if (stringArray2.length == 1) {
                this.newCatTextField.setText(stringArray2[0]);
            } else if (stringArray2.length > 1) {
                this.parentCatComboBox.setSelectedItem(stringArray2[0]);
                this.parentCategory = stringArray2[0];
                this.newCatTextField.setText(stringArray2[1]);
            }
        }
        this.setVisible(true);
    }

    private void onOK() {
        String string;
        Object object = this.parentCatComboBox.getSelectedItem();
        String string2 = "";
        if (object != null && (string = (String)object).length() > 0) {
            string2 = string + ":";
        }
        if ((string = this.newCatTextField.getText()).length() > 0) {
            this.item = new CategoryItem(string2 + string);
            this.item.Description = this.descriptionTextField.getText();
            this.item.TaxSchedInfo = this.taxSchedTextField.getText();
            this.item.TaxRelated = this.taxRelatedCheckBox.isSelected();
            this.item.Income = this.incomeCheckBox.isSelected();
            this.item.BudgetAmount = this.parent.commonCode.zeroFailParseDouble(this.budgetTextField.getText());
            this.parent.categoryHandler.addCategory(this.item);
            if (this.parentCategory.length() > 0 && !this.parent.categoryHandler.keyExists(this.parentCategory)) {
                CategoryItem categoryItem = CategoryItem.clone(this.item);
                categoryItem.Category = this.parentCategory;
                this.parent.categoryHandler.addCategory(categoryItem);
            }
            this.createdCategory = true;
            this.valid = true;
        }
        this.setVisible(false);
    }

    private void onCancel() {
        this.setVisible(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new MyJButton();
        this.cancelButton = new MyJButton();
        this.parentCatComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.newCatTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.descriptionTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.taxSchedTextField = new JTextField();
        this.taxRelatedCheckBox = new JCheckBox();
        this.incomeCheckBox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.helpTextArea = new JTextArea();
        this.jLabel5 = new JLabel();
        this.budgetTextField = new JTextField();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewCategoryDialog.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("Create a new category"));
        this.okButton.setText("Accept");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewCategoryDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewCategoryDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.cancelButton, gridBagConstraints);
        this.parentCatComboBox.setToolTipText("Select an optional parent category");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.parentCatComboBox, gridBagConstraints);
        this.jLabel1.setText("Parent category:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("New category name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.newCatTextField.setToolTipText("Enter the new category name here");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.newCatTextField, gridBagConstraints);
        this.jLabel3.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.descriptionTextField.setToolTipText("Optional description of this category");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.descriptionTextField, gridBagConstraints);
        this.jLabel4.setText("Tax Schedule Info:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.taxSchedTextField.setToolTipText("Tax schedule, if applicable");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.taxSchedTextField, gridBagConstraints);
        this.taxRelatedCheckBox.setText("Tax-related");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.jPanel1.add((Component)this.taxRelatedCheckBox, gridBagConstraints);
        this.incomeCheckBox.setText("Income");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.jPanel1.add((Component)this.incomeCheckBox, gridBagConstraints);
        this.helpTextArea.setEditable(false);
        this.helpTextArea.setLineWrap(true);
        this.helpTextArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.helpTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel5.setText("Budget Amount:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.budgetTextField, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.onOK();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.onCancel();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

