/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.threads;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ReaderWriterLock {
    private ArrayList waiters = new ArrayList();

    private int firstWriter() {
        Iterator e = ((AbstractList)this.waiters).iterator();
        int index = 0;
        while (e.hasNext()) {
            ReaderWriterNode node = (ReaderWriterNode)e.next();
            if (node.state == 1) {
                return index;
            }
            ++index;
        }
        return Integer.MAX_VALUE;
    }

    private int getIndex(Thread t) {
        Iterator e = ((AbstractList)this.waiters).iterator();
        int index = 0;
        while (e.hasNext()) {
            ReaderWriterNode node = (ReaderWriterNode)e.next();
            if (node.t == t) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public synchronized void lockRead() {
        ReaderWriterNode node;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            class Org_jfree_threads_ReaderWriterLock$1 {
                /* synthetic */ Org_jfree_threads_ReaderWriterLock$1() {
                }
            }
            node = new ReaderWriterNode(null, me, 0);
            this.waiters.add(node);
        } else {
            node = (ReaderWriterNode)this.waiters.get(index);
        }
        while (this.getIndex(me) > this.firstWriter()) {
            try {
                this.wait();
            }
            catch (Exception e) {
                System.err.println("ReaderWriterLock.lockRead(): exception.");
                System.err.print(e.getMessage());
            }
        }
        ++node.nAcquires;
    }

    public synchronized void lockWrite() {
        ReaderWriterNode node;
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index == -1) {
            node = new ReaderWriterNode(null, me, 1);
            this.waiters.add(node);
        } else {
            node = (ReaderWriterNode)this.waiters.get(index);
            if (node.state == 0) {
                throw new IllegalArgumentException("Upgrade lock");
            }
            node.state = 1;
        }
        while (this.getIndex(me) != 0) {
            try {
                this.wait();
            }
            catch (Exception e) {
                System.err.println("ReaderWriterLock.lockWrite(): exception.");
                System.err.print(e.getMessage());
            }
        }
        ++node.nAcquires;
    }

    public synchronized void unlock() {
        Thread me = Thread.currentThread();
        int index = this.getIndex(me);
        if (index > this.firstWriter()) {
            throw new IllegalArgumentException("Lock not held");
        }
        ReaderWriterNode node = (ReaderWriterNode)this.waiters.get(index);
        --node.nAcquires;
        if (node.nAcquires == 0) {
            this.waiters.remove(index);
        }
        this.notifyAll();
    }

    private static class ReaderWriterNode {
        protected static final int READER = 0;
        protected static final int WRITER = 1;
        protected Thread t;
        protected int state;
        protected int nAcquires;

        private ReaderWriterNode(Thread t, int state) {
            this.t = t;
            this.state = state;
            this.nAcquires = 0;
        }

        /* synthetic */ ReaderWriterNode(1 $0, Thread $1, int $2) {
            this($1, $2);
        }
    }
}

