/*
 * Decompiled with CFR 0.152.
 */
package com.tictactec.ta.lib.meta;

import com.tictactec.ta.lib.Core;
import com.tictactec.ta.lib.RetCode;
import com.tictactec.ta.lib.meta.TaFuncClosure;
import com.tictactec.ta.lib.meta.TaFuncMetaInfo;
import com.tictactec.ta.lib.meta.TaFuncSignature;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreMetaInfo {
    static final Class coreClass = Core.class;
    static final String LOOKBACK_SUFFIX = "_Lookback";
    static final String INT_PREFIX = "INT_";
    Map<TaFuncSignature, TaFuncMetaInfo> taFuncMap = this.getTaFuncMetaInfoMap();

    protected Map<String, Method> getLookbackMethodMap() {
        Method[] ms;
        HashMap<String, Method> map = new HashMap<String, Method>();
        Method[] methodArray = ms = coreClass.getDeclaredMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Method m = methodArray[n];
            if (m.getName().endsWith(LOOKBACK_SUFFIX)) {
                map.put(m.getName(), m);
            }
            ++n;
        }
        return map;
    }

    protected Map<TaFuncSignature, TaFuncMetaInfo> getTaFuncMetaInfoMap() {
        TreeMap<TaFuncSignature, TaFuncMetaInfo> result = new TreeMap<TaFuncSignature, TaFuncMetaInfo>();
        Method[] ms = coreClass.getDeclaredMethods();
        Map<String, Method> lookbackMap = this.getLookbackMethodMap();
        Method[] methodArray = ms;
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            String lookbackName;
            Method lookbackMethod;
            Method taMethod = methodArray[n];
            String fn = taMethod.getName();
            if (taMethod.getReturnType().equals(RetCode.class) && !fn.startsWith(INT_PREFIX) && (lookbackMethod = lookbackMap.get(lookbackName = String.valueOf(fn) + LOOKBACK_SUFFIX)) != null) {
                TaFuncMetaInfo mi = new TaFuncMetaInfo(fn, taMethod, lookbackMethod);
                result.put(mi, mi);
            }
            ++n;
        }
        return result;
    }

    public Collection<TaFuncMetaInfo> getAllFuncs() {
        return this.taFuncMap.values();
    }

    public TaFuncMetaInfo get(String taName, Class[] inVarTypes) {
        return this.taFuncMap.get(new TaFuncSignature(taName, inVarTypes));
    }

    public void forEach(TaFuncClosure closure) throws Exception {
        for (TaFuncMetaInfo mi : this.getAllFuncs()) {
            closure.execute(mi);
        }
    }

    public static void main(String[] args) {
        CoreMetaInfo mi = new CoreMetaInfo();
        Collection<TaFuncMetaInfo> fs = mi.getAllFuncs();
        int i = 0;
        for (TaFuncMetaInfo f : fs) {
            System.out.println(" " + i++ + " " + f);
        }
    }
}

