/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.watchlist;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.StockTableModel;
import org.yccheok.jstock.watchlist.WatchlistInfo;

public class Utils {
    private static final ThreadLocal<NumberFormat> stockPriceNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat("0.00##");
        }
    };

    private Utils() {
    }

    public static File getWatchlistFile(String directory) {
        return new File(directory + "realtimestock.csv");
    }

    public static String getWatchlistDirectory(String name) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return Utils.getWatchlistDirectory(jStockOptions.getCountry(), name);
    }

    public static String getWatchlistDirectory(Country country, String name) {
        return org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "watchlist" + File.separator + name + File.separator;
    }

    public static String getWatchlistDirectory() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return Utils.getWatchlistDirectory(jStockOptions.getWatchlistName());
    }

    private static boolean isXMLWatchlistDirectory(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        String[] files = file.list();
        List<String> list = Arrays.asList(files);
        return list.contains("realtimestock.xml") && list.contains("realtimestockalert.xml");
    }

    private static boolean isWatchlistDirectory(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        String[] files = file.list();
        List<String> list = Arrays.asList(files);
        return list.contains("realtimestock.csv");
    }

    private static List<String> getXMLWatchlistNames(String baseDirectory, Country country, boolean oldData) {
        ArrayList<String> watchlistNames = new ArrayList<String>();
        File file = oldData ? new File(baseDirectory + (Object)((Object)country) + File.separator + "config" + File.separator) : new File(baseDirectory + (Object)((Object)country) + File.separator + "watchlist" + File.separator);
        File[] children = file.listFiles();
        if (children == null) {
            return watchlistNames;
        }
        for (File child : children) {
            if (!Utils.isXMLWatchlistDirectory(child)) continue;
            watchlistNames.add(child.getName());
        }
        return watchlistNames;
    }

    public static List<String> getWatchlistNames() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return Utils.getWatchlistNames(jStockOptions.getCountry());
    }

    public static List<String> getWatchlistNames(Country country) {
        ArrayList<String> watchlistNames = new ArrayList<String>();
        File file = new File(org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "watchlist" + File.separator);
        File[] children = file.listFiles();
        if (children == null) {
            return watchlistNames;
        }
        for (File child : children) {
            if (!Utils.isWatchlistDirectory(child)) continue;
            watchlistNames.add(child.getName());
        }
        return watchlistNames;
    }

    public static String getDefaultWatchlistName() {
        return "My Watchlist";
    }

    public static boolean createEmptyWatchlist(String name) {
        String directory = Utils.getWatchlistDirectory(name);
        if (new File(directory + "realtimestock.csv").exists()) {
            return false;
        }
        if (!org.yccheok.jstock.gui.Utils.createCompleteDirectoryHierarchyIfDoesNotExist(directory)) {
            return false;
        }
        StockTableModel stockTableModel = new StockTableModel();
        MainFrame.CSVWatchlist csvWatchlist = MainFrame.CSVWatchlist.newInstance(stockTableModel);
        return MainFrame.saveCSVWatchlist(directory, csvWatchlist);
    }

    public static List<WatchlistInfo> getWatchlistInfos() {
        ArrayList<WatchlistInfo> watchlistInfos = new ArrayList<WatchlistInfo>();
        for (Country country : Country.values()) {
            File file = new File(org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "watchlist" + File.separator);
            File[] children = file.listFiles();
            if (children == null) continue;
            for (File child : children) {
                File realTimeStockFile = new File(child, "realtimestock.csv");
                int lines = org.yccheok.jstock.gui.Utils.numOfLines(realTimeStockFile, true);
                if (--lines <= 0) continue;
                WatchlistInfo watchlistInfo = WatchlistInfo.newInstance(country, child.getName(), lines);
                watchlistInfos.add(watchlistInfo);
            }
        }
        return watchlistInfos;
    }

    public static String toStockPrice(double value) {
        return stockPriceNumberFormat.get().format(value);
    }
}

