/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.treetable;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.treetable.AbstractPortfolioTreeTableModelEx;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.DoubleWrapper;
import org.yccheok.jstock.portfolio.Portfolio;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;

public class BuyPortfolioTreeTableModelEx
extends AbstractPortfolioTreeTableModelEx {
    private Map<Code, Double> stockPrice = new ConcurrentHashMap<Code, Double>();
    private static final String[] columnNames;
    private static final Class[] cTypes;

    public BuyPortfolioTreeTableModelEx() {
        super(Arrays.asList(columnNames));
    }

    public double getStockPrice(Code code) {
        Double price = this.stockPrice.get(code);
        if (price == null) {
            return 0.0;
        }
        return price;
    }

    public boolean split(StockInfo stockInfo, double ratio) {
        boolean status = false;
        Portfolio portfolio = (Portfolio)this.getRoot();
        int count = portfolio.getChildCount();
        TransactionSummary transactionSummary = null;
        for (int i = 0; i < count; ++i) {
            transactionSummary = (TransactionSummary)portfolio.getChildAt(i);
            assert (transactionSummary.getChildCount() > 0);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            if (transaction.getStock().code.equals(stockInfo.code)) break;
        }
        if (null == transactionSummary) {
            return status;
        }
        int num = transactionSummary.getChildCount();
        for (int i = 0; i < num; ++i) {
            Transaction transaction = (Transaction)transactionSummary.getChildAt(i);
            double quantity = transaction.getQuantity() * ratio;
            double price = transaction.getPrice() / ratio;
            this.editTransaction(transaction.deriveWithQuantity(quantity).deriveWithPrice(price), transaction);
            status = true;
        }
        return status;
    }

    public boolean updateStockLastPrice(Code code, double price) {
        Transaction transaction;
        Portfolio portfolio = (Portfolio)this.getRoot();
        int count = portfolio.getChildCount();
        TransactionSummary transactionSummary = null;
        for (int i = 0; i < count; ++i) {
            TransactionSummary ts = (TransactionSummary)portfolio.getChildAt(i);
            assert (ts.getChildCount() > 0);
            transaction = (Transaction)ts.getChildAt(0);
            if (!transaction.getStock().code.equals(code)) continue;
            transactionSummary = ts;
            break;
        }
        if (null == transactionSummary) {
            this.stockPrice.remove(code);
            return false;
        }
        int num = transactionSummary.getChildCount();
        if (num == 0) {
            this.stockPrice.remove(code);
            return false;
        }
        this.stockPrice.put(code, price);
        for (int i = 0; i < num; ++i) {
            transaction = (Transaction)transactionSummary.getChildAt(i);
            this.modelSupport.fireChildChanged(new TreePath(this.getPathToRoot((TreeTableNode)transaction)), i, (Object)transaction);
        }
        this.fireTreeTableNodeChanged((TreeTableNode)transactionSummary);
        this.fireTreeTableNodeChanged(this.getRoot());
        return true;
    }

    public boolean updateStockLastPrice(Stock stock) {
        if (stock.getLastPrice() > 0.0) {
            return this.updateStockLastPrice(stock.code, stock.getLastPrice());
        }
        return this.updateStockLastPrice(stock.code, stock.getPrevPrice());
    }

    public double getCurrentValue(Transaction transaction) {
        Code code = transaction.getStock().code;
        Double price = this.stockPrice.get(code);
        if (price == null) {
            return 0.0;
        }
        return price * transaction.getQuantity();
    }

    public double getCurrentValue(TransactionSummary transactionSummary) {
        Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
        Code code = transaction.getStock().code;
        Double price = this.stockPrice.get(code);
        if (price == null) {
            return 0.0;
        }
        return price * transactionSummary.getQuantity();
    }

    public double getCurrentPrice(Transaction transaction) {
        Code code = transaction.getStock().code;
        Double price = this.stockPrice.get(code);
        if (price == null) {
            return 0.0;
        }
        return price;
    }

    public double getCurrentPrice(TransactionSummary transactionSummary) {
        Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
        Code code = transaction.getStock().code;
        Double price = this.stockPrice.get(code);
        if (price == null) {
            return 0.0;
        }
        return price;
    }

    public double getGainLossValue() {
        return this.getGainLossValue((Portfolio)this.getRoot());
    }

    private double getGainLossValue(Portfolio portfolio) {
        return this.getCurrentValue(portfolio) - portfolio.getTotal();
    }

    public double getGainLossPercentage() {
        return this.getGainLossPercentage((Portfolio)this.getRoot());
    }

    private double getGainLossPercentage(Portfolio portfolio) {
        if (portfolio.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(portfolio) - portfolio.getTotal()) / portfolio.getTotal() * 100.0;
    }

    public double getGainLossPercentage(TransactionSummary transactionSummary) {
        if (transactionSummary.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transactionSummary) - transactionSummary.getTotal()) / transactionSummary.getTotal() * 100.0;
    }

    public double getNetGainLossValue(TransactionSummary transactionSummary) {
        return this.getCurrentValue(transactionSummary) - transactionSummary.getNetTotal();
    }

    public double getNetGainLossPercentage(TransactionSummary transactionSummary) {
        if (transactionSummary.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transactionSummary) - transactionSummary.getNetTotal()) / transactionSummary.getNetTotal() * 100.0;
    }

    public double getGainLossPercentage(Transaction transaction) {
        if (transaction.getTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transaction) - transaction.getTotal()) / transaction.getTotal() * 100.0;
    }

    public double getNetGainLossValue(Transaction transaction) {
        return this.getCurrentValue(transaction) - transaction.getNetTotal();
    }

    public double getNetGainLossPercentage(Transaction transaction) {
        if (transaction.getNetTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(transaction) - transaction.getNetTotal()) / transaction.getNetTotal() * 100.0;
    }

    public double getNetGainLossValue() {
        return this.getNetGainLossValue((Portfolio)this.getRoot());
    }

    private double getNetGainLossValue(Portfolio portfolio) {
        return this.getCurrentValue(portfolio) - portfolio.getNetTotal();
    }

    public double getNetGainLossPercentage() {
        return this.getNetGainLossPercentage((Portfolio)this.getRoot());
    }

    private double getNetGainLossPercentage(Portfolio portfolio) {
        if (portfolio.getNetTotal() == 0.0) {
            return 0.0;
        }
        return (this.getCurrentValue(portfolio) - portfolio.getNetTotal()) / portfolio.getNetTotal() * 100.0;
    }

    public double getCurrentValue() {
        return this.getCurrentValue((Portfolio)this.getRoot());
    }

    public double getNetPurchaseValue() {
        return ((Portfolio)this.getRoot()).getNetTotal();
    }

    public double getPurchaseValue() {
        return ((Portfolio)this.getRoot()).getTotal();
    }

    private double getCurrentValue(Portfolio portfolio) {
        int count = portfolio.getChildCount();
        double result = 0.0;
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = portfolio.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            assert (transactionSummary.getChildCount() > 0);
            result += this.getCurrentValue(transactionSummary);
        }
        return result;
    }

    public double getPurchasePrice(TransactionSummary transactionSummary) {
        if (transactionSummary.getQuantity() == 0.0) {
            return 0.0;
        }
        return transactionSummary.getTotal() / transactionSummary.getQuantity();
    }

    public double getGainLossPrice(Transaction transaction) {
        return this.getCurrentPrice(transaction) - transaction.getPrice();
    }

    public double getGainLossPrice(TransactionSummary transactionSummary) {
        if (transactionSummary.getQuantity() == 0.0) {
            return 0.0;
        }
        return this.getCurrentPrice(transactionSummary) - transactionSummary.getTotal() / transactionSummary.getQuantity();
    }

    public double getGainLossValue(TransactionSummary transactionSummary) {
        return this.getCurrentValue(transactionSummary) - transactionSummary.getTotal();
    }

    public double getGainLossValue(Transaction transaction) {
        return this.getCurrentValue(transaction) - transaction.getTotal();
    }

    @Override
    public int getColumnCount() {
        assert (columnNames.length == cTypes.length);
        return columnNames.length;
    }

    @Override
    public Class getColumnClass(int column) {
        return cTypes[column];
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        boolean isPenceToPoundConversionEnabled = jStockOptions.isPenceToPoundConversionEnabled();
        if (node instanceof Portfolio) {
            Portfolio portfolio = (Portfolio)node;
            switch (column) {
                case 0: {
                    return GUIBundle.getString("PortfolioManagementJPanel_Buy");
                }
                case 5: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return portfolio.getNetTotal();
                        }
                        return portfolio.getTotal();
                    }
                    if (isFeeCalculationEnabled) {
                        return portfolio.getNetTotal() / 100.0;
                    }
                    return portfolio.getTotal() / 100.0;
                }
                case 6: {
                    if (!isPenceToPoundConversionEnabled) {
                        return this.getCurrentValue(portfolio);
                    }
                    return this.getCurrentValue(portfolio) / 100.0;
                }
                case 7: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return this.getNetGainLossValue(portfolio);
                        }
                        return this.getGainLossValue(portfolio);
                    }
                    if (isFeeCalculationEnabled) {
                        return this.getNetGainLossValue(portfolio) / 100.0;
                    }
                    return this.getGainLossValue(portfolio) / 100.0;
                }
                case 8: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlaces.Two, this.getNetGainLossPercentage(portfolio));
                    }
                    return new DoubleWrapper(DecimalPlaces.Two, this.getGainLossPercentage(portfolio));
                }
                case 9: {
                    return portfolio.getBroker();
                }
                case 10: {
                    return portfolio.getClearingFee();
                }
                case 11: {
                    return portfolio.getStampDuty();
                }
                case 12: {
                    return portfolio.getComment();
                }
            }
        }
        if (node instanceof TransactionSummary) {
            TransactionSummary transactionSummary = (TransactionSummary)node;
            if (transactionSummary.getChildCount() <= 0) {
                return null;
            }
            switch (column) {
                case 0: {
                    return ((Transaction)transactionSummary.getChildAt((int)0)).getStock().symbol;
                }
                case 2: {
                    return transactionSummary.getQuantity();
                }
                case 3: {
                    if (MainFrame.getInstance().getJStockOptions().isFourDecimalPlacesEnabled()) {
                        return new DoubleWrapper(DecimalPlaces.Four, this.getPurchasePrice(transactionSummary));
                    }
                    return new DoubleWrapper(DecimalPlaces.Three, this.getPurchasePrice(transactionSummary));
                }
                case 4: {
                    return this.getCurrentPrice(transactionSummary);
                }
                case 5: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return transactionSummary.getNetTotal();
                        }
                        return transactionSummary.getTotal();
                    }
                    if (isFeeCalculationEnabled) {
                        return transactionSummary.getNetTotal() / 100.0;
                    }
                    return transactionSummary.getTotal() / 100.0;
                }
                case 6: {
                    if (!isPenceToPoundConversionEnabled) {
                        return this.getCurrentValue(transactionSummary);
                    }
                    return this.getCurrentValue(transactionSummary) / 100.0;
                }
                case 7: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return this.getNetGainLossValue(transactionSummary);
                        }
                        return this.getGainLossValue(transactionSummary);
                    }
                    if (isFeeCalculationEnabled) {
                        return this.getNetGainLossValue(transactionSummary) / 100.0;
                    }
                    return this.getGainLossValue(transactionSummary) / 100.0;
                }
                case 8: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlaces.Two, this.getNetGainLossPercentage(transactionSummary));
                    }
                    return new DoubleWrapper(DecimalPlaces.Two, this.getGainLossPercentage(transactionSummary));
                }
                case 9: {
                    return transactionSummary.getBroker();
                }
                case 10: {
                    return transactionSummary.getClearingFee();
                }
                case 11: {
                    return transactionSummary.getStampDuty();
                }
                case 12: {
                    return transactionSummary.getComment();
                }
            }
        }
        if (node instanceof Transaction) {
            Transaction transaction = (Transaction)node;
            switch (column) {
                case 0: {
                    return transaction.getStock().symbol;
                }
                case 1: {
                    return transaction.getDate();
                }
                case 2: {
                    return transaction.getQuantity();
                }
                case 3: {
                    return transaction.getPrice();
                }
                case 4: {
                    return this.getCurrentPrice(transaction);
                }
                case 5: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return transaction.getNetTotal();
                        }
                        return transaction.getTotal();
                    }
                    if (isFeeCalculationEnabled) {
                        return transaction.getNetTotal() / 100.0;
                    }
                    return transaction.getTotal() / 100.0;
                }
                case 6: {
                    if (!isPenceToPoundConversionEnabled) {
                        return this.getCurrentValue(transaction);
                    }
                    return this.getCurrentValue(transaction) / 100.0;
                }
                case 7: {
                    if (!isPenceToPoundConversionEnabled) {
                        if (isFeeCalculationEnabled) {
                            return this.getNetGainLossValue(transaction);
                        }
                        return this.getGainLossValue(transaction);
                    }
                    if (isFeeCalculationEnabled) {
                        return this.getNetGainLossValue(transaction) / 100.0;
                    }
                    return this.getGainLossValue(transaction) / 100.0;
                }
                case 8: {
                    if (isFeeCalculationEnabled) {
                        return new DoubleWrapper(DecimalPlaces.Two, this.getNetGainLossPercentage(transaction));
                    }
                    return new DoubleWrapper(DecimalPlaces.Two, this.getGainLossPercentage(transaction));
                }
                case 9: {
                    return transaction.getBroker();
                }
                case 10: {
                    return transaction.getClearingFee();
                }
                case 11: {
                    return transaction.getStampDuty();
                }
                case 12: {
                    return transaction.getComment();
                }
            }
        }
        return null;
    }

    @Override
    public boolean isValidTransaction(Transaction transaction) {
        return transaction.getType() == Contract.Type.Buy;
    }

    public Map<Code, Double> getStockPrices() {
        return Collections.unmodifiableMap(this.stockPrice);
    }

    private Object readResolve() {
        Portfolio portfolio = (Portfolio)this.getRoot();
        int count = portfolio.getChildCount();
        HashSet<Code> set = new HashSet<Code>();
        for (int i = 0; i < count; ++i) {
            TransactionSummary transactionSummary = (TransactionSummary)portfolio.getChildAt(i);
            assert (transactionSummary.getChildCount() > 0);
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            set.add(transaction.getStock().code);
        }
        Iterator<Code> it = this.stockPrice.keySet().iterator();
        while (it.hasNext()) {
            if (set.contains(it.next())) continue;
            it.remove();
        }
        return this;
    }

    static {
        String[] tmp = new String[]{GUIBundle.getString("PortfolioManagementJPanel_Stock"), GUIBundle.getString("PortfolioManagementJPanel_Date"), GUIBundle.getString("PortfolioManagementJPanel_Units"), GUIBundle.getString("PortfolioManagementJPanel_PurchasePrice"), GUIBundle.getString("PortfolioManagementJPanel_CurrentPrice"), GUIBundle.getString("PortfolioManagementJPanel_PurchaseValue"), GUIBundle.getString("PortfolioManagementJPanel_CurrentValue"), GUIBundle.getString("PortfolioManagementJPanel_GainLossValue"), GUIBundle.getString("PortfolioManagementJPanel_GainLossPercentage"), GUIBundle.getString("PortfolioManagementJPanel_Broker"), GUIBundle.getString("PortfolioManagementJPanel_ClearingFee"), GUIBundle.getString("PortfolioManagementJPanel_StampDuty"), GUIBundle.getString("PortfolioManagementJPanel_Comment")};
        columnNames = tmp;
        cTypes = new Class[]{TreeTableModel.class, SimpleDate.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, String.class};
    }
}

