/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.treetable;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

public abstract class AbstractSortableTreeTableNode
extends AbstractMutableTreeTableNode {
    private boolean sortable = true;
    private boolean sorted = false;
    private int[] modelToView;
    private Row[] viewToModel;

    public AbstractSortableTreeTableNode() {
    }

    public AbstractSortableTreeTableNode(Object userObject) {
        super(userObject);
    }

    public AbstractSortableTreeTableNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public AbstractSortableTreeTableNode(boolean sortable, Object userObject) {
        super(userObject);
        this.sortable = sortable;
    }

    public TreeTableNode getChildAt(int childIndex) {
        if (!this.sortable || !this.sorted) {
            return super.getChildAt(childIndex);
        }
        return super.getChildAt(this.convertRowIndexToModel(childIndex));
    }

    public int getIndex(TreeNode node) {
        int x = this.children.indexOf(node);
        return this.convertRowIndexToView(x);
    }

    public int convertRowIndexToModel(int index) {
        if (this.sorted) {
            return this.viewToModel[index].modelIndex;
        }
        return index;
    }

    public int convertRowIndexToView(int index) {
        if (this.sorted) {
            if (index == -1 || index >= this.modelToView.length) {
                return index;
            }
            return this.modelToView[index];
        }
        return index;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public void presortChildren(int column, boolean ascending) {
        int count = this.getChildCount();
        if (count == 0) {
            return;
        }
        Object[] work = new Row[count];
        int x = 0;
        SortOrder order = ascending ? SortOrder.ASCENDING : SortOrder.DESCENDING;
        for (MutableTreeTableNode node : this.children) {
            Row r = new Row(node.getValueAt(column), x, order);
            work[x++] = r;
        }
        Arrays.sort(work);
        ArrayList<MutableTreeTableNode> newChildren = new ArrayList<MutableTreeTableNode>(count);
        for (Object r : work) {
            MutableTreeTableNode node = (MutableTreeTableNode)this.children.get(((Row)r).modelIndex);
            newChildren.add(node);
        }
        for (int i = 0; i < newChildren.size(); ++i) {
            this.children.set(i, newChildren.get(i));
        }
    }

    protected boolean canSort(String column) {
        return true;
    }

    void sort(int column, SortOrder order) {
        int count = this.getChildCount();
        if (count == 0) {
            this.sorted = false;
            return;
        }
        this.modelToView = new int[count];
        this.viewToModel = new Row[count];
        int x = 0;
        for (MutableTreeTableNode node : this.children) {
            Row r = new Row(node.getValueAt(column), x, order);
            this.viewToModel[x++] = r;
        }
        Arrays.sort(this.viewToModel);
        for (int i = count - 1; i >= 0; --i) {
            this.modelToView[this.viewToModel[i].modelIndex] = i;
        }
        this.sorted = true;
    }

    void reset() {
        this.sorted = false;
    }

    boolean isSorted() {
        return this.sorted;
    }

    boolean canSort() {
        if (!this.sortable || !this.getAllowsChildren()) {
            return false;
        }
        int count = this.getChildCount();
        return count != 0;
    }

    private class Row
    implements Comparable<Row> {
        Comparable key;
        int modelIndex;
        SortOrder order;

        public Row(Object key, int modelIndex, SortOrder order) {
            this.key = key instanceof Comparable ? (Comparable)key : (key != null ? key.toString() : null);
            this.modelIndex = modelIndex;
            this.order = order;
        }

        @Override
        public int compareTo(Row r) {
            int result = this.key == null ? (r.key == null ? 0 : -1) : (r.key == null ? 1 : this.key.compareTo(r.key));
            if (!this.order.isAscending()) {
                result *= -1;
            }
            if (result == 0) {
                result = this.modelIndex - r.modelIndex;
            }
            return result;
        }
    }
}

