/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DividendServer;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.gui.JTableUtilities;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.PortfolioManagementJPanel;
import org.yccheok.jstock.gui.portfolio.AutoDividendJDialog;
import org.yccheok.jstock.gui.portfolio.CommentJDialog;
import org.yccheok.jstock.gui.portfolio.DividendSummaryBarChartJDialog;
import org.yccheok.jstock.gui.portfolio.DividendSummaryTableModel;
import org.yccheok.jstock.gui.table.CurrencyRenderer;
import org.yccheok.jstock.gui.table.NonNegativeEmptyDoubleEditor;
import org.yccheok.jstock.gui.table.StockInfoEditor;
import org.yccheok.jstock.gui.table.StockInfoRenderer;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.portfolio.Commentable;
import org.yccheok.jstock.portfolio.DecimalPlaces;
import org.yccheok.jstock.portfolio.Dividend;
import org.yccheok.jstock.portfolio.DividendSummary;
import org.yccheok.jstock.portfolio.QuantityQuery;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;
import org.yccheok.jstock.portfolio.Utils;

public class DividendSummaryJDialog
extends JDialog
implements PropertyChangeListener {
    private List<TransactionSummary> transactionSummaries = null;
    private DividendSummary dividendSummary;
    private DividendSummary dividendSummaryAfterPressingOK = null;
    private final PortfolioManagementJPanel portfolioManagementJPanel;
    private ProgressMonitor progressMonitor = null;
    private AutoDividendTask autoDividendTask = null;
    private static final Log log = LogFactory.getLog(DividendSummaryJDialog.class);
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JXHeader jXHeader1;

    public DividendSummaryJDialog(Frame parent, boolean modal, DividendSummary dividendSummary, PortfolioManagementJPanel portfolioManagementJPanel) {
        super(parent, modal);
        this.portfolioManagementJPanel = portfolioManagementJPanel;
        this.dividendSummary = new DividendSummary(dividendSummary);
        this.dividendSummaryAfterPressingOK = null;
        this.initComponents();
        RowSorter<? extends TableModel> rowSorter = this.jTable1.getRowSorter();
        if (rowSorter != null) {
            rowSorter.toggleSortOrder(0);
            List<RowSorter.SortKey> sortKeys = rowSorter.getSortKeys();
            if (sortKeys.size() > 0 && sortKeys.get(0).getSortOrder() != SortOrder.DESCENDING) {
                rowSorter.toggleSortOrder(0);
            }
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                AutoDividendTask autoDividendTask = DividendSummaryJDialog.this.autoDividendTask;
                if (autoDividendTask != null) {
                    autoDividendTask.cancel(true);
                }
            }
        });
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("DividendSummaryJDialog_DividendPayout"));
        this.setIconImage(null);
        this.setResizable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DividendSummaryJDialog.this.formMouseClicked(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.jXHeader1.setDescription(bundle.getString("DividendSummaryJDialog_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/money2.png")));
        this.jXHeader1.setTitle(bundle.getString("DividendSummaryJDialog_Dividend"));
        this.getContentPane().add((Component)this.jXHeader1, "North");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("DividendSummary_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DividendSummaryJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("DividendSummary_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DividendSummaryJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel1.setLayout(new BorderLayout(5, 5));
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/filenew.png")));
        this.jButton3.setText(bundle.getString("DividendSummaryJDialog_New"));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DividendSummaryJDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton3);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/editdelete.png")));
        this.jButton4.setText(bundle.getString("DividendSummaryJDialog_Delete"));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DividendSummaryJDialog.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton4);
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/auto-dividend.png")));
        this.jButton5.setText(bundle.getString("DividendSummaryJDialog_AutoDividend..."));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DividendSummaryJDialog.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButton5);
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jLabel1.setForeground(new Color(0, 0, 255));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(bundle.getString("DividendSummaryJDialog_TotalDividend"));
        this.jLabel1.setHorizontalTextPosition(0);
        this.jPanel4.add(this.jLabel1);
        this.jLabel2.setForeground(new Color(0, 0, 255));
        this.jLabel2.setText(this.getDividendSummaryText());
        this.jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DividendSummaryJDialog.this.jLabel2MouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                DividendSummaryJDialog.this.jLabel2MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DividendSummaryJDialog.this.jLabel2MouseExited(evt);
            }
        });
        this.jPanel4.add(this.jLabel2);
        this.jPanel1.add((Component)this.jPanel4, "Last");
        this.jTable1.setModel(new DividendSummaryTableModel(this.dividendSummary));
        CurrencyRenderer currencyRenderer = new CurrencyRenderer();
        NonNegativeEmptyDoubleEditor currencyEditor = new NonNegativeEmptyDoubleEditor();
        currencyRenderer.setHorizontalAlignment(4);
        ((JTextField)currencyEditor.getComponent()).setHorizontalAlignment(4);
        this.jTable1.setDefaultEditor(Double.class, currencyEditor);
        this.jTable1.setDefaultRenderer(Double.class, currencyRenderer);
        this.jTable1.setDefaultEditor(StockInfo.class, new StockInfoEditor(this.portfolioManagementJPanel.getStockInfosFromPortfolios()));
        this.jTable1.setDefaultRenderer(StockInfo.class, new StockInfoRenderer());
        JTableUtilities.setDateEditorAndRendererForRow(this.jTable1, 0);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.addMouseListener(new TableRowPopupListener());
        this.jTable1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DividendSummaryJDialog.this.jTable1PropertyChange(evt);
            }
        });
        this.jTable1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DividendSummaryJDialog.this.jTable1KeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.setSize(new Dimension(339, 373));
        this.setLocationRelativeTo(null);
    }

    private void formMouseClicked(MouseEvent evt) {
        this.clearAllTablesSelection();
    }

    private void jTable1KeyPressed(KeyEvent evt) {
        if (127 == evt.getKeyCode()) {
            this.deleteSelectedDividend();
            this.jLabel2.setText(this.getDividendSummaryText());
            return;
        }
    }

    private void jTable1PropertyChange(PropertyChangeEvent evt) {
        this.jLabel2.setText(this.getDividendSummaryText());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        boolean status;
        TableCellEditor tableCellEditor = this.jTable1.getCellEditor();
        if (tableCellEditor != null && !(status = tableCellEditor.stopCellEditing())) {
            return;
        }
        this.dividendSummaryAfterPressingOK = this.dividendSummary;
        Utils.removeMeaninglessRecords(this.dividendSummaryAfterPressingOK);
        this.setVisible(false);
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dividendSummaryAfterPressingOK = null;
        this.setVisible(false);
        this.dispose();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.addNewDividend();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.deleteSelectedDividend();
        this.jLabel2.setText(this.getDividendSummaryText());
    }

    private void jLabel2MouseClicked(MouseEvent evt) {
        if (this.dividendSummary == null || this.dividendSummary.getTotal() <= 0.0) {
            return;
        }
        MainFrame m = MainFrame.getInstance();
        DividendSummaryBarChartJDialog dividendSummaryBarChartJDialog = new DividendSummaryBarChartJDialog((Dialog)this, false, this.getDividendSummary());
        dividendSummaryBarChartJDialog.setVisible(true);
    }

    private void jLabel2MouseEntered(MouseEvent evt) {
        if (this.dividendSummary == null || this.dividendSummary.getTotal() <= 0.0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    private void jLabel2MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        if (this.transactionSummaries == null) {
            this.transactionSummaries = this.portfolioManagementJPanel.getTransactionSummariesFromPortfolios();
        }
        this.progressMonitor = new ProgressMonitor(this, GUIBundle.getString("DividendSummaryJDialog_AutoDividendCalculating..."), "", 0, this.transactionSummaries.size());
        this.progressMonitor.setProgress(0);
        this.progressMonitor.setMillisToDecideToPopup(50);
        this.progressMonitor.setMillisToPopup(100);
        this.autoDividendTask = new AutoDividendTask();
        this.autoDividendTask.addPropertyChangeListener(this);
        this.autoDividendTask.execute();
        this.jButton5.setEnabled(false);
    }

    public DividendSummary getDividendSummary() {
        return this.dividendSummary;
    }

    public DividendSummary getDividendSummaryAfterPressingOK() {
        return this.dividendSummaryAfterPressingOK;
    }

    private String getDividendSummaryText() {
        if (this.dividendSummary != null) {
            return "<html><a href=\"\">" + Utils.toCurrencyWithSymbol(DecimalPlaces.Three, this.dividendSummary.getTotal()) + "</a></html>";
        }
        return "";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            if (this.progressMonitor == null) {
                return;
            }
            int progress = (Integer)evt.getNewValue();
            this.progressMonitor.setProgress(progress);
            int total = this.transactionSummaries.size();
            int progressPercentage = total == 0 ? 0 : (int)((double)progress / (double)total * 100.0);
            String template = GUIBundle.getString("DividendSummaryJDialog_Completed_template");
            String message = MessageFormat.format(template, progressPercentage);
            this.progressMonitor.setNote(message);
            if (this.progressMonitor.isCanceled() || this.autoDividendTask.isDone()) {
                if (this.progressMonitor.isCanceled()) {
                    this.autoDividendTask.cancel(true);
                }
                this.jButton5.setEnabled(true);
            }
        }
    }

    public int addNewDividend(StockInfo stockInfo) {
        int modelIndex = this.addNewDividend();
        ((DividendSummaryTableModel)this.jTable1.getModel()).setValueAt(stockInfo, modelIndex, 1);
        return modelIndex;
    }

    private int addNewDividend() {
        int modelIndex = ((DividendSummaryTableModel)this.jTable1.getModel()).addNewDividend();
        this.clearAllTablesSelection();
        int selectedViewIndex = this.jTable1.getRowSorter().convertRowIndexToView(modelIndex);
        this.jTable1.getSelectionModel().setSelectionInterval(selectedViewIndex, selectedViewIndex);
        JTableUtilities.scrollToVisible(this.jTable1, selectedViewIndex, 0);
        return modelIndex;
    }

    private void deleteSelectedDividend() {
        int[] rows = this.jTable1.getSelectedRows();
        DividendSummaryTableModel dividendSummaryTableModel = (DividendSummaryTableModel)this.jTable1.getModel();
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            if (row < 0) continue;
            int modelIndex = this.jTable1.getRowSorter().convertRowIndexToModel(row);
            dividendSummaryTableModel.removeRow(modelIndex);
        }
    }

    private JPopupMenu getMyJTablePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("DividendSummary_New"), new ImageIcon(this.getClass().getResource("/images/16x16/filenew.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DividendSummaryJDialog.this.addNewDividend();
            }
        });
        popup.add(menuItem);
        final Commentable commentable = this.getSelectedCommentable();
        final String text = this.getSelectedSecondColumnString();
        if (commentable != null && text != null) {
            popup.addSeparator();
            menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("DividendSummary_Note..."), new ImageIcon(this.getClass().getResource("/images/16x16/sticky.png")));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DividendSummaryJDialog.this.showCommentJDialog(commentable, MessageFormat.format(GUIBundle.getString("DividendSummaryJDialog_NoteFor_template"), text));
                }
            });
            popup.add(menuItem);
        }
        if (this.jTable1.getSelectedRowCount() >= 1) {
            popup.addSeparator();
            menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("DividendSummaryJDialog_Delete"), new ImageIcon(this.getClass().getResource("/images/16x16/editdelete.png")));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DividendSummaryJDialog.this.deleteSelectedDividend();
                    DividendSummaryJDialog.this.jLabel2.setText(DividendSummaryJDialog.this.getDividendSummaryText());
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }

    private void showCommentJDialog(Commentable commentable, String title) {
        if (commentable == null) {
            return;
        }
        MainFrame mainFrame = MainFrame.getInstance();
        CommentJDialog commentJDialog = new CommentJDialog((Frame)mainFrame, true, commentable);
        commentJDialog.setTitle(title);
        commentJDialog.setLocationRelativeTo(this);
        commentJDialog.setVisible(true);
    }

    private void clearAllTablesSelection() {
        this.jTable1.getSelectionModel().clearSelection();
    }

    private String getSelectedSecondColumnString() {
        if (this.jTable1.getSelectedRowCount() != 1) {
            return null;
        }
        int viewIndex = this.jTable1.convertColumnIndexToView(1);
        String string = ((StockInfo)this.jTable1.getValueAt((int)this.jTable1.getSelectedRow(), (int)viewIndex)).symbol.toString();
        return string;
    }

    private Commentable getSelectedCommentable() {
        if (this.jTable1.getSelectedRowCount() != 1) {
            return null;
        }
        int viewIndex = this.jTable1.getSelectedRow();
        int index = this.jTable1.convertRowIndexToModel(viewIndex);
        return ((DividendSummaryTableModel)this.jTable1.getModel()).getDividend(index);
    }

    private class AutoDividendTask
    extends SwingWorker<Map<Code, List<Dividend>>, Void> {
        private AutoDividendTask() {
        }

        @Override
        public Map<Code, List<Dividend>> doInBackground() {
            QuantityQuery quantityQuery = new QuantityQuery(DividendSummaryJDialog.this.transactionSummaries);
            HashMap<Code, List<Dividend>> result = new HashMap<Code, List<Dividend>>();
            int ei = DividendSummaryJDialog.this.transactionSummaries.size();
            for (int i = 0; i < ei && !this.isCancelled(); ++i) {
                TransactionSummary transactionSummary = (TransactionSummary)DividendSummaryJDialog.this.transactionSummaries.get(i);
                Code code = ((Transaction)transactionSummary.getChildAt((int)0)).getStock().code;
                Dividend latestDividend = Utils.getLatestDividend(DividendSummaryJDialog.this.dividendSummary, code);
                SimpleDate date = null;
                if (latestDividend == null) {
                    int ej = transactionSummary.getChildCount();
                    for (int j = 0; j < ej; ++j) {
                        Transaction transaction = (Transaction)transactionSummary.getChildAt(j);
                        SimpleDate simpleDate = transaction.getContract().getDate();
                        if (date == null) {
                            date = simpleDate;
                            continue;
                        }
                        if (date.compareTo(simpleDate) <= 0) continue;
                        date = simpleDate;
                    }
                } else {
                    date = latestDividend.date;
                }
                Calendar c = date.getCalendar();
                c.add(5, 1);
                SimpleDate startDate = new SimpleDate(c);
                SimpleDate endDate = new SimpleDate();
                if (startDate.compareTo(endDate) > 0) {
                    this.setProgress(i + 1);
                    continue;
                }
                Duration duration = new Duration(startDate, endDate);
                List<StockServerFactory> stockServerFactories = MainFrame.getInstance().getStockServerFactories();
                ArrayList<Dividend> suggestedDividends = new ArrayList<Dividend>();
                for (StockServerFactory stockServerFactory : stockServerFactories) {
                    if (this.isCancelled()) break;
                    DividendServer dividendServer = stockServerFactory.getDividendServer();
                    if (dividendServer == null) continue;
                    List<Dividend> dividends = dividendServer.getDividends(code, duration);
                    for (Dividend dividend : dividends) {
                        StockInfo betterStockInfo;
                        double total;
                        if (!duration.isContains(dividend.date) || (total = dividend.amount * quantityQuery.getBalance(code, dividend.date)) == 0.0) continue;
                        if (MainFrame.getInstance().getJStockOptions().isPenceToPoundConversionEnabled()) {
                            total /= 100.0;
                        }
                        Dividend suggestedDividend = new Dividend((betterStockInfo = MainFrame.getInstance().getStockInfoDatabase().codeToStockInfo(dividend.stockInfo.code)) == null ? dividend.stockInfo : betterStockInfo, total, dividend.date);
                        suggestedDividends.add(suggestedDividend);
                    }
                }
                if (!suggestedDividends.isEmpty()) {
                    result.put(code, suggestedDividends);
                }
                this.setProgress(i + 1);
            }
            return result;
        }

        @Override
        public void done() {
            DividendSummaryJDialog.this.jButton5.setEnabled(true);
            DividendSummaryJDialog.this.progressMonitor.close();
            DividendSummaryJDialog.this.progressMonitor = null;
            if (!this.isCancelled()) {
                try {
                    Map dividends = (Map)this.get();
                    if (dividends.isEmpty()) {
                        JOptionPane.showMessageDialog(DividendSummaryJDialog.this, MessagesBundle.getString("info_message_no_dividend_found"), MessagesBundle.getString("info_title_no_dividend_found"), 1);
                    } else {
                        AutoDividendJDialog autoDividendJDialog = new AutoDividendJDialog((Frame)MainFrame.getInstance(), true, dividends);
                        autoDividendJDialog.setLocationRelativeTo(DividendSummaryJDialog.this);
                        autoDividendJDialog.setVisible(true);
                        List<Dividend> dividendsAfterPressingOK = autoDividendJDialog.getDividendsAfterPressingOK();
                        if (dividendsAfterPressingOK != null) {
                            DividendSummaryTableModel dividendSummaryTableModel = (DividendSummaryTableModel)DividendSummaryJDialog.this.jTable1.getModel();
                            for (Dividend dividend : dividendsAfterPressingOK) {
                                dividendSummaryTableModel.add(dividend);
                            }
                            if (!dividendsAfterPressingOK.isEmpty()) {
                                DividendSummaryJDialog.this.jLabel2.setText(DividendSummaryJDialog.this.getDividendSummaryText());
                                JOptionPane.showMessageDialog(DividendSummaryJDialog.this, MessageFormat.format(MessagesBundle.getString("info_message_dividends_added_template"), dividendsAfterPressingOK.size()), MessagesBundle.getString("info_title_dividends_added"), 1);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    log.error(null, (Throwable)ex);
                }
            }
        }
    }

    private class TableRowPopupListener
    extends MouseAdapter {
        private TableRowPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DividendSummaryJDialog.this.getMyJTablePopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

