/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.file.CSVHelper;
import org.yccheok.jstock.file.GUIBundleWrapper;
import org.yccheok.jstock.gui.portfolio.CommentableContainer;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.Commentable;
import org.yccheok.jstock.portfolio.Deposit;
import org.yccheok.jstock.portfolio.DepositSummary;

public class DepositSummaryTableModel
extends AbstractTableModel
implements CommentableContainer,
CSVHelper {
    private static final String[] columnNames;
    private static final String[] languageIndependentColumnNames;
    private static final Class[] columnClasses;
    private final DepositSummary depositSummary;

    public DepositSummaryTableModel(DepositSummary depositSummary) {
        this.depositSummary = depositSummary;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Deposit deposit = (Deposit)this.depositSummary.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return deposit.getDate().getCalendar().getTime();
            }
            case 1: {
                return deposit.getAmount();
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.depositSummary.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Class getColumnClass(int c) {
        return columnClasses[c];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 0: {
                Deposit newDeposit = ((Deposit)this.depositSummary.get(row)).setDate(new SimpleDate((Date)value));
                this.depositSummary.remove(row);
                this.depositSummary.add(row, newDeposit);
                this.fireTableCellUpdated(row, col);
                break;
            }
            case 1: {
                Deposit newDeposit = ((Deposit)this.depositSummary.get(row)).setAmount((Double)value);
                this.depositSummary.remove(row);
                this.depositSummary.add(row, newDeposit);
                this.fireTableCellUpdated(row, col);
                break;
            }
        }
    }

    public void removeRow(int index) {
        this.depositSummary.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public int addNewDeposit() {
        this.depositSummary.add(new Deposit(0.0, new SimpleDate()));
        int index = this.depositSummary.size() - 1;
        this.fireTableRowsInserted(index, index);
        return index;
    }

    public Deposit getDeposit(int index) {
        return (Deposit)this.depositSummary.get(index);
    }

    @Override
    public Commentable getCommentable(int index) {
        return (Commentable)this.depositSummary.get(index);
    }

    @Override
    public String getLanguageIndependentColumnName(int columnIndex) {
        return languageIndependentColumnNames[columnIndex];
    }

    static {
        columnClasses = new Class[]{Date.class, Double.class};
        String[] tmp = new String[]{GUIBundle.getString("PortfolioManagementJPanel_Date"), GUIBundle.getString("PortfolioManagementJPanel_Cash")};
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        String[] tmp2 = new String[]{guiBundleWrapper.getString("PortfolioManagementJPanel_Date"), guiBundleWrapper.getString("PortfolioManagementJPanel_Cash")};
        columnNames = tmp;
        languageIndependentColumnNames = tmp2;
    }
}

