/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.charting;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.yccheok.jstock.charting.Utils;
import org.yccheok.jstock.internationalization.GUIBundle;

public class DynamicChart {
    private final TimeSeries price = new TimeSeries((Comparable)((Object)"Price"));
    private final ChartPanel chartPanel;
    private static final Log log = LogFactory.getLog(DynamicChart.class);

    public DynamicChart() {
        this.price.setMaximumItemAge(7200L);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(this.price);
        JFreeChart freeChart = ChartFactory.createTimeSeriesChart(null, null, null, (XYDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
        freeChart.setAntiAlias(true);
        while (freeChart.getSubtitleCount() > 0) {
            freeChart.removeSubtitle(freeChart.getSubtitle(0));
        }
        XYPlot plot = freeChart.getXYPlot();
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        XYItemRenderer renderer1 = plot.getRenderer();
        renderer1.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("h:mm:ss a"), (NumberFormat)new DecimalFormat("0.00#")));
        Utils.applyChartTheme(freeChart);
        this.chartPanel = new ChartPanel(freeChart, true, true, true, false, true);
        this.chartPanel.setMouseZoomable(false);
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public void showNewJDialog(Frame parent, String title) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(this.price);
        JFreeChart freeChart = ChartFactory.createTimeSeriesChart((String)title, (String)GUIBundle.getString("DynamicChart_Date"), (String)GUIBundle.getString("DynamicChart_Price"), (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        freeChart.setAntiAlias(true);
        XYPlot plot = freeChart.getXYPlot();
        NumberAxis rangeAxis1 = (NumberAxis)plot.getRangeAxis();
        DecimalFormat format = new DecimalFormat("00.00");
        rangeAxis1.setNumberFormatOverride((NumberFormat)format);
        XYItemRenderer renderer1 = plot.getRenderer();
        renderer1.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("h:mm:ss a"), (NumberFormat)new DecimalFormat("0.00#")));
        Utils.applyChartTheme(freeChart);
        ChartPanel _chartPanel = new ChartPanel(freeChart, true, true, true, true, true);
        JDialog dialog = new JDialog(parent, title, false);
        dialog.getContentPane().add((Component)_chartPanel, "Center");
        dialog.setDefaultCloseOperation(2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setBounds(screenSize.width - 750 >> 1, screenSize.height - 600 >> 1, 750, 600);
        dialog.setVisible(true);
    }

    public void addPriceObservation(long timestamp, double y) {
        Date nextStartDate;
        int count = this.price.getItemCount();
        if (count > 0 && timestamp - (nextStartDate = this.price.getTimePeriod(count - 1).getStart()).getTime() < 10000L) {
            return;
        }
        Second second = new Second(new Date(timestamp));
        try {
            this.price.add((RegularTimePeriod)second, y);
        }
        catch (SeriesException exp) {
            log.error(null, (Throwable)exp);
        }
    }
}

