/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.NumberFormatter;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JStockOptionsObserver;
import org.yccheok.jstock.gui.NewBrokingFirmJDialog;
import org.yccheok.jstock.gui.OptionsJDialog;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.portfolio.BrokingFirm;

public class OptionsBrokerJPanel
extends JPanel
implements JStockOptionsObserver {
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JFormattedTextField jFormattedTextField1;
    private JFormattedTextField jFormattedTextField2;
    private JFormattedTextField jFormattedTextField3;
    private JFormattedTextField jFormattedTextField4;
    private JFormattedTextField jFormattedTextField5;
    private JFormattedTextField jFormattedTextField6;
    private JFormattedTextField jFormattedTextField7;
    private JFormattedTextField jFormattedTextField8;
    private JFormattedTextField jFormattedTextField9;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JXHeader jXHeader1;
    private List<BrokingFirm> brokingFirms = new ArrayList<BrokingFirm>();
    private BrokingFirm currentSelectedBrokingFirm = null;

    public OptionsBrokerJPanel() {
        this.initComponents();
    }

    private JFormattedTextField getCurrencyJFormattedTextField(double minimum) {
        NumberFormat format = NumberFormat.getNumberInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setMinimum(Double.valueOf(minimum));
        formatter.setValueClass(Double.class);
        JFormattedTextField field = new JFormattedTextField(formatter);
        return field;
    }

    private void initComponents() {
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel6 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jPanel3 = new JPanel();
        this.jFormattedTextField1 = this.getCurrencyJFormattedTextField(0.0);
        this.jFormattedTextField2 = this.getCurrencyJFormattedTextField(0.0);
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jFormattedTextField3 = this.getCurrencyJFormattedTextField(0.0);
        this.jPanel4 = new JPanel();
        this.jFormattedTextField4 = this.getCurrencyJFormattedTextField(0.0);
        this.jFormattedTextField5 = this.getCurrencyJFormattedTextField(0.0);
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jFormattedTextField6 = this.getCurrencyJFormattedTextField(0.0);
        this.jPanel5 = new JPanel();
        this.jFormattedTextField7 = this.getCurrencyJFormattedTextField(0.0);
        this.jFormattedTextField8 = this.getCurrencyJFormattedTextField(1.0);
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jFormattedTextField9 = this.getCurrencyJFormattedTextField(0.0);
        this.jCheckBox2 = new JCheckBox();
        this.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jXHeader1.setDescription(bundle.getString("OptionsBrokerJPanel_Description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/calc.png")));
        this.jXHeader1.setTitle(bundle.getString("OptionsBrokerJPanel_BrokerFee"));
        this.add((Component)this.jXHeader1, "North");
        this.jCheckBox1.setText(bundle.getString("OptionsBrokerJPanel_AutoCalculate"));
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionsBrokerJPanel.this.jCheckBox1ItemStateChanged(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsBrokerJPanel_BrokingFirm")));
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                OptionsBrokerJPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jPanel6.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel6.setLayout(new BorderLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setHorizontalTextPosition(0);
        this.jPanel6.add((Component)this.jLabel1, "Center");
        this.jButton1.setText(bundle.getString("OptionsBrokerJPanel_Add..."));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsBrokerJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText(bundle.getString("OptionsBrokerJPanel_Delete"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsBrokerJPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText(bundle.getString("OptionsBrokerJPanel_Edit..."));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsBrokerJPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsBrokerJPanel_BrokerFee")));
        this.jFormattedTextField1.setValue(new Double(0.0));
        this.jFormattedTextField2.setValue(new Double(0.0));
        this.jLabel2.setText(bundle.getString("OptionsBrokerJPanel_Rate%"));
        this.jLabel3.setText(bundle.getString("OptionsBrokerJPanel_MaximumFee"));
        this.jLabel4.setText(bundle.getString("OptionsBrokerJPanel_MinimumFee"));
        this.jFormattedTextField3.setValue(new Double(0.0));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jFormattedTextField1).addComponent(this.jFormattedTextField2).addComponent(this.jFormattedTextField3, -1, 85, Short.MAX_VALUE)).addContainerGap(37, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jFormattedTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jFormattedTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jFormattedTextField3, -2, -1, -2)).addContainerGap(6, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsBrokerJPanel_ClearingFee")));
        this.jFormattedTextField4.setValue(new Double(0.0));
        this.jFormattedTextField5.setValue(new Double(0.0));
        this.jLabel5.setText(bundle.getString("OptionsBrokerJPanel_Rate%"));
        this.jLabel6.setText(bundle.getString("OptionsBrokerJPanel_MaximumFee"));
        this.jLabel7.setText(bundle.getString("OptionsBrokerJPanel_MinimumFee"));
        this.jFormattedTextField6.setValue(new Double(0.0));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel5).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jFormattedTextField6).addComponent(this.jFormattedTextField5).addComponent(this.jFormattedTextField4, -1, 87, Short.MAX_VALUE)).addContainerGap(37, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jFormattedTextField4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jFormattedTextField5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jFormattedTextField6, -2, -1, -2)).addContainerGap(6, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsBrokerJPanel_StampDuty")));
        this.jFormattedTextField7.setValue(new Double(0.0));
        this.jFormattedTextField8.setValue(new Double(1.0));
        this.jLabel8.setText(bundle.getString("OptionsBrokerJPanel_Rate"));
        this.jLabel9.setText(bundle.getString("OptionsBrokerJPanel_Fraction"));
        this.jLabel10.setText(bundle.getString("OptionsBrokerJPanel_MaximumFee"));
        this.jFormattedTextField9.setValue(new Double(0.0));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel8).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jFormattedTextField9).addComponent(this.jFormattedTextField8).addComponent(this.jFormattedTextField7, -1, 87, Short.MAX_VALUE)).addContainerGap(37, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jFormattedTextField7, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jFormattedTextField8, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jFormattedTextField9, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 204, -2).addGap(18, 18, 18).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -2, -1, -2)))).addContainerGap(22, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.jPanel3, this.jPanel4);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel6, -1, 60, Short.MAX_VALUE).addComponent(this.jScrollPane1, 0, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton3).addComponent(this.jButton1).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel4, 0, 105, Short.MAX_VALUE).addComponent(this.jPanel3, -1, 105, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel5, -2, -1, -2).addContainerGap()));
        this.jCheckBox2.setText(bundle.getString("OptionsBrokerJPanel_IsFeeCalculationEnabled"));
        this.jCheckBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionsBrokerJPanel.this.jCheckBox2ItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addComponent(this.jCheckBox2).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(19, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Center");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        OptionsJDialog optionsJDialog = (OptionsJDialog)SwingUtilities.getAncestorOfClass(OptionsJDialog.class, this);
        NewBrokingFirmJDialog newBrokingFirmJDialog = new NewBrokingFirmJDialog((Frame)optionsJDialog.getParent(), true);
        newBrokingFirmJDialog.setVisible(true);
        BrokingFirm brokingFirm = newBrokingFirmJDialog.getBrokingFirm();
        if (brokingFirm != null) {
            this.brokingFirms.add(brokingFirm);
            ListModel listModel = this.jList1.getModel();
            DefaultListModel defaultListModel = (DefaultListModel)listModel;
            defaultListModel.addElement(brokingFirm.getName());
            this.jList1.setSelectedIndex(defaultListModel.size() - 1);
        }
        this.updateGUIState();
    }

    private void jCheckBox1ItemStateChanged(ItemEvent evt) {
        this.updateGUIState();
    }

    private void updateCurrentSelectedBrokingFirm() {
        if (this.currentSelectedBrokingFirm != null) {
            this.currentSelectedBrokingFirm.setBrokerRate((Double)this.jFormattedTextField1.getValue());
            this.currentSelectedBrokingFirm.setBrokerMaximumRate((Double)this.jFormattedTextField2.getValue());
            this.currentSelectedBrokingFirm.setBrokerMinimumRate((Double)this.jFormattedTextField3.getValue());
            this.currentSelectedBrokingFirm.setClearingFeeRate((Double)this.jFormattedTextField4.getValue());
            this.currentSelectedBrokingFirm.setClearingFeeMaximumRate((Double)this.jFormattedTextField5.getValue());
            this.currentSelectedBrokingFirm.setClearingFeeMinimumRate((Double)this.jFormattedTextField6.getValue());
            this.currentSelectedBrokingFirm.setStampDutyRate((Double)this.jFormattedTextField7.getValue());
            this.currentSelectedBrokingFirm.setStampDutyFraction((Double)this.jFormattedTextField8.getValue());
            this.currentSelectedBrokingFirm.setStampDutyMaximumRate((Double)this.jFormattedTextField9.getValue());
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        final ListSelectionEvent e = evt;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionsBrokerJPanel.this.updateCurrentSelectedBrokingFirm();
                JList me = (JList)e.getSource();
                int index = me.getSelectedIndex();
                if (index < 0) {
                    OptionsBrokerJPanel.this.jFormattedTextField1.setValue(0.0);
                    OptionsBrokerJPanel.this.jFormattedTextField2.setValue(0.0);
                    OptionsBrokerJPanel.this.jFormattedTextField3.setValue(0.0);
                    OptionsBrokerJPanel.this.jFormattedTextField4.setValue(0.0);
                    OptionsBrokerJPanel.this.jFormattedTextField5.setValue(0.0);
                    OptionsBrokerJPanel.this.jFormattedTextField6.setValue(0.0);
                    OptionsBrokerJPanel.this.jFormattedTextField7.setValue(0.0);
                    OptionsBrokerJPanel.this.jFormattedTextField8.setValue(1.0);
                    OptionsBrokerJPanel.this.jFormattedTextField9.setValue(0.0);
                    OptionsBrokerJPanel.this.setLogo(null);
                    OptionsBrokerJPanel.this.currentSelectedBrokingFirm = null;
                    return;
                }
                BrokingFirm brokingFirm = (BrokingFirm)OptionsBrokerJPanel.this.brokingFirms.get(index);
                OptionsBrokerJPanel.this.jFormattedTextField1.setValue(brokingFirm.getBrokerRate());
                OptionsBrokerJPanel.this.jFormattedTextField2.setValue(brokingFirm.getBrokerMaximumRate());
                OptionsBrokerJPanel.this.jFormattedTextField3.setValue(brokingFirm.getBrokerMinimumRate());
                OptionsBrokerJPanel.this.jFormattedTextField4.setValue(brokingFirm.getClearingFeeRate());
                OptionsBrokerJPanel.this.jFormattedTextField5.setValue(brokingFirm.getClearingFeeMaximumRate());
                OptionsBrokerJPanel.this.jFormattedTextField6.setValue(brokingFirm.getClearingFeeMinimumRate());
                OptionsBrokerJPanel.this.jFormattedTextField7.setValue(brokingFirm.getStampDutyRate());
                OptionsBrokerJPanel.this.jFormattedTextField8.setValue(brokingFirm.getStampDutyFraction());
                OptionsBrokerJPanel.this.jFormattedTextField9.setValue(brokingFirm.getStampDutyMaximumRate());
                OptionsBrokerJPanel.this.setLogo(brokingFirm.getLogo());
                OptionsBrokerJPanel.this.currentSelectedBrokingFirm = brokingFirm;
            }
        });
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        if (this.currentSelectedBrokingFirm == null) {
            return;
        }
        OptionsJDialog optionsJDialog = (OptionsJDialog)SwingUtilities.getAncestorOfClass(OptionsJDialog.class, this);
        NewBrokingFirmJDialog newBrokingFirmJDialog = new NewBrokingFirmJDialog((Frame)optionsJDialog.getParent(), true);
        newBrokingFirmJDialog.setBrokingFirm(this.currentSelectedBrokingFirm);
        newBrokingFirmJDialog.setVisible(true);
        BrokingFirm brokingFirm = newBrokingFirmJDialog.getBrokingFirm();
        if (brokingFirm != null) {
            int index = this.jList1.getSelectedIndex();
            this.brokingFirms.remove(index);
            this.brokingFirms.add(index, brokingFirm);
            ListModel listModel = this.jList1.getModel();
            DefaultListModel defaultListModel = (DefaultListModel)listModel;
            defaultListModel.removeElementAt(index);
            defaultListModel.add(index, brokingFirm.getName());
            this.jList1.setSelectedIndex(index);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.brokingFirms.remove(index);
        ListModel listModel = this.jList1.getModel();
        DefaultListModel defaultListModel = (DefaultListModel)listModel;
        defaultListModel.removeElementAt(index);
        if (index > 0) {
            this.jList1.setSelectedIndex(index - 1);
        } else if (defaultListModel.getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        } else {
            this.jList1.clearSelection();
        }
        this.updateGUIState();
    }

    private void jCheckBox2ItemStateChanged(ItemEvent evt) {
        this.updateGUIState();
    }

    private void updateGUIState() {
        boolean mother_of_all_state = this.jCheckBox2.isSelected();
        boolean state0 = mother_of_all_state & this.jCheckBox1.isSelected();
        boolean state1 = mother_of_all_state & this.jCheckBox1.isSelected() && this.jList1.getSelectedIndex() >= 0;
        this.jCheckBox1.setEnabled(mother_of_all_state);
        this.jButton1.setEnabled(state0);
        this.jButton2.setEnabled(state0);
        this.jButton3.setEnabled(state0);
        this.jLabel1.setEnabled(state0);
        this.jList1.setEnabled(state0);
        this.jPanel2.setEnabled(state0);
        this.jPanel6.setEnabled(state0);
        this.jFormattedTextField1.setEnabled(state1);
        this.jFormattedTextField2.setEnabled(state1);
        this.jFormattedTextField3.setEnabled(state1);
        this.jFormattedTextField4.setEnabled(state1);
        this.jFormattedTextField5.setEnabled(state1);
        this.jFormattedTextField6.setEnabled(state1);
        this.jFormattedTextField7.setEnabled(state1);
        this.jFormattedTextField8.setEnabled(state1);
        this.jFormattedTextField9.setEnabled(state1);
        this.jLabel10.setEnabled(state1);
        this.jLabel2.setEnabled(state1);
        this.jLabel3.setEnabled(state1);
        this.jLabel4.setEnabled(state1);
        this.jLabel5.setEnabled(state1);
        this.jLabel6.setEnabled(state1);
        this.jLabel7.setEnabled(state1);
        this.jLabel8.setEnabled(state1);
        this.jLabel9.setEnabled(state1);
        this.jPanel3.setEnabled(state1);
        this.jPanel4.setEnabled(state1);
        this.jPanel5.setEnabled(state1);
        this.jPanel6.setEnabled(state1);
        this.jScrollPane1.setEnabled(state1);
    }

    private void setLogo(Image logo) {
        if (logo == null) {
            this.jLabel1.setIcon(null);
            return;
        }
        ImageIcon scaledImageIcon = new ImageIcon(Utils.getScaledImage(logo, this.jLabel1.getWidth() - 2, this.jLabel1.getHeight() - 2));
        this.jLabel1.setIcon(scaledImageIcon);
    }

    @Override
    public void set(JStockOptions jStockOptions) {
        int size = jStockOptions.getBrokingFirmSize();
        DefaultListModel defaultListModel = (DefaultListModel)this.jList1.getModel();
        for (int i = 0; i < size; ++i) {
            this.brokingFirms.add(new BrokingFirm(jStockOptions.getBrokingFirm(i)));
            defaultListModel.addElement(this.brokingFirms.get(i).getName());
        }
        this.jCheckBox2.setSelected(jStockOptions.isFeeCalculationEnabled());
        this.jCheckBox1.setSelected(jStockOptions.isAutoBrokerFeeCalculationEnabled());
        if (jStockOptions.getSelectedBrokingFirmIndex() >= 0) {
            this.jList1.setSelectedIndex(jStockOptions.getSelectedBrokingFirmIndex());
        }
        this.updateGUIState();
    }

    @Override
    public boolean apply(JStockOptions jStockOptions) {
        this.updateCurrentSelectedBrokingFirm();
        jStockOptions.clearBrokingFirms();
        for (BrokingFirm brokingFirm : this.brokingFirms) {
            jStockOptions.addBrokingFirm(brokingFirm);
        }
        jStockOptions.setFeeCalculationEnabled(this.jCheckBox2.isSelected());
        jStockOptions.setAutoBrokerFeeCalculationEnabled(this.jCheckBox1.isSelected());
        jStockOptions.setSelectedBrokingFirmIndex(this.jList1.getSelectedIndex());
        return true;
    }
}

