/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.alert.GoogleCalendar;
import org.yccheok.jstock.alert.GoogleMail;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JStockOptionsObserver;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.internationalization.MessagesBundle;

public class OptionsAlertJPanel
extends JPanel
implements JStockOptionsObserver {
    private volatile SwingWorker testSMSSwingWorker = null;
    private volatile SwingWorker testEmailSwingWorker = null;
    private static final Log log = LogFactory.getLog(OptionsAlertJPanel.class);
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JComboBox jComboBox1;
    private JEditorPane jEditorPane3;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPasswordField jPasswordField1;
    private JPasswordField jPasswordField2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JXHeader jXHeader1;

    public OptionsAlertJPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jXHeader1 = new JXHeader();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jCheckBox2 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jPasswordField1 = new JPasswordField();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel7 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel12 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jCheckBox3 = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jPasswordField2 = new JPasswordField();
        this.jButton2 = new JButton();
        this.jEditorPane3 = new JEditorPane();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jButton3 = new JButton();
        this.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jXHeader1.setDescription(bundle.getString("OptionsAlertJPanel_description"));
        this.jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/bell.png")));
        this.jXHeader1.setTitle(bundle.getString("OptionsAlertJPanel_Alert"));
        this.add((Component)this.jXHeader1, "North");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsAlertJPanel_Email")));
        this.jCheckBox2.setText(bundle.getString("OptionsAlertJPanel_SendMessageToEmails"));
        this.jCheckBox2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionsAlertJPanel.this.jCheckBox2ItemStateChanged(evt);
            }
        });
        this.jLabel1.setText(bundle.getString("OptionsAlertJPanel_Email"));
        this.jLabel1.setEnabled(false);
        this.jLabel3.setText(bundle.getString("OptionsAlertJPanel_Password"));
        this.jLabel3.setEnabled(false);
        this.jTextField2.setEnabled(false);
        this.jTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jTextField2ActionPerformed(evt);
            }
        });
        this.jPasswordField1.setEnabled(false);
        this.jPasswordField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jPasswordField1ActionPerformed(evt);
            }
        });
        this.jLabel2.setForeground(new Color(0, 0, 255));
        this.jLabel2.setText("@gmail.com");
        this.jLabel2.setEnabled(false);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/mail_send.png")));
        this.jButton1.setText(bundle.getString("OptionsAlertJPanel_TestEmail"));
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        this.jLabel11.setText(bundle.getString("OptionsAlertJPanel_CCCopy"));
        this.jLabel11.setEnabled(false);
        this.jTextField1.setEnabled(false);
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jLabel12.setFont(this.jLabel12.getFont().deriveFont((float)this.jLabel12.getFont().getSize() - 1.0f));
        this.jLabel12.setText(bundle.getString("OptionsAlertJPanel_EmailExample"));
        this.jLabel12.setEnabled(false);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox2).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3)).addGap(21, 21, 21)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel11).addGap(25, 25, 25))).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPasswordField1, GroupLayout.Alignment.LEADING).addComponent(this.jTextField2, GroupLayout.Alignment.LEADING, -1, 139, Short.MAX_VALUE).addComponent(this.jTextField1, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7)).addComponent(this.jLabel12)))).addContainerGap(103, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPasswordField1, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jButton1))).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.jLabel11)).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsAlertJPanel_SMS")));
        this.jCheckBox3.setText(bundle.getString("OptionsAlertJPanel_SMSThroughGoogleCalendar"));
        this.jCheckBox3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionsAlertJPanel.this.jCheckBox3ItemStateChanged(evt);
            }
        });
        this.jLabel4.setText(bundle.getString("OptionsAlertJPanel_Username"));
        this.jLabel4.setEnabled(false);
        this.jLabel5.setText(bundle.getString("OptionsAlertJPanel_Password"));
        this.jLabel5.setEnabled(false);
        this.jTextField3.setEnabled(false);
        this.jTextField3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jTextField3ActionPerformed(evt);
            }
        });
        this.jPasswordField2.setEnabled(false);
        this.jPasswordField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jPasswordField2ActionPerformed(evt);
            }
        });
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/sms_protocol.png")));
        this.jButton2.setText(bundle.getString("OptionsAlertJPanel_TestSMS"));
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jEditorPane3.setBackground(new Color(240, 240, 240));
        this.jEditorPane3.setContentType("text/html");
        this.jEditorPane3.setEditable(false);
        this.jEditorPane3.setText(bundle.getString("OptionsAlertJPanel_FindOutHowToSetupYourMobilePhone"));
        this.jEditorPane3.setEnabled(false);
        this.jEditorPane3.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                OptionsAlertJPanel.this.jEditorPane3jEditorPane1HyperlinkUpdate(evt);
            }
        });
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont((float)this.jLabel6.getFont().getSize() - 1.0f));
        this.jLabel6.setText(bundle.getString("OptionsAlertJPanel_EmailExample2"));
        this.jLabel6.setEnabled(false);
        this.jLabel8.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/spinner.gif")));
        this.jLabel9.setText(bundle.getString("OptionsAlertJPanel_Limit"));
        this.jLabel9.setEnabled(false);
        this.jComboBox1.setModel(this.getComboBoxModel());
        this.jComboBox1.setEnabled(false);
        this.jLabel10.setText(bundle.getString("OptionsAlertJPanel_SMSPerDay"));
        this.jLabel10.setEnabled(false);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox3).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel9)).addGap(21, 21, 21).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10)).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPasswordField2).addComponent(this.jTextField3, -2, 139, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8)).addComponent(this.jLabel6))))).addComponent(this.jEditorPane3, -2, -1, -2)).addContainerGap(105, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jCheckBox3, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jPasswordField2, -2, -1, -2).addComponent(this.jLabel5)).addGroup(jPanel4Layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jLabel8))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addComponent(this.jEditorPane3, -2, -1, -2).addGap(16, 16, 16)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsAlertJPanel_System")));
        this.jCheckBox1.setText(bundle.getString("OptionsAlertJPanel_ShowAMessage"));
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox4.setText(bundle.getString("OptionsAlertJPanel_PlayingAlertSound"));
        this.jCheckBox4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox4.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionsAlertJPanel.this.jCheckBox4ItemStateChanged(evt);
            }
        });
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/sound.png")));
        this.jButton3.setText(bundle.getString("OptionsAlertJPanel_TestSound"));
        this.jButton3.setEnabled(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsAlertJPanel.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jCheckBox4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)).addComponent(this.jCheckBox1)).addGap(134, 134, 134)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox1).addGap(16, 16, 16).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox4).addComponent(this.jButton3)).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -1, 458, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap(29, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Center");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.jTextField2.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Email address cannot be empty", "Empty email", 2);
            this.jTextField2.requestFocus();
            return;
        }
        if (this.jPasswordField1.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, "Email password cannot be empty", "Empty password", 2);
            this.jPasswordField1.requestFocus();
            return;
        }
        this.testEmailSwingWorker = this.getTestEmailSwingWorker();
        this.updateGUIState();
        this.jButton1.requestFocus();
        this.testEmailSwingWorker.execute();
    }

    private void jCheckBox2ItemStateChanged(ItemEvent evt) {
        this.updateGUIState();
    }

    private void jEditorPane3jEditorPane1HyperlinkUpdate(HyperlinkEvent evt) {
        Utils.launchWebBrowser(evt);
    }

    private void jCheckBox3ItemStateChanged(ItemEvent evt) {
        this.updateGUIState();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.jTextField3.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_sms_username_cannot_be_empty"), MessagesBundle.getString("warning_title_sms_username_cannot_be_empty"), 2);
            this.jTextField3.requestFocus();
            return;
        }
        if (this.jPasswordField2.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_sms_password_cannot_be_empty"), MessagesBundle.getString("warning_title_sms_password_cannot_be_empty"), 2);
            this.jPasswordField2.requestFocus();
            return;
        }
        this.testSMSSwingWorker = this.getTestSMSSwingWorker();
        this.updateGUIState();
        this.jButton2.requestFocus();
        this.testSMSSwingWorker.execute();
    }

    private void jCheckBox4ItemStateChanged(ItemEvent evt) {
        this.updateGUIState();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        Utils.playAlertSound();
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
        this.jButton1.doClick();
    }

    private void jPasswordField1ActionPerformed(ActionEvent evt) {
        this.jButton1.doClick();
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.jButton1.doClick();
    }

    private void jTextField3ActionPerformed(ActionEvent evt) {
        this.jButton2.doClick();
    }

    private void jPasswordField2ActionPerformed(ActionEvent evt) {
        this.jButton2.doClick();
    }

    public void cancel() {
        if (this.testSMSSwingWorker != null) {
            this.testSMSSwingWorker.cancel(true);
        }
        if (this.testEmailSwingWorker != null) {
            this.testEmailSwingWorker.cancel(true);
        }
    }

    private ComboBoxModel getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{"1", "5", "10", "20", "50", GUIBundle.getString("OptionsAlertJPanel_Unlimited")});
    }

    @Override
    public void set(JStockOptions jStockOptions) {
        this.jCheckBox1.setSelected(jStockOptions.isPopupMessage());
        this.jCheckBox2.setSelected(jStockOptions.isSendEmail());
        this.jCheckBox3.setSelected(jStockOptions.isSMSEnabled());
        this.jCheckBox4.setSelected(jStockOptions.isSoundEnabled());
        this.jTextField2.setText(Utils.decrypt(jStockOptions.getEmail()));
        this.jTextField1.setText(Utils.decrypt(jStockOptions.getCCEmail()));
        this.jPasswordField1.setText(Utils.decrypt(jStockOptions.getEmailPassword()));
        this.jTextField3.setText(Utils.decrypt(jStockOptions.getGoogleCalendarUsername()));
        this.jPasswordField2.setText(Utils.decrypt(jStockOptions.getGoogleCalendarPassword()));
        if (jStockOptions.getMaxSMSPerDay() <= 0) {
            this.jComboBox1.setSelectedItem(GUIBundle.getString("OptionsAlertJPanel_Unlimited"));
        } else {
            this.jComboBox1.setSelectedItem("" + jStockOptions.getMaxSMSPerDay());
        }
        this.updateGUIState();
    }

    @Override
    public boolean apply(JStockOptions jStockOptions) {
        if (this.jCheckBox2.isSelected()) {
            if (this.jTextField2.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Email address cannot be empty", "Empty email", 2);
                this.jTextField2.requestFocus();
                return false;
            }
            if (this.jPasswordField1.getPassword().length == 0) {
                JOptionPane.showMessageDialog(this, "Email password cannot be empty", "Empty password", 2);
                this.jPasswordField1.requestFocus();
                return false;
            }
        }
        if (this.jCheckBox3.isSelected()) {
            if (this.jTextField3.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "SMS username cannot be empty", "Empty SMS username", 2);
                this.jTextField3.requestFocus();
                return false;
            }
            if (this.jPasswordField2.getPassword().length == 0) {
                JOptionPane.showMessageDialog(this, "SMS password cannot be empty", "Empty SMS password", 2);
                this.jPasswordField2.requestFocus();
                return false;
            }
        }
        jStockOptions.setSoundEnabled(this.jCheckBox4.isSelected());
        jStockOptions.setPopupMessage(this.jCheckBox1.isSelected());
        jStockOptions.setSendEmail(this.jCheckBox2.isSelected());
        jStockOptions.setEmail(Utils.encrypt(this.jTextField2.getText().trim()));
        jStockOptions.setCCEmail(Utils.encrypt(this.jTextField1.getText().trim()));
        jStockOptions.setEmailPassword(Utils.encrypt(new String(this.jPasswordField1.getPassword())));
        jStockOptions.setSMSEnabled(this.jCheckBox3.isSelected());
        jStockOptions.setGoogleCalendarUsername(Utils.encrypt(this.jTextField3.getText().trim()));
        jStockOptions.setGoogleCalendarPassword(Utils.encrypt(new String(this.jPasswordField2.getPassword())));
        int maxSMSPerDay = -1;
        try {
            maxSMSPerDay = Integer.parseInt(this.jComboBox1.getSelectedItem().toString());
            jStockOptions.setMaxSMSPerDay(maxSMSPerDay);
        }
        catch (NumberFormatException exp) {
            log.error(null, (Throwable)exp);
            jStockOptions.setMaxSMSPerDay(-1);
        }
        return true;
    }

    private void updateGUIState() {
        boolean isTestEmailDone = this.testEmailSwingWorker == null || this.testEmailSwingWorker.isDone();
        boolean isTestSMSDone = this.testSMSSwingWorker == null || this.testSMSSwingWorker.isDone();
        boolean soundState = this.jCheckBox4.isSelected();
        boolean emailState = this.jCheckBox2.isSelected();
        boolean smsState = this.jCheckBox3.isSelected();
        this.jButton3.setEnabled(soundState);
        this.jLabel1.setEnabled(emailState);
        this.jLabel11.setEnabled(emailState);
        this.jLabel2.setEnabled(emailState);
        this.jLabel3.setEnabled(emailState);
        this.jLabel12.setEnabled(emailState);
        this.jButton1.setEnabled(emailState && isTestEmailDone);
        this.jTextField2.setEnabled(emailState && isTestEmailDone);
        this.jTextField1.setEnabled(emailState && isTestEmailDone);
        this.jPasswordField1.setEnabled(emailState && isTestEmailDone);
        this.jCheckBox2.setEnabled(isTestEmailDone);
        this.jLabel7.setVisible(!isTestEmailDone);
        this.jLabel4.setEnabled(smsState);
        this.jLabel5.setEnabled(smsState);
        this.jButton2.setEnabled(smsState && isTestSMSDone);
        this.jTextField3.setEnabled(smsState && isTestSMSDone);
        this.jPasswordField2.setEnabled(smsState && isTestSMSDone);
        this.jCheckBox3.setEnabled(isTestSMSDone);
        this.jLabel6.setEnabled(smsState);
        this.jEditorPane3.setEnabled(smsState);
        this.jLabel8.setVisible(!isTestSMSDone);
        this.jLabel9.setEnabled(smsState);
        this.jLabel10.setEnabled(smsState);
        this.jComboBox1.setEnabled(smsState);
    }

    private SwingWorker getTestEmailSwingWorker() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            public Boolean doInBackground() {
                boolean status = true;
                try {
                    String username = OptionsAlertJPanel.this.jTextField2.getText().trim();
                    String cc_email = OptionsAlertJPanel.this.jTextField1.getText().trim();
                    GoogleMail.Send(username, new String(OptionsAlertJPanel.this.jPasswordField1.getPassword()), username + "@gmail.com", cc_email, MessagesBundle.getString("info_message_congratulation_email_alert_system_is_working"), MessagesBundle.getString("info_message_congratulation_email_alert_system_is_working"));
                }
                catch (AddressException ex) {
                    log.error(null, (Throwable)ex);
                    status = false;
                }
                catch (MessagingException ex) {
                    log.error(null, (Throwable)ex);
                    status = false;
                }
                return status;
            }

            @Override
            public void done() {
                if (this.isCancelled()) {
                    return;
                }
                Boolean status = null;
                try {
                    status = (Boolean)this.get();
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (CancellationException ex) {
                    log.error(null, (Throwable)ex);
                }
                OptionsAlertJPanel.this.updateGUIState();
                if (status == null || !status.booleanValue()) {
                    JOptionPane.showMessageDialog(OptionsAlertJPanel.this, MessagesBundle.getString("error_message_error_in_sending_email"), MessagesBundle.getString("error_title_error_in_sending_email"), 0);
                } else {
                    JOptionPane.showMessageDialog(OptionsAlertJPanel.this, MessagesBundle.getString("info_message_email_alert_system_is_working"), MessagesBundle.getString("info_title_email_alert_system_is_working"), 1);
                }
            }
        };
        return worker;
    }

    private SwingWorker getTestSMSSwingWorker() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            public Boolean doInBackground() {
                String username = OptionsAlertJPanel.this.jTextField3.getText().trim();
                if ((username = Utils.toEmailIfPossible(username)) == null) {
                    return false;
                }
                String password = new String(OptionsAlertJPanel.this.jPasswordField2.getPassword());
                boolean status = GoogleCalendar.SMS(username, password, MessagesBundle.getString("info_message_congratulation_sms_alert_system_is_working"));
                return status;
            }

            @Override
            public void done() {
                if (this.isCancelled()) {
                    return;
                }
                Boolean status = null;
                try {
                    status = (Boolean)this.get();
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (CancellationException ex) {
                    log.error(null, (Throwable)ex);
                }
                OptionsAlertJPanel.this.updateGUIState();
                if (status == null || !status.booleanValue()) {
                    JOptionPane.showMessageDialog(OptionsAlertJPanel.this, MessagesBundle.getString("error_message_error_in_sending_sms"), MessagesBundle.getString("error_title_error_in_sending_sms"), 0);
                } else {
                    JOptionPane.showMessageDialog(OptionsAlertJPanel.this, MessagesBundle.getString("info_message_sms_alert_system_is_working"), MessagesBundle.getString("info_title_sms_alert_system_is_working"), 1);
                }
            }
        };
        return worker;
    }
}

