/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Index;
import org.yccheok.jstock.engine.Market;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.GUIBundle;

public class MarketJPanel
extends JPanel {
    private Country country = null;
    private Map<String, JLabel> map = new HashMap<String, JLabel>();
    JPanel leftPanel;

    public MarketJPanel(Country country) {
        this.initComponents();
        this.country = country;
        this.initAccordingToCountry(country);
    }

    private void initComponents() {
        this.leftPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.leftPanel, "West");
    }

    public void update(List<Market> markets) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        for (Market market : markets) {
            double _index = market.stock.getLastPrice();
            double change = market.stock.getChangePrice();
            Color color = Utils.getColor(change, 0.0);
            JLabel label = this.map.get(market.index.name());
            if (label == null) continue;
            label.setText(numberFormat.format(_index) + " (" + numberFormat.format(change) + ")");
            label.setForeground(color);
        }
    }

    private void initAccordingToCountry(Country country) {
        List<Index> indices = org.yccheok.jstock.engine.Utils.getStockIndices(country);
        for (final Index index : indices) {
            JLabel name = new JLabel(index.toString() + " : ");
            this.leftPanel.add(name);
            JLabel value = new JLabel();
            value.setName(index.name());
            this.map.put(index.name(), value);
            value.setFont(Utils.getBoldFont(value.getFont()));
            this.leftPanel.add(value);
            name.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    MarketJPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    MarketJPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    Code code = index.code;
                    MainFrame m = MainFrame.getInstance();
                    Stock stock = Utils.getEmptyStock(code, Symbol.newInstance(code.toString()));
                    m.displayHistoryChart(stock);
                }
            });
        }
    }

    private String getValueLabel() {
        return MessageFormat.format(GUIBundle.getString("MainFrame_ValueLabel_template"), "$");
    }

    public Country getCountry() {
        return this.country;
    }
}

