/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.gui.IndicatorDefaultDrawing;
import org.yccheok.jstock.gui.Utils;

public class IndicatorProjectManager {
    private OperatorIndicator.Type preferredOperatorIndicatorType;
    private static final Log log = LogFactory.getLog(IndicatorProjectManager.class);
    private static final String JHOTDRAW_RESERVE_WORD = "-jhotdraw";
    private final List<String> projects = new ArrayList<String>();
    private String directory;

    public OperatorIndicator.Type getPreferredOperatorIndicatorType() {
        return this.preferredOperatorIndicatorType;
    }

    public IndicatorProjectManager(String directory, OperatorIndicator.Type preferredOperatorIndicatorType) {
        Utils.createCompleteDirectoryHierarchyIfDoesNotExist(directory);
        this.preferredOperatorIndicatorType = preferredOperatorIndicatorType;
        this.directory = directory;
    }

    public int getNumOfProject() {
        return this.projects.size();
    }

    public String getProject(int index) {
        return this.projects.get(index);
    }

    public boolean addProject(IndicatorDefaultDrawing drawing, String project) {
        String substring;
        int reserve_word_length = JHOTDRAW_RESERVE_WORD.length();
        if (project.length() >= reserve_word_length && (substring = project.substring(project.length() - reserve_word_length, project.length())).equalsIgnoreCase(JHOTDRAW_RESERVE_WORD)) {
            return false;
        }
        if (!this.contains(project)) {
            this.projects.add(project);
        }
        try {
            drawing.write(project, this.getJHotDrawFilename(project), this.getOperatorIndicatorFilename(project));
        }
        catch (IOException exp) {
            this.projects.remove(project);
            log.error(null, (Throwable)exp);
            return false;
        }
        return true;
    }

    private String getJHotDrawFilename(String project) {
        return this.directory + File.separator + project + JHOTDRAW_RESERVE_WORD + ".xml";
    }

    private String getOperatorIndicatorFilename(String project) {
        return this.directory + File.separator + project + ".xml";
    }

    public boolean removeProject(String project) {
        if (!new File(this.getJHotDrawFilename(project)).delete()) {
            // empty if block
        }
        if (!new File(this.getOperatorIndicatorFilename(project)).delete()) {
            // empty if block
        }
        return this.projects.remove(project);
    }

    public boolean renameProject(String newProject, String oldProject) {
        if (newProject.equals(oldProject)) {
            return true;
        }
        File oldJHotDrawFile = new File(this.getJHotDrawFilename(oldProject));
        File oldOperatorIndicatorFile = new File(this.getOperatorIndicatorFilename(oldProject));
        File newJHotDrawFile = new File(this.getJHotDrawFilename(newProject));
        File newOperatorIndicatorFile = new File(this.getOperatorIndicatorFilename(newProject));
        if (!oldJHotDrawFile.renameTo(newJHotDrawFile)) {
            return false;
        }
        if (!oldOperatorIndicatorFile.renameTo(newOperatorIndicatorFile)) {
            return false;
        }
        int index = this.projects.indexOf(oldProject);
        if (index == -1) {
            return false;
        }
        boolean status = this.projects.remove(oldProject);
        if (!status) {
            return false;
        }
        this.projects.add(index, newProject);
        OperatorIndicator operatorIndicator = this.getOperatorIndicator(newProject);
        operatorIndicator.setName(newProject);
        return Utils.toXML((Object)operatorIndicator, this.getOperatorIndicatorFilename(newProject));
    }

    public IndicatorDefaultDrawing getIndicatorDefaultDrawing(String project) {
        if (!this.contains(project)) {
            return null;
        }
        IndicatorDefaultDrawing drawing = new IndicatorDefaultDrawing();
        try {
            drawing.read(this.getJHotDrawFilename(project), this.getOperatorIndicatorFilename(project));
        }
        catch (IOException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
        return drawing;
    }

    public OperatorIndicator getOperatorIndicator(String project) {
        if (!this.contains(project)) {
            return null;
        }
        File operatorIndicatorFile = new File(this.getOperatorIndicatorFilename(project));
        return Utils.fromXML(OperatorIndicator.class, operatorIndicatorFile);
    }

    public boolean contains(String project) {
        for (String p : this.projects) {
            if (!p.equalsIgnoreCase(project)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean install(File zipFile) {
        projectName = IndicatorProjectManager.getProjectName(zipFile);
        if (projectName == null) {
            return false;
        }
        jHotDrawFilename = projectName + "-jhotdraw" + ".xml";
        operatorIndicatorFilename = projectName + ".xml";
        status = true;
        in = null;
        try {
            in = new ZipInputStream(new FileInputStream(zipFile));
            zipEntry = null;
            while ((zipEntry = in.getNextEntry()) != null) {
                name = zipEntry.getName();
                outFilename = null;
                if (name.equalsIgnoreCase(operatorIndicatorFilename)) {
                    outFilename = this.getOperatorIndicatorFilename(projectName);
                } else if (name.equalsIgnoreCase(jHotDrawFilename)) {
                    outFilename = this.getJHotDrawFilename(projectName);
                } else if (!IndicatorProjectManager.$assertionsDisabled) {
                    throw new AssertionError();
                }
                out = null;
                try {
                    out = new FileOutputStream(outFilename);
                    buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                catch (Throwable var13_14) {
                    Utils.close(out);
                    Utils.closeEntry(in);
                    throw var13_14;
                }
                Utils.close(out);
                Utils.closeEntry(in);
            }
            ** GOTO lbl46
        }
        catch (IOException ex) {
            try {
                IndicatorProjectManager.log.error(null, (Throwable)ex);
                status = false;
            }
            catch (Throwable var14_15) {
                Utils.close(in);
                throw var14_15;
            }
lbl46:
            // 1 sources

            Utils.close(in);
            Utils.close(in);
        }
        if (!status) {
            new File(this.getOperatorIndicatorFilename(projectName)).delete();
            new File(this.getJHotDrawFilename(projectName)).delete();
            return false;
        }
        operatorIndicator = Utils.fromXML(OperatorIndicator.class, this.getOperatorIndicatorFilename(projectName));
        if (operatorIndicator == null || operatorIndicator.getType() != this.preferredOperatorIndicatorType) {
            new File(this.getOperatorIndicatorFilename(projectName)).delete();
            new File(this.getJHotDrawFilename(projectName)).delete();
            return false;
        }
        if (!this.contains(projectName)) {
            this.projects.add(projectName);
        }
        return true;
    }

    public static String getProjectName(File zipFile) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            ZipFile zf = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                boolean isDirectory = zipEntry.isDirectory();
                if (isDirectory) {
                    return null;
                }
                names.add(name);
            }
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        if (names.size() != 2) {
            return null;
        }
        String projectName = null;
        for (String name : names) {
            int index = name.indexOf(".xml");
            if (index < 0) continue;
            String _projectName = name.substring(0, index);
            projectName = projectName == null ? _projectName : (projectName.length() > _projectName.length() ? _projectName : projectName);
        }
        if (projectName == null || projectName.length() <= 0) {
            return null;
        }
        String operatorIndicatorFilename = projectName + ".xml";
        String jHotDrawFilename = projectName + JHOTDRAW_RESERVE_WORD + ".xml";
        for (String name : names) {
            if (name.equalsIgnoreCase(operatorIndicatorFilename) || name.equalsIgnoreCase(jHotDrawFilename)) continue;
            return null;
        }
        return projectName;
    }

    public PreInstallStatus getPreInstallStatus(File zipFile) {
        String projectName = IndicatorProjectManager.getProjectName(zipFile);
        if (projectName == null) {
            return PreInstallStatus.Unsafe;
        }
        return this.contains(projectName) ? PreInstallStatus.Collision : PreInstallStatus.Safe;
    }

    private Object readResolve() {
        if (this.preferredOperatorIndicatorType == null) {
            this.preferredOperatorIndicatorType = OperatorIndicator.Type.AlertIndicator;
        }
        if (this.directory.endsWith("indicator")) {
            this.directory = Utils.getUserDataDirectory() + "indicator";
        } else if (this.directory.endsWith("module")) {
            this.directory = Utils.getUserDataDirectory() + "module";
        } else {
            log.error((Object)"Something goes wrong during directory initialization");
            assert (false);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(String project, File zipFile) {
        byte[] buf = new byte[1024];
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipFile));
            ArrayList<String> filenames = new ArrayList<String>();
            filenames.add(this.getOperatorIndicatorFilename(project));
            filenames.add(this.getJHotDrawFilename(project));
            for (String filename : filenames) {
                FileInputStream in = null;
                try {
                    int len;
                    in = new FileInputStream(filename);
                    out.putNextEntry(new ZipEntry(new File(filename).getName()));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                finally {
                    Utils.closeEntry(out);
                    Utils.close(in);
                }
            }
        }
        catch (IOException ex) {
            boolean bl;
            try {
                log.error(null, (Throwable)ex);
                bl = false;
            }
            catch (Throwable throwable) {
                Utils.close(out);
                throw throwable;
            }
            Utils.close(out);
            return bl;
        }
        Utils.close(out);
        return true;
    }

    public static enum PreInstallStatus {
        Safe,
        Unsafe,
        Collision;

    }
}

