/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class GUIOptions {
    private final List<JTableOptions> jTableOptionsList = new ArrayList<JTableOptions>();
    private List<Integer> dividerLocationList = new ArrayList<Integer>();

    public int getJTableOptionsSize() {
        return this.jTableOptionsList.size();
    }

    public int getDividerLocationSize() {
        return this.dividerLocationList.size();
    }

    public JTableOptions getJTableOptions(int index) {
        return new UnmodifiableJTableOptions(this.jTableOptionsList.get(index));
    }

    public int getDividerLocation(int index) {
        return this.dividerLocationList.get(index);
    }

    public void addJTableOptions(JTableOptions jTableOptions) {
        this.jTableOptionsList.add(jTableOptions);
    }

    public void addDividerLocation(int dividerLocation) {
        this.dividerLocationList.add(dividerLocation);
    }

    private Object readResolve() {
        if (this.dividerLocationList == null) {
            this.dividerLocationList = new ArrayList<Integer>();
        }
        return this;
    }

    private static class UnmodifiableJTableOptions
    extends JTableOptions {
        private final JTableOptions jTableOptions;

        public UnmodifiableJTableOptions(JTableOptions jTableOptions) {
            this.jTableOptions = jTableOptions;
        }

        @Override
        public int getColumnSize() {
            return this.jTableOptions.getColumnSize();
        }

        @Override
        public String getColumnName(int index) {
            return this.jTableOptions.getColumnName(index);
        }

        @Override
        public boolean contains(String name) {
            return this.jTableOptions.contains(name);
        }

        @Override
        public int getColumnWidth(int index) {
            return this.jTableOptions.getColumnWidth(index);
        }

        @Override
        public boolean addColumnOption(JTableOptions.ColumnOption option) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Locale getLocale() {
            return this.jTableOptions.getLocale();
        }
    }

    public static class JTableOptions {
        private final List<ColumnOption> columnOptions = new ArrayList<ColumnOption>();
        private Locale locale = Locale.getDefault();

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public int getColumnSize() {
            return this.columnOptions.size();
        }

        public String getColumnName(int index) {
            return this.columnOptions.get(index).getColumnName();
        }

        private Object readResolve() {
            if (this.getLocale() == null) {
                this.setLocale(Locale.ENGLISH);
            }
            return this;
        }

        public boolean contains(String name) {
            return this.columnOptions.contains(ColumnOption.newInstance(name, 0));
        }

        public int getColumnWidth(int index) {
            return this.columnOptions.get(index).getColumnWidth();
        }

        public boolean addColumnOption(ColumnOption option) {
            if (this.columnOptions.contains(option)) {
                return false;
            }
            this.columnOptions.add(option);
            return true;
        }

        public static class ColumnOption {
            private String columnName;
            private final int columnWidth;

            private ColumnOption(String columnName, int columnWidth) {
                this.columnName = columnName;
                this.columnWidth = columnWidth;
            }

            public static ColumnOption newInstance(String columnName, int columnWidth) {
                return new ColumnOption(columnName, columnWidth);
            }

            public String getColumnName() {
                return this.columnName;
            }

            public int getColumnWidth() {
                return this.columnWidth;
            }

            public int hashCode() {
                int result = 17;
                if (null != this.columnName) {
                    result = 31 * result + this.columnName.hashCode();
                }
                return result;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ColumnOption)) {
                    return false;
                }
                if (this.columnName == null) {
                    return null == ((ColumnOption)o).columnName;
                }
                return this.columnName.equals(((ColumnOption)o).columnName);
            }
        }
    }
}

