/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yccheok.jstock.analysis.Indicator;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.Subject;

public class AlertStateManager
extends Subject<Indicator, Boolean> {
    private final Set<Key> alertRecords = new HashSet<Key>();
    private final Map<Code, Set<Key>> stockCodeToAlertRecords = new HashMap<Code, Set<Key>>();

    public synchronized void clearState() {
        this.alertRecords.clear();
        this.stockCodeToAlertRecords.clear();
    }

    public synchronized void clearState(Stock stock) {
        Code code = stock.code;
        Set<Key> keys = this.stockCodeToAlertRecords.remove(code);
        if (keys == null) {
            return;
        }
        for (Key key : keys) {
            this.alertRecords.remove(key);
        }
    }

    public synchronized void clearState(Indicator indicator, Stock stock) {
        Code code = stock.code;
        Set<Key> keys = this.stockCodeToAlertRecords.get(code);
        if (keys == null) {
            return;
        }
        Stock oldStock = indicator.getStock();
        indicator.setStock(stock);
        Key key = Key.newInstance(indicator);
        keys.remove(key);
        this.alertRecords.remove(key);
        if (keys.size() <= 0) {
            this.stockCodeToAlertRecords.remove(code);
        }
        indicator.setStock(oldStock);
    }

    private synchronized boolean add(Indicator indicator) {
        assert (indicator.getStock() != null);
        Code code = indicator.getStock().code;
        Key key = Key.newInstance(indicator);
        boolean result0 = this.alertRecords.add(key);
        if (!result0) {
            return result0;
        }
        Set<Key> keys = this.stockCodeToAlertRecords.get(code);
        if (keys != null) {
            boolean result1 = keys.add(key);
            assert (result1);
            return result1;
        }
        HashSet<Key> newKeys = new HashSet<Key>();
        newKeys.add(key);
        this.stockCodeToAlertRecords.put(code, newKeys);
        return true;
    }

    private synchronized boolean remove(Indicator indicator) {
        assert (indicator.getStock() != null);
        Code code = indicator.getStock().code;
        Key key = Key.newInstance(indicator);
        boolean result0 = this.alertRecords.remove(key);
        if (!result0) {
            return result0;
        }
        Set<Key> keys = this.stockCodeToAlertRecords.get(code);
        assert (keys != null);
        keys.remove(key);
        if (keys.size() <= 0) {
            this.stockCodeToAlertRecords.remove(code);
        }
        return true;
    }

    public void alert(Indicator indicator) {
        boolean result = indicator.isTriggered();
        if (result) {
            boolean flag = this.add(indicator);
            if (flag) {
                this.notify(indicator, true);
            }
        } else {
            boolean flag = this.remove(indicator);
            if (flag) {
                this.notify(indicator, false);
            }
        }
    }

    public void alert(List<? extends Indicator> indicators) {
        boolean flag;
        boolean result = true;
        for (Indicator indicator : indicators) {
            boolean tmp = indicator.isTriggered();
            if (tmp) continue;
            result = false;
            break;
        }
        if (result) {
            for (Indicator indicator : indicators) {
                flag = this.add(indicator);
                if (!flag) continue;
                this.notify(indicator, true);
            }
        } else {
            for (Indicator indicator : indicators) {
                flag = this.remove(indicator);
                if (!flag) continue;
                this.notify(indicator, false);
            }
        }
    }

    private static class Key {
        private final Indicator indicator;

        private Key(Indicator indicator) {
            this.indicator = indicator;
        }

        public static Key newInstance(Indicator indicator) {
            return new Key(indicator);
        }

        public int hashCode() {
            int result = 17;
            if (this.indicator instanceof OperatorIndicator) {
                result = 31 * result + ((OperatorIndicator)this.indicator).toString().hashCode();
            }
            if (this.indicator.getStock() != null) {
                result = 31 * result + this.indicator.getStock().code.hashCode();
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            boolean result = true;
            Indicator dest = ((Key)o).indicator;
            if (this.indicator instanceof OperatorIndicator && dest instanceof OperatorIndicator) {
                String string0 = ((OperatorIndicator)this.indicator).toString();
                String string1 = ((OperatorIndicator)dest).toString();
                result = string0.equals(string1);
            } else {
                boolean bl = this.indicator != null ? this.indicator.equals(dest) : (result = this.indicator == dest);
            }
            if (!result) {
                return result;
            }
            if (this.indicator == null && dest == null) {
                return true;
            }
            result = this.indicator.getStock() != null && dest.getStock() != null ? this.indicator.getStock().code.equals(dest.getStock().code) : this.indicator.getStock() == dest.getStock();
            return result;
        }

        public String toString() {
            return "" + this.indicator;
        }
    }
}

