/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import au.com.bytecode.opencsv.CSVReader;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.Index;
import org.yccheok.jstock.engine.ResultType;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.StockNameDatabase;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.Pair;

public class Utils {
    private static final List<Index> australiaIndices = new ArrayList<Index>();
    private static final List<Index> austriaIndices = new ArrayList<Index>();
    private static final List<Index> belgiumIndices = new ArrayList<Index>();
    private static final List<Index> brazilIndices = new ArrayList<Index>();
    private static final List<Index> canadaIndices = new ArrayList<Index>();
    private static final List<Index> chinaIndices = new ArrayList<Index>();
    private static final List<Index> denmarkIndices = new ArrayList<Index>();
    private static final List<Index> franceIndices = new ArrayList<Index>();
    private static final List<Index> germanyIndices = new ArrayList<Index>();
    private static final List<Index> hongkongIndices = new ArrayList<Index>();
    private static final List<Index> indiaIndices = new ArrayList<Index>();
    private static final List<Index> indonesiaIndices = new ArrayList<Index>();
    private static final List<Index> israelIndices = new ArrayList<Index>();
    private static final List<Index> italyIndices = new ArrayList<Index>();
    private static final List<Index> koreaIndices = new ArrayList<Index>();
    private static final List<Index> malaysiaIndices = new ArrayList<Index>();
    private static final List<Index> netherlandsIndices = new ArrayList<Index>();
    private static final List<Index> newZealandIndices = new ArrayList<Index>();
    private static final List<Index> norwayIndices = new ArrayList<Index>();
    private static final List<Index> portugalIndices = new ArrayList<Index>();
    private static final List<Index> singaporeIndices = new ArrayList<Index>();
    private static final List<Index> spainIndices = new ArrayList<Index>();
    private static final List<Index> swedenIndices = new ArrayList<Index>();
    private static final List<Index> switzerlandIndices = new ArrayList<Index>();
    private static final List<Index> taiwanIndices = new ArrayList<Index>();
    private static final List<Index> unitedKingdomIndices = new ArrayList<Index>();
    private static final List<Index> unitedStateIndices = new ArrayList<Index>();
    private static final Gson gson;
    private static final Log log;

    private Utils() {
    }

    public static ResultType rectifyResult(ResultType result) {
        String symbolStr = result.symbol;
        String nameStr = result.name;
        if (symbolStr == null) {
            return null;
        }
        if (symbolStr.trim().isEmpty()) {
            return null;
        }
        symbolStr = symbolStr.trim().toUpperCase();
        if (nameStr == null) {
            nameStr = symbolStr;
        }
        if (nameStr.trim().isEmpty()) {
            nameStr = symbolStr;
        }
        nameStr = nameStr.trim();
        return result.deriveWithSymbol(symbolStr).deriveWithName(nameStr);
    }

    public static void setHttpClientProxyFromSystemProperties(HttpClient httpClient) {
        String httpproxyHost = System.getProperties().getProperty("http.proxyHost");
        String httpproxyPort = System.getProperties().getProperty("http.proxyPort");
        if (null == httpproxyHost || null == httpproxyPort) {
            HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
            hostConfiguration.setProxyHost(null);
        } else {
            int port = -1;
            try {
                port = Integer.parseInt(httpproxyPort);
            }
            catch (NumberFormatException exp) {
                // empty catch block
            }
            if (Utils.isValidPortNumber(port)) {
                HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
                hostConfiguration.setProxy(httpproxyHost, port);
            } else {
                HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
                hostConfiguration.setProxyHost(null);
            }
        }
    }

    public static long getDifferenceInDays(long timeInMillis0, long timeInMillis1) {
        long diffMillis = Math.abs(timeInMillis0 - timeInMillis1);
        long diffDays = diffMillis / 86400000L;
        return diffDays;
    }

    public static long getDifferenceInDays(Date date0, Date date1) {
        return Utils.getDifferenceInDays(date0.getTime(), date1.getTime());
    }

    public static long getDifferenceInDays(Calendar calendar0, Calendar calendar1) {
        return Utils.getDifferenceInDays(calendar0.getTimeInMillis(), calendar1.getTimeInMillis());
    }

    public static void resetCalendarTime(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2);
        int date = calendar.get(5);
        calendar.set(year, month, date, 0, 0, 0);
        calendar.set(14, 0);
    }

    public static boolean isValidPortNumber(int portNumber) {
        return portNumber >= 0 && portNumber <= 65534;
    }

    public static boolean isValidPortNumber(String portNumber) {
        int port = -1;
        try {
            port = Integer.parseInt(portNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Utils.isValidPortNumber(port);
    }

    public static File getStockInfoDatabaseFile(Country country) {
        return new File(org.yccheok.jstock.gui.Utils.getUserDataDirectory() + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-info-database.csv");
    }

    public static String getStocksCSVFileLocation(Country country) {
        return org.yccheok.jstock.network.Utils.getJStockStaticServer() + "stocks_information/" + country.toString().toLowerCase() + "/" + "stocks.csv";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Stock> getStocksFromCSVFile(File file) {
        CSVReader csvreader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        ArrayList<Stock> stocks;
        block40: {
            block41: {
                ArrayList<Stock> index2;
                block38: {
                    block39: {
                        ArrayList<Stock> arrayList;
                        block36: {
                            block37: {
                                stocks = new ArrayList<Stock>();
                                fileInputStream = null;
                                inputStreamReader = null;
                                csvreader = null;
                                try {
                                    String[] nextLine;
                                    fileInputStream = new FileInputStream(file);
                                    inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
                                    csvreader = new CSVReader((Reader)inputStreamReader);
                                    String[] types = csvreader.readNext();
                                    if (types == null) {
                                        arrayList = stocks;
                                        if (csvreader == null) break block36;
                                        break block37;
                                    }
                                    int code_index = -1;
                                    int symbol_index = -1;
                                    int name_index = -1;
                                    int board_index = -1;
                                    int industry_index = -1;
                                    boolean success_index = false;
                                    for (int index2 = 0; index2 < types.length; ++index2) {
                                        String type = types[index2];
                                        if (0 == type.compareToIgnoreCase("code")) {
                                            code_index = index2;
                                        } else if (0 == type.compareToIgnoreCase("symbol")) {
                                            symbol_index = index2;
                                        } else if (0 == type.compareToIgnoreCase("name")) {
                                            name_index = index2;
                                        } else if (0 == type.compareToIgnoreCase("board")) {
                                            board_index = index2;
                                        } else if (0 == type.compareToIgnoreCase("industry")) {
                                            industry_index = index2;
                                        }
                                        if (code_index != -1 && symbol_index != -1 && name_index != -1 && board_index != -1 && industry_index != -1) break;
                                    }
                                    boolean bl = success_index = code_index != -1 && symbol_index != -1;
                                    if (!success_index) {
                                        index2 = stocks;
                                        if (csvreader == null) break block38;
                                        break block39;
                                    }
                                    while ((nextLine = csvreader.readNext()) != null) {
                                        Stock.Industry industry;
                                        Stock.Board board;
                                        if (nextLine.length != types.length) {
                                            log.error((Object)("Incorrect CSV format. There should be exactly " + types.length + " item(s)"));
                                            continue;
                                        }
                                        String code = nextLine[code_index];
                                        String symbol = nextLine[symbol_index];
                                        String name = name_index == -1 ? "" : nextLine[name_index];
                                        String _board = board_index == -1 ? "Unknown" : nextLine[board_index];
                                        String _industry = industry_index == -1 ? "Unknown" : nextLine[industry_index];
                                        try {
                                            board = Stock.Board.valueOf(_board);
                                        }
                                        catch (IllegalArgumentException exp) {
                                            log.error(null, (Throwable)exp);
                                            board = Stock.Board.Unknown;
                                        }
                                        try {
                                            industry = Stock.Industry.valueOf(_industry);
                                        }
                                        catch (IllegalArgumentException exp) {
                                            log.error(null, (Throwable)exp);
                                            industry = Stock.Industry.Unknown;
                                        }
                                        Stock stock = new Stock.Builder(Code.newInstance(code), Symbol.newInstance(symbol)).name(name).board(board).industry(industry).build();
                                        stocks.add(stock);
                                    }
                                    if (csvreader == null) break block40;
                                    break block41;
                                }
                                catch (IOException ex) {
                                    log.error(null, (Throwable)ex);
                                    return stocks;
                                }
                            }
                            try {
                                csvreader.close();
                            }
                            catch (IOException ex) {
                                log.error(null, (Throwable)ex);
                            }
                        }
                        org.yccheok.jstock.gui.Utils.close(inputStreamReader);
                        org.yccheok.jstock.gui.Utils.close(fileInputStream);
                        return arrayList;
                    }
                    try {
                        csvreader.close();
                    }
                    catch (IOException ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
                org.yccheok.jstock.gui.Utils.close(inputStreamReader);
                org.yccheok.jstock.gui.Utils.close(fileInputStream);
                return index2;
            }
            try {
                csvreader.close();
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        org.yccheok.jstock.gui.Utils.close(inputStreamReader);
        org.yccheok.jstock.gui.Utils.close(fileInputStream);
        return stocks;
        finally {
            if (csvreader != null) {
                try {
                    csvreader.close();
                }
                catch (IOException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            org.yccheok.jstock.gui.Utils.close(inputStreamReader);
            org.yccheok.jstock.gui.Utils.close(fileInputStream);
        }
    }

    public static Pair<StockInfoDatabase, StockNameDatabase> toStockDatabase(List<Stock> stocks, Country country) {
        assert (!stocks.isEmpty());
        StockInfoDatabase tmp_stock_info_database = new StockInfoDatabase(stocks);
        StockNameDatabase tmp_name_database = null;
        if (Utils.isNameImmutable(country)) {
            tmp_name_database = new StockNameDatabase(stocks);
        }
        return Pair.create(tmp_stock_info_database, tmp_name_database);
    }

    public static boolean migrateXMLToCSVDatabases(String srcBaseDirectory, String destBaseDirectory) {
        boolean result = true;
        for (Country country : Country.values()) {
            File userDefinedDatabaseXMLFile = new File(srcBaseDirectory + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.xml");
            File userDefinedDatabaseCSVFile = new File(destBaseDirectory + (Object)((Object)country) + File.separator + "database" + File.separator + "user-defined-database.csv");
            List pairs = org.yccheok.jstock.gui.Utils.fromXML(List.class, userDefinedDatabaseXMLFile);
            if (pairs != null && !pairs.isEmpty()) {
                Statements statements = Statements.newInstanceFromUserDefinedDatabase(pairs);
                boolean r = statements.saveAsCSVFile(userDefinedDatabaseCSVFile);
                if (r) {
                    userDefinedDatabaseXMLFile.delete();
                }
                result = r & result;
            } else {
                userDefinedDatabaseXMLFile.delete();
            }
            new File(srcBaseDirectory + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-name-database.xml").delete();
            new File(destBaseDirectory + (Object)((Object)country) + File.separator + "database" + File.separator + "stock-info-database.xml").delete();
            new File(destBaseDirectory + (Object)((Object)country) + File.separator + "database" + File.separator + "stockcodeandsymboldatabase.xml").delete();
        }
        return result;
    }

    public static Code toGoogleFormat(Code code) {
        if (Utils.isYahooIndex(code)) {
            return Utils.toGoogleIndex(code);
        }
        String string = code.toString().trim().toUpperCase();
        int string_length = string.length();
        if (string.endsWith(".N") && string_length > ".N".length()) {
            return Code.newInstance("NSE:" + string.substring(0, string_length - ".N".length()));
        }
        if (string.endsWith(".B") && string_length > ".B".length()) {
            return Code.newInstance("BOM:" + string.substring(0, string_length - ".B".length()));
        }
        if (string.endsWith(".NS") && string_length > ".NS".length()) {
            String googleFormat = Utils.toGoogleFormatThroughAutoComplete(string = string.substring(0, string_length - ".NS".length()), "NSE");
            if (googleFormat != null) {
                return Code.newInstance("NSE:" + googleFormat);
            }
        } else {
            if (string.endsWith(".SS") && string_length > ".SS".length()) {
                string = "SHA:" + string.substring(0, string_length - ".SS".length());
                return Code.newInstance(string);
            }
            if (string.endsWith(".SZ") && string_length > ".SZ".length()) {
                string = "SHE:" + string.substring(0, string_length - ".SZ".length());
                return Code.newInstance(string);
            }
        }
        return code;
    }

    public static Code toYahooFormat(Code code) {
        String string = code.toString().trim().toUpperCase();
        int string_length = string.length();
        if (string.startsWith("SHA:") && string_length > "SHA:".length()) {
            string = string.substring("SHA:".length()) + ".SS";
            return Code.newInstance(string);
        }
        if (string.startsWith("SHE:") && string_length > "SHE:".length()) {
            string = string.substring("SHE:".length()) + ".SZ";
            return Code.newInstance(string);
        }
        if (string.startsWith("NASDAQ:") && string_length > "NASDAQ:".length()) {
            string = string.substring("NASDAQ:".length());
            return Code.newInstance(string);
        }
        if (string.startsWith("NYSE:") && string_length > "NYSE:".length()) {
            string = string.substring("NYSE:".length());
            return Code.newInstance(string);
        }
        Code newCode = Utils.toYahooIndex(code);
        return newCode;
    }

    public static boolean isYahooIndex(Code code) {
        return code.toString().startsWith("^");
    }

    private static Code toYahooIndex(Code code) {
        String string = code.toString().trim().toUpperCase();
        if (string.equals("INDEXDJX:.DJI")) {
            return Code.newInstance("^DJI");
        }
        if (string.equals("INDEXNASDAQ:.IXIC")) {
            return Code.newInstance("^IXIC");
        }
        if (string.equals("INDEXBOM:SENSEX")) {
            return Code.newInstance("^BSESN");
        }
        if (string.equals("NSE:NIFTY")) {
            return Code.newInstance("^NSEI");
        }
        if (string.equals("NSE:BANKNIFTY")) {
            return Code.newInstance("^NSEBANK");
        }
        return code;
    }

    public static Code toGoogleIndex(Code code) {
        String string = code.toString().trim().toUpperCase();
        if (string.equals("^DJI")) {
            return Code.newInstance("INDEXDJX:.DJI");
        }
        if (string.equals("^IXIC")) {
            return Code.newInstance("INDEXNASDAQ:.IXIC");
        }
        if (string.equals("^BSESN")) {
            return Code.newInstance("INDEXBOM:SENSEX");
        }
        if (string.equals("^NSEI")) {
            return Code.newInstance("NSE:NIFTY");
        }
        if (string.equals("^NSEBANK")) {
            return Code.newInstance("NSE:BANKNIFTY");
        }
        return code;
    }

    public static String toGoogleFormatThroughAutoComplete(String code, String exchange) {
        StringBuilder builder = new StringBuilder("https://www.google.com/finance/match?matchtype=matchall&q=");
        try {
            builder.append(URLEncoder.encode(code, "UTF-8"));
            String location = builder.toString();
            String _respond = org.yccheok.jstock.gui.Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
            if (_respond == null) {
                return null;
            }
            String respond = Utils.GoogleRespondToJSON(_respond);
            List jsonArray = (List)gson.fromJson(respond, List.class);
            if (jsonArray == null) {
                return null;
            }
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                Map jsonObject = (Map)jsonArray.get(i);
                if (!jsonObject.containsKey("e") || !((String)jsonObject.get("e")).equalsIgnoreCase(exchange) || !jsonObject.containsKey("t")) continue;
                return (String)jsonObject.get("t");
            }
        }
        catch (UnsupportedEncodingException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
        }
        return null;
    }

    public static Code toNonYahooFormat(Code code) {
        String tmp = code.toString();
        String TMP = tmp.toUpperCase();
        int endIndex = TMP.lastIndexOf(".KL");
        if (endIndex < 0) {
            return code;
        }
        return Code.newInstance(tmp.substring(0, endIndex));
    }

    public static boolean isPinyinTSTSearchEngineRequiredForSymbol() {
        Country country = MainFrame.getInstance().getJStockOptions().getCountry();
        return country == Country.China || country == Country.Taiwan;
    }

    public static boolean isSymbolImmutable() {
        Country country = MainFrame.getInstance().getJStockOptions().getCountry();
        return country == Country.China || country == Country.Taiwan;
    }

    public static boolean isNameImmutable() {
        Country country = MainFrame.getInstance().getJStockOptions().getCountry();
        return Utils.isNameImmutable(country);
    }

    private static boolean isNameImmutable(Country country) {
        return country == Country.China || country == Country.Taiwan;
    }

    public static boolean isFallBelowAndRiseAboveColorReverse() {
        Country country = MainFrame.getInstance().getJStockOptions().getCountry();
        return country == Country.China || country == Country.Taiwan;
    }

    public static List<Index> getStockIndices(Country country) {
        switch (country) {
            case Australia: {
                return Collections.unmodifiableList(australiaIndices);
            }
            case Austria: {
                return Collections.unmodifiableList(austriaIndices);
            }
            case Belgium: {
                return Collections.unmodifiableList(belgiumIndices);
            }
            case Brazil: {
                return Collections.unmodifiableList(brazilIndices);
            }
            case Canada: {
                return Collections.unmodifiableList(canadaIndices);
            }
            case China: {
                return Collections.unmodifiableList(chinaIndices);
            }
            case Denmark: {
                return Collections.unmodifiableList(denmarkIndices);
            }
            case France: {
                return Collections.unmodifiableList(franceIndices);
            }
            case Germany: {
                return Collections.unmodifiableList(germanyIndices);
            }
            case HongKong: {
                return Collections.unmodifiableList(hongkongIndices);
            }
            case India: {
                return Collections.unmodifiableList(indiaIndices);
            }
            case Indonesia: {
                return Collections.unmodifiableList(indonesiaIndices);
            }
            case Israel: {
                return Collections.unmodifiableList(israelIndices);
            }
            case Italy: {
                return Collections.unmodifiableList(italyIndices);
            }
            case Korea: {
                return Collections.unmodifiableList(koreaIndices);
            }
            case Malaysia: {
                return Collections.unmodifiableList(malaysiaIndices);
            }
            case Netherlands: {
                return Collections.unmodifiableList(netherlandsIndices);
            }
            case NewZealand: {
                return Collections.unmodifiableList(newZealandIndices);
            }
            case Norway: {
                return Collections.unmodifiableList(norwayIndices);
            }
            case Portugal: {
                return Collections.unmodifiableList(portugalIndices);
            }
            case Singapore: {
                return Collections.unmodifiableList(singaporeIndices);
            }
            case Spain: {
                return Collections.unmodifiableList(spainIndices);
            }
            case Sweden: {
                return Collections.unmodifiableList(swedenIndices);
            }
            case Switzerland: {
                return Collections.unmodifiableList(switzerlandIndices);
            }
            case Taiwan: {
                return Collections.unmodifiableList(taiwanIndices);
            }
            case UnitedKingdom: {
                return Collections.unmodifiableList(unitedKingdomIndices);
            }
            case UnitedState: {
                return Collections.unmodifiableList(unitedStateIndices);
            }
        }
        return Collections.emptyList();
    }

    public static String GoogleRespondToJSON(String respond) {
        int beginIndex = respond.indexOf("[");
        int endIndex = respond.lastIndexOf("]");
        if (beginIndex < 0) {
            return "";
        }
        if (beginIndex > endIndex) {
            return "";
        }
        String string = respond.substring(beginIndex, endIndex + 1);
        string = string.replaceAll("%", "%25");
        try {
            string = URLDecoder.decode(string.replace("\\x", "%"), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error(null, (Throwable)ex);
        }
        return string;
    }

    public static String YahooRespondToJSON(String respond) {
        int beginIndex = respond.indexOf("{");
        int endIndex = respond.lastIndexOf("}");
        if (beginIndex < 0) {
            return "";
        }
        if (beginIndex > endIndex) {
            return "";
        }
        return respond.substring(beginIndex, endIndex + 1);
    }

    public static double parseDouble(String value) {
        if (value == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value.replace(",", "").replace("%", ""));
        }
        catch (NumberFormatException ex) {
            log.error(null, (Throwable)ex);
            return 0.0;
        }
    }

    public static long parseLong(String value) {
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value.replace(",", "").replace("%", ""));
        }
        catch (NumberFormatException ex) {
            log.error(null, (Throwable)ex);
            return 0L;
        }
    }

    static {
        austriaIndices.add(Index.ATX);
        australiaIndices.add(Index.AORD);
        belgiumIndices.add(Index.BFX);
        brazilIndices.add(Index.BVSP);
        canadaIndices.add(Index.GSPTSE);
        chinaIndices.add(Index.SSEC);
        denmarkIndices.add(Index.OMXC20CO);
        franceIndices.add(Index.FCHI);
        germanyIndices.add(Index.DAX);
        hongkongIndices.add(Index.HSI);
        indiaIndices.add(Index.BSESN);
        indiaIndices.add(Index.NSEI);
        indonesiaIndices.add(Index.JKSE);
        israelIndices.add(Index.TA100);
        italyIndices.add(Index.FTSEMIB);
        koreaIndices.add(Index.KS11);
        malaysiaIndices.add(Index.KLSE);
        netherlandsIndices.add(Index.AEX);
        newZealandIndices.add(Index.NZSX50);
        norwayIndices.add(Index.OSEAX);
        portugalIndices.add(Index.PSI20);
        singaporeIndices.add(Index.STI);
        spainIndices.add(Index.SMSI);
        swedenIndices.add(Index.OMX30);
        switzerlandIndices.add(Index.SSMI);
        taiwanIndices.add(Index.TWII);
        unitedKingdomIndices.add(Index.FTSE);
        unitedStateIndices.add(Index.DJI);
        unitedStateIndices.add(Index.IXIC);
        gson = new Gson();
        log = LogFactory.getLog(Utils.class);
    }
}

