/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.StockHistorySerializer;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.Subject;

public class StockHistoryMonitor
extends Subject<StockHistoryMonitor, StockHistoryRunnable> {
    private List<StockServerFactory> factories = new CopyOnWriteArrayList<StockServerFactory>();
    private final List<Code> stockCodes = new ArrayList<Code>();
    private final Map<Code, StockHistoryServer> histories = new HashMap<Code, StockHistoryServer>();
    private final ReadWriteLock readWriteLock;
    private final Lock readerLock;
    private final Lock writerLock;
    private Executor pool;
    private final int DATABASE_SIZE;
    private StockHistorySerializer stockHistorySerializer;
    private volatile Duration duration = Duration.getTodayDurationByYears(10);
    private static final Log log = LogFactory.getLog(StockHistoryMonitor.class);

    public StockHistoryMonitor(int nThreads) {
        this(nThreads, 10);
    }

    public StockHistoryMonitor(int nThreads, int databaseSize) {
        this.pool = Executors.newFixedThreadPool(nThreads);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readerLock = this.readWriteLock.readLock();
        this.writerLock = this.readWriteLock.writeLock();
        this.DATABASE_SIZE = databaseSize;
        this.stockHistorySerializer = null;
    }

    public void setStockServerFactories(List<StockServerFactory> factories) {
        this.factories = factories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addStockCode(Code code) {
        this.writerLock.lock();
        try {
            if (this.stockCodes.contains(code)) {
                boolean bl = false;
                return bl;
            }
            boolean status = this.stockCodes.add(code);
            this.pool.execute(new StockHistoryRunnable(code));
            boolean bl = status;
            return bl;
        }
        finally {
            this.writerLock.unlock();
        }
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("duration cannot be null");
        }
        this.duration = duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStockCodes() {
        this.writerLock.lock();
        try {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.pool;
            int nThreads = threadPoolExecutor.getMaximumPoolSize();
            this.stockCodes.clear();
            this.histories.clear();
            threadPoolExecutor.shutdownNow();
            this.pool = Executors.newFixedThreadPool(nThreads);
        }
        finally {
            this.writerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStockCode(Code code) {
        this.writerLock.lock();
        try {
            boolean status = this.stockCodes.remove(code);
            this.histories.remove(code);
            ((ThreadPoolExecutor)this.pool).remove(new StockHistoryRunnable(code));
            boolean bl = status;
            return bl;
        }
        finally {
            this.writerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StockHistoryServer getStockHistoryServer(Code code) {
        this.readerLock.lock();
        try {
            if (this.histories.containsKey(code)) {
                StockHistoryServer stockHistoryServer;
                StockHistoryServer stockHistoryServer2 = stockHistoryServer = this.histories.get(code);
                return stockHistoryServer2;
            }
            StockHistorySerializer shs = this.stockHistorySerializer;
            if (shs != null) {
                Object object;
                StockHistoryServer stockHistoryServer = shs.load(code, this.duration);
                if (stockHistoryServer != null && this.DATABASE_SIZE > this.histories.size()) {
                    object = this.histories;
                    synchronized (object) {
                        if (stockHistoryServer != null && this.DATABASE_SIZE > this.histories.size()) {
                            this.histories.put(code, stockHistoryServer);
                        }
                    }
                }
                object = stockHistoryServer;
                return object;
            }
            log.error((Object)"Fail to retrieve stock history due to uninitialized serialization component.");
            StockHistoryServer stockHistoryServer = null;
            return stockHistoryServer;
        }
        finally {
            this.readerLock.unlock();
        }
    }

    public void setStockHistorySerializer(StockHistorySerializer stockHistorySerializer) {
        this.stockHistorySerializer = stockHistorySerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ThreadPoolExecutor threadPoolExecutor = null;
        this.writerLock.lock();
        try {
            threadPoolExecutor = (ThreadPoolExecutor)this.pool;
            int nThreads = threadPoolExecutor.getMaximumPoolSize();
            threadPoolExecutor.shutdown();
            threadPoolExecutor.purge();
            this.pool = Executors.newFixedThreadPool(nThreads);
        }
        finally {
            this.writerLock.unlock();
        }
        try {
            threadPoolExecutor.awaitTermination(100L, TimeUnit.DAYS);
        }
        catch (InterruptedException exp) {
            log.error(null, (Throwable)exp);
        }
    }

    public class StockHistoryRunnable
    implements Runnable {
        private final Code code;
        private StockHistoryServer historyServer;

        public StockHistoryRunnable(Code code) {
            this.code = code;
            this.historyServer = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            for (StockServerFactory factory : StockHistoryMonitor.this.factories) {
                if (currentThread.isInterrupted()) break;
                StockHistoryServer history = factory.getStockHistoryServer(this.code, StockHistoryMonitor.this.duration);
                if (history == null) continue;
                StockHistoryMonitor.this.readerLock.lock();
                try {
                    if (!StockHistoryMonitor.this.stockCodes.contains(this.code)) break;
                    this.historyServer = history;
                    boolean shouldUseSerializer = false;
                    if (StockHistoryMonitor.this.histories.size() < StockHistoryMonitor.this.DATABASE_SIZE) {
                        Map map = StockHistoryMonitor.this.histories;
                        synchronized (map) {
                            if (StockHistoryMonitor.this.histories.size() < StockHistoryMonitor.this.DATABASE_SIZE) {
                                StockHistoryMonitor.this.histories.put(this.code, history);
                            } else {
                                shouldUseSerializer = true;
                            }
                        }
                    } else {
                        shouldUseSerializer = true;
                    }
                    if (!shouldUseSerializer) break;
                    if (StockHistoryMonitor.this.stockHistorySerializer != null) {
                        StockHistoryMonitor.this.stockHistorySerializer.save(history, StockHistoryMonitor.this.duration);
                        break;
                    }
                    log.error((Object)"Fail to perform serialization on stock history due to uninitialized serialization component.");
                    break;
                }
                finally {
                    StockHistoryMonitor.this.readerLock.unlock();
                }
            }
            StockHistoryMonitor.this.notify(StockHistoryMonitor.this, this);
            StockHistoryMonitor.this.writerLock.lock();
            try {
                StockHistoryMonitor.this.stockCodes.remove(this.code);
            }
            finally {
                StockHistoryMonitor.this.writerLock.unlock();
            }
        }

        public int hashCode() {
            return this.code.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StockHistoryRunnable)) {
                return false;
            }
            StockHistoryRunnable stockHistoryRunnable = (StockHistoryRunnable)o;
            return this.code.equals(stockHistoryRunnable.code);
        }

        public String toString() {
            return StockHistoryRunnable.class.getName() + "[code=" + this.code + "]";
        }

        public Code getCode() {
            return this.code;
        }

        public StockHistoryServer getStockHistoryServer() {
            return this.historyServer;
        }
    }
}

