/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DividendServer;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.GoogleMarketServer;
import org.yccheok.jstock.engine.GoogleStockHistoryServer;
import org.yccheok.jstock.engine.GoogleStockServer;
import org.yccheok.jstock.engine.MarketServer;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;

public class GoogleStockServerFactory
implements StockServerFactory {
    private final StockServer stockServer;
    private final MarketServer marketServer = new GoogleMarketServer();
    private static final Log log = LogFactory.getLog(GoogleStockServerFactory.class);

    private GoogleStockServerFactory(boolean useStockServer) {
        this.stockServer = useStockServer ? new GoogleStockServer() : null;
    }

    public static StockServerFactory newInstance(boolean useStockServer) {
        return new GoogleStockServerFactory(useStockServer);
    }

    @Override
    public StockServer getStockServer() {
        return this.stockServer;
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code) {
        try {
            return new GoogleStockHistoryServer(code);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code, Duration duration) {
        try {
            return new GoogleStockHistoryServer(code, duration);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public MarketServer getMarketServer() {
        return this.marketServer;
    }

    @Override
    public DividendServer getDividendServer() {
        return null;
    }
}

