/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.Utils;

public class GoogleStockServer
implements StockServer {
    private static final int SYMBOL_MAX_LENGTH = 17;
    private final Gson gson = new Gson();
    private static final Log log = LogFactory.getLog(GoogleStockServer.class);

    @Override
    public Stock getStock(Code code) throws StockNotFoundException {
        ArrayList<Code> codes = new ArrayList<Code>();
        codes.add(code);
        List<Stock> stocks = this.getStocks(codes);
        if (stocks.size() == 1) {
            return stocks.get(0);
        }
        throw new StockNotFoundException();
    }

    private Code getOriginalCode(Map<String, Code> originalCodes, String googleTicker, String googleExchange) {
        String googleCodeStr0 = googleExchange + ":" + googleTicker;
        Code result = originalCodes.get(googleCodeStr0);
        if (result != null) {
            return result;
        }
        String googleCodeStr1 = googleTicker;
        result = originalCodes.get(googleCodeStr1);
        if (result != null) {
            return result;
        }
        if (googleExchange.equals("NSE") ? (result = originalCodes.get(googleTicker + ".N")) != null : googleExchange.equals("BOM") && (result = originalCodes.get(googleTicker + ".B")) != null) {
            return result;
        }
        Code googleCode = Code.newInstance(googleCodeStr0);
        result = originalCodes.get(Utils.toYahooFormat(googleCode).toString());
        if (result != null) {
            return result;
        }
        int googleTickerLength = googleTicker.length();
        int ns_length = ".NS".length();
        for (Map.Entry<String, Code> entry : originalCodes.entrySet()) {
            String key = entry.getKey();
            Code value = entry.getValue();
            int key_length = key.length();
            if (!key.endsWith(".NS") || key_length <= ns_length) continue;
            if (googleTickerLength >= (key = key.substring(0, key_length - ns_length)).length()) {
                if (googleTicker.equals(key)) {
                    result = value;
                    break;
                }
                if (!googleTicker.contains(key)) continue;
                result = value;
                continue;
            }
            if (!key.contains(googleTicker)) continue;
            result = value;
        }
        return result;
    }

    @Override
    public List<Stock> getStocks(List<Code> codes) throws StockNotFoundException {
        assert (!codes.isEmpty());
        HashMap<String, Code> originalCodes = new HashMap<String, Code>();
        for (Code code : codes) {
            originalCodes.put(code.toString().trim().toUpperCase(), code);
        }
        StringBuilder builder = new StringBuilder("https://www.google.com/finance/info?infotype=infoquoteall&q=");
        try {
            builder.append(URLEncoder.encode(Utils.toGoogleFormat(codes.get(0)).toString(), "UTF-8"));
            int size = codes.size();
            for (int i = 1; i < size; ++i) {
                builder.append(",");
                builder.append(URLEncoder.encode(Utils.toGoogleFormat(codes.get(i)).toString(), "UTF-8"));
            }
            String location = builder.toString();
            String _respond = org.yccheok.jstock.gui.Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
            if (_respond == null) {
                throw new StockNotFoundException();
            }
            String respond = Utils.GoogleRespondToJSON(_respond);
            List jsonArray = (List)this.gson.fromJson(respond, List.class);
            if (jsonArray == null) {
                throw new StockNotFoundException();
            }
            ArrayList<Stock> stocks = new ArrayList<Stock>();
            int size2 = jsonArray.size();
            for (int i = 0; i < size2; ++i) {
                String exchange;
                String ticker;
                String name;
                Map jsonObject = (Map)jsonArray.get(i);
                try {
                    name = (String)jsonObject.get("name");
                    name = name.substring(0, Math.min(17, name.length())).trim();
                    ticker = ((String)jsonObject.get("t")).toUpperCase();
                    exchange = ((String)jsonObject.get("e")).toUpperCase();
                }
                catch (Exception ex) {
                    log.error(null, (Throwable)ex);
                    continue;
                }
                Code code = this.getOriginalCode(originalCodes, ticker, exchange);
                if (code == null) continue;
                double c = 0.0;
                double l = 0.0;
                double p = 0.0;
                double op = 0.0;
                double hi = 0.0;
                double lo = 0.0;
                long vo = 0L;
                double cp = 0.0;
                try {
                    c = Double.parseDouble(((String)jsonObject.get("c")).replaceAll("[^0-9\\.\\-]", ""));
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
                try {
                    l = Double.parseDouble(((String)jsonObject.get("l")).replaceAll("[^0-9\\.]", ""));
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
                try {
                    p = l - c;
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
                try {
                    op = Double.parseDouble(((String)jsonObject.get("op")).replaceAll("[^0-9\\.\\-]", ""));
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
                try {
                    hi = Double.parseDouble(((String)jsonObject.get("hi")).replaceAll("[^0-9\\.]", ""));
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
                try {
                    lo = Double.parseDouble(((String)jsonObject.get("lo")).replaceAll("[^0-9\\.]", ""));
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
                try {
                    String vo_string = (String)jsonObject.get("vo");
                    vo = (long)Double.parseDouble(vo_string.replaceAll("[^0-9\\.]", ""));
                    if (vo_string.endsWith("K")) {
                        vo *= 1000L;
                    } else if (vo_string.endsWith("M")) {
                        vo *= 1000000L;
                    } else if (vo_string.endsWith("B")) {
                        vo *= 1000000000L;
                    }
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
                try {
                    cp = Double.parseDouble(((String)jsonObject.get("cp")).replaceAll("[^0-9\\.\\-]", ""));
                }
                catch (NumberFormatException ex) {
                    log.error(null, (Throwable)ex);
                }
                Stock stock = new Stock.Builder(code, Symbol.newInstance(name)).name(name).changePrice(c).lastPrice(l).prevPrice(p).openPrice(op).highPrice(hi).lowPrice(lo).volume(vo).changePricePercentage(cp).build();
                stocks.add(stock);
            }
            HashSet<Code> currCodes = new HashSet<Code>();
            ArrayList<Stock> emptyStocks = new ArrayList<Stock>();
            for (Stock stock : stocks) {
                currCodes.add(stock.code);
            }
            for (Code code : codes) {
                if (currCodes.contains(code)) continue;
                emptyStocks.add(org.yccheok.jstock.gui.Utils.getEmptyStock(code, Symbol.newInstance(code.toString())));
            }
            stocks.addAll(emptyStocks);
            if (stocks.size() != codes.size()) {
                throw new StockNotFoundException("Stock size (" + stocks.size() + ") inconsistent with code size (" + codes.size() + ")");
            }
            return stocks;
        }
        catch (UnsupportedEncodingException ex) {
            throw new StockNotFoundException(null, ex);
        }
        catch (Exception ex) {
            throw new StockNotFoundException(null, ex);
        }
    }
}

