/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.gui.Utils;

public abstract class AbstractYahooStockHistoryServer
implements StockHistoryServer {
    private static final ThreadLocal<SimpleDateFormat> simpleDateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static final int NUM_OF_RETRY = 2;
    private static final Duration DEFAULT_HISTORY_DURATION = Duration.getTodayDurationByYears(10);
    private static final String YAHOO_ICHART_BASED_URL = "http://ichart.finance.yahoo.com/table.csv?s=";
    private final Map<Long, Stock> historyDatabase = new HashMap<Long, Stock>();
    private final List<Long> timestamps = new ArrayList<Long>();
    private final Code code;
    private final Duration duration;
    private static final Log log = LogFactory.getLog(AbstractYahooStockHistoryServer.class);

    protected abstract StockServer getStockServer();

    public AbstractYahooStockHistoryServer(Code code) throws StockHistoryNotFoundException {
        this(code, DEFAULT_HISTORY_DURATION);
    }

    public AbstractYahooStockHistoryServer(Code code, Duration duration) throws StockHistoryNotFoundException {
        if (code == null || duration == null) {
            throw new IllegalArgumentException("Code or duration cannot be null");
        }
        this.code = code;
        this.duration = duration;
        try {
            this.buildHistory(this.code);
        }
        catch (OutOfMemoryError exp) {
            log.error(null, (Throwable)exp);
            throw new StockHistoryNotFoundException("Out of memory", exp);
        }
    }

    private boolean parse(String respond) {
        this.historyDatabase.clear();
        this.timestamps.clear();
        long timestamp = 0L;
        String[] stockDatas = respond.split("\r\n|\r|\n");
        int length = stockDatas.length;
        if (length <= 1) {
            return false;
        }
        Symbol symbol = Symbol.newInstance(this.code.toString());
        String name = symbol.toString();
        Stock.Board board = Stock.Board.Unknown;
        Stock.Industry industry = Stock.Industry.Unknown;
        try {
            Stock stock = this.getStockServer().getStock(this.code);
            symbol = stock.symbol;
            name = stock.getName();
            board = stock.getBoard();
            industry = stock.getIndustry();
        }
        catch (StockNotFoundException exp) {
            log.error(null, (Throwable)exp);
        }
        double previousClosePrice = Double.MAX_VALUE;
        for (int i = length - 1; i > 0; --i) {
            String[] fields = stockDatas[i].split(",");
            if (fields.length < 7) continue;
            try {
                timestamp = simpleDateFormatThreadLocal.get().parse(fields[0]).getTime();
            }
            catch (ParseException ex) {
                log.error(null, (Throwable)ex);
                continue;
            }
            double prevPrice = 0.0;
            double openPrice = 0.0;
            double highPrice = 0.0;
            double lowPrice = 0.0;
            double closePrice = 0.0;
            long volume = 0L;
            try {
                prevPrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : previousClosePrice;
                openPrice = Double.parseDouble(fields[1]);
                highPrice = Double.parseDouble(fields[2]);
                lowPrice = Double.parseDouble(fields[3]);
                closePrice = Double.parseDouble(fields[4]);
                volume = Long.parseLong(fields[5]);
            }
            catch (NumberFormatException exp) {
                log.error(null, (Throwable)exp);
            }
            double changePrice = previousClosePrice == Double.MAX_VALUE ? 0.0 : closePrice - previousClosePrice;
            double changePricePercentage = previousClosePrice == Double.MAX_VALUE || previousClosePrice == 0.0 ? 0.0 : changePrice / previousClosePrice * 100.0;
            Stock stock = new Stock(this.code, symbol, name, board, industry, prevPrice, openPrice, closePrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, timestamp);
            this.historyDatabase.put(timestamp, stock);
            this.timestamps.add(timestamp);
            previousClosePrice = closePrice;
        }
        return this.historyDatabase.size() > 0;
    }

    private void buildHistory(Code code) throws StockHistoryNotFoundException {
        String respond;
        String symbol;
        StringBuilder stringBuilder = new StringBuilder(YAHOO_ICHART_BASED_URL);
        try {
            symbol = URLEncoder.encode(code.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new StockHistoryNotFoundException("code.toString()=" + code.toString(), ex);
        }
        stringBuilder.append(symbol);
        int endMonth = this.duration.getEndDate().getMonth();
        int endDate = this.duration.getEndDate().getDate();
        int endYear = this.duration.getEndDate().getYear();
        int startMonth = this.duration.getStartDate().getMonth();
        int startDate = this.duration.getStartDate().getDate();
        int startYear = this.duration.getStartDate().getYear();
        StringBuilder formatBuilder = new StringBuilder("&d=");
        formatBuilder.append(endMonth).append("&e=").append(endDate).append("&f=").append(endYear).append("&g=d&a=").append(startMonth).append("&b=").append(startDate).append("&c=").append(startYear).append("&ignore=.csv");
        String location = stringBuilder.append((CharSequence)formatBuilder).toString();
        boolean success = false;
        for (int retry = 0; !(retry >= 2 || (respond = Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location)) != null && (success = this.parse(respond))); ++retry) {
        }
        if (!success) {
            throw new StockHistoryNotFoundException(code.toString());
        }
    }

    @Override
    public Stock getStock(long timestamp) {
        return this.historyDatabase.get(timestamp);
    }

    @Override
    public long getTimestamp(int index) {
        return this.timestamps.get(index);
    }

    @Override
    public int size() {
        return this.timestamps.size();
    }

    @Override
    public long getSharesIssued() {
        return 0L;
    }

    @Override
    public long getMarketCapital() {
        return 0L;
    }

    public Duration getDuration() {
        return this.duration;
    }
}

