/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.chat;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.yccheok.jstock.chat.Utils;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.Subject;
import org.yccheok.jstock.gui.MainFrame;

public class ChatServiceManager {
    private final SubjectEx<ChatServiceManager, State> stateSubject = this.getStateSubject();
    private final SubjectEx<ChatServiceManager, Packet> packetSubject = this.getPacketSubject();
    private static final Log log = LogFactory.getLog(ChatServiceManager.class);
    private ChatService chatService = null;

    public synchronized void start() {
        String username = MainFrame.getInstance().getJStockOptions().getChatUsername();
        String password = org.yccheok.jstock.gui.Utils.decrypt(MainFrame.getInstance().getJStockOptions().getChatPassword());
        this.stop();
        this.chatService = new ChatService(username, password);
        this.chatService.start();
    }

    public synchronized void stop() {
        if (this.chatService == null) {
            return;
        }
        this.chatService.stop();
    }

    public void sendMessage(String msg) {
        this.chatService.sendMessage(msg);
    }

    private SubjectEx<ChatServiceManager, Packet> getPacketSubject() {
        return new SubjectEx<ChatServiceManager, Packet>();
    }

    private SubjectEx<ChatServiceManager, State> getStateSubject() {
        return new SubjectEx<ChatServiceManager, State>();
    }

    private void notifyPacketObserver(Packet packet) {
        this.packetSubject.notify(this, packet);
    }

    private void notifyStateObserver(State state) {
        this.stateSubject.notify(this, state);
    }

    public void attachPacketObserver(Observer<ChatServiceManager, Packet> observer) {
        this.packetSubject.attach(observer);
    }

    public void attachStateObserver(Observer<ChatServiceManager, State> observer) {
        this.stateSubject.attach(observer);
    }

    public void dettachAllPacketObserver() {
        this.packetSubject.dettachAll();
    }

    public void dettachAllStateObserver() {
        this.stateSubject.dettachAll();
    }

    public boolean isLogin() {
        ChatService c = this.chatService;
        if (c == null) {
            return false;
        }
        return c.isLogin();
    }

    public boolean changePassword(String newPassword) {
        ChatService c = this.chatService;
        if (c == null) {
            return false;
        }
        return c.changePassword(newPassword);
    }

    private static class SubjectEx<S, A>
    extends Subject<S, A> {
        private SubjectEx() {
        }

        @Override
        protected void notify(S subject, A arg) {
            super.notify(subject, arg);
        }
    }

    private class ChatService
    implements Runnable {
        private final ConnectionListener connectionListener = this.getConnectionListener();
        private final PacketListener messageListener = this.getPacketListener();
        private final PacketListener participantListener = this.getPacketListener();
        private MultiUserChat muc = null;
        private volatile boolean runnableFlag = true;
        private String username = null;
        private final String password;
        private XMPPConnection connection = null;
        private boolean use_login_retry = false;
        private int login_retry = -1;
        private volatile CountDownLatch doneSignal = null;
        private Thread me = null;
        private final ReadWriteLock readWriteLock;
        private final Lock readerLock;
        private final Lock writerLock;

        public ChatService(String username, String password) {
            this.username = username;
            this.password = password;
            this.connection = null;
            this.readWriteLock = new ReentrantReadWriteLock();
            this.readerLock = this.readWriteLock.readLock();
            this.writerLock = this.readWriteLock.writeLock();
        }

        public void start() {
            this.runnableFlag = true;
            new Thread(this).start();
        }

        private void notifyPacketObserver(Packet packet) {
            if (this.runnableFlag) {
                ChatServiceManager.this.notifyPacketObserver(packet);
            }
        }

        private void notifyStateObserver(State state) {
            if (this.runnableFlag) {
                ChatServiceManager.this.notifyStateObserver(state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.me = Thread.currentThread();
            this.notifyStateObserver(State.CONNECTING);
            this.connection = new XMPPConnection(Utils.getXMPPServer());
            block27: while (true) {
                if (!this.runnableFlag) {
                    this.connection.disconnect();
                    this.connection.removeConnectionListener(this.connectionListener);
                    return;
                }
                try {
                    State state = State.CONNECTING;
                    this.notifyStateObserver(state);
                    boolean shouldContinue = true;
                    block28: while (true) {
                        if (!this.runnableFlag || !shouldContinue) continue block27;
                        switch (state) {
                            case CONNECTING: {
                                state = this.connecting();
                                continue block28;
                            }
                            case CONNECTED: {
                                state = this.connected();
                                continue block28;
                            }
                            case ACCOUNT_CREATING: {
                                state = this.account_creating();
                                continue block28;
                            }
                            case ACCOUNT_CREATED: {
                                state = this.account_created();
                                continue block28;
                            }
                            case ROOM_CREATING: {
                                state = this.room_creating();
                                continue block28;
                            }
                            case ROOM_CREATED: {
                                state = this.room_created();
                                continue block28;
                            }
                            case END: {
                                state = this.end();
                                shouldContinue = false;
                                continue block28;
                            }
                        }
                        break;
                    }
                    throw new IllegalArgumentException("Missing case " + (Object)((Object)state));
                }
                catch (Exception exp) {
                    log.error((Object)"Some stupid thing happens here.", (Throwable)exp);
                    continue;
                }
                finally {
                    if (this.muc == null) continue;
                    try {
                        this.writerLock.lock();
                        this.muc.leave();
                        this.muc.removeMessageListener(this.messageListener);
                        this.muc.removeParticipantListener(this.participantListener);
                        this.muc = null;
                        continue;
                    }
                    catch (Exception exp) {
                        log.error((Object)"Some stupid thing happens here.", (Throwable)exp);
                        continue;
                    }
                    finally {
                        this.writerLock.unlock();
                        continue;
                    }
                }
                break;
            }
        }

        private State connected() {
            State state = State.CONNECTED;
            this.notifyStateObserver(state);
            state = State.ROOM_CREATING;
            return state;
        }

        private ConnectionListener getConnectionListener() {
            return new ConnectionListener(){

                public void connectionClosed() {
                    if (ChatService.this.doneSignal != null) {
                        ChatService.this.doneSignal.countDown();
                    }
                }

                public void connectionClosedOnError(Exception arg0) {
                    if (ChatService.this.doneSignal != null) {
                        ChatService.this.doneSignal.countDown();
                    }
                }

                public void reconnectingIn(int arg0) {
                    if (ChatService.this.doneSignal != null) {
                        ChatService.this.doneSignal.countDown();
                    }
                }

                public void reconnectionSuccessful() {
                    if (ChatService.this.doneSignal != null) {
                        ChatService.this.doneSignal.countDown();
                    }
                }

                public void reconnectionFailed(Exception arg0) {
                    if (ChatService.this.doneSignal != null) {
                        ChatService.this.doneSignal.countDown();
                    }
                }
            };
        }

        private PacketListener getPacketListener() {
            return new PacketListener(){

                public void processPacket(Packet arg0) {
                    ChatService.this.notifyPacketObserver(arg0);
                }
            };
        }

        private State room_creating() {
            State state = State.ROOM_CREATING;
            this.notifyStateObserver(state);
            Collection serviceNames = null;
            try {
                serviceNames = MultiUserChat.getServiceNames((XMPPConnection)this.connection);
            }
            catch (XMPPException ex) {
                log.error(null, (Throwable)ex);
            }
            String serviceName = "conference." + Utils.getXMPPServer();
            if (serviceNames != null) {
                serviceName = serviceNames.toArray(new String[0])[0];
            }
            String roomName = Utils.getRoomName(MainFrame.getInstance().getJStockOptions().getCountry()) + "@" + serviceName;
            if (this.muc != null) {
                this.muc.removeMessageListener(this.messageListener);
                this.muc.removeParticipantListener(this.participantListener);
            }
            this.muc = new MultiUserChat(this.connection, roomName);
            this.muc.addMessageListener(this.messageListener);
            this.muc.addParticipantListener(this.participantListener);
            if (!this.muc.isJoined()) {
                try {
                    this.muc.join(this.username);
                }
                catch (XMPPException ex) {
                    log.error(null, (Throwable)ex);
                    XMPPError error = ex.getXMPPError();
                    if (error != null && error.getCode() == 404) {
                        try {
                            this.muc.sendConfigurationForm(null);
                            this.muc.create(this.username);
                            state = State.ROOM_CREATED;
                            return state;
                        }
                        catch (XMPPException ex1) {
                            log.error(null, (Throwable)ex1);
                        }
                    }
                    state = State.CONNECTING;
                    return state;
                }
            }
            state = State.ROOM_CREATED;
            return state;
        }

        private State end() {
            State state = State.END;
            this.notifyStateObserver(state);
            return state;
        }

        private State room_created() {
            State state = State.ROOM_CREATED;
            this.notifyStateObserver(state);
            this.doneSignal = new CountDownLatch(1);
            try {
                this.doneSignal.await();
            }
            catch (InterruptedException ex) {
                state = State.END;
            }
            state = State.END;
            return state;
        }

        private State account_created() {
            State state = State.ACCOUNT_CREATED;
            this.notifyStateObserver(state);
            state = State.CONNECTING;
            return state;
        }

        private State account_creating() {
            State state = State.ACCOUNT_CREATING;
            this.notifyStateObserver(state);
            AccountManager accountManager = this.connection.getAccountManager();
            if (accountManager == null) {
                state = State.CONNECTING;
                return state;
            }
            try {
                if (this.use_login_retry) {
                    accountManager.createAccount(this.username + this.login_retry, this.password);
                } else {
                    accountManager.createAccount(this.username, this.password);
                }
                state = State.ACCOUNT_CREATED;
            }
            catch (XMPPException ex) {
                log.error(null, (Throwable)ex);
                XMPPError error = ex.getXMPPError();
                if (error != null) {
                    if (error.getCode() == 409) {
                        this.use_login_retry = true;
                        ++this.login_retry;
                    }
                    state = State.CONNECTING;
                }
                state = State.CONNECTING;
            }
            return state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessage(String msg) {
            try {
                this.readerLock.lock();
                if (this.muc != null) {
                    this.muc.sendMessage(msg);
                }
            }
            catch (XMPPException ex) {
                log.error(null, (Throwable)ex);
            }
            finally {
                this.readerLock.unlock();
            }
        }

        private State connecting() {
            State state = State.CONNECTING;
            this.notifyStateObserver(state);
            if (this.connection.isAuthenticated() && this.connection.isConnected()) {
                state = State.CONNECTED;
                return state;
            }
            try {
                this.connection.connect();
                SASLAuthentication.supportSASLMechanism((String)"PLAIN", (int)0);
                if (this.use_login_retry) {
                    this.connection.login(this.username + this.login_retry, this.password);
                } else {
                    this.connection.login(this.username, this.password);
                }
                if (this.connection.isAuthenticated() && this.connection.isConnected()) {
                    if (this.use_login_retry) {
                        this.use_login_retry = !this.use_login_retry;
                        this.username = this.username + this.login_retry;
                        this.login_retry = -1;
                        MainFrame.getInstance().getJStockOptions().setChatUsername(this.username);
                    }
                    this.connection.removeConnectionListener(this.connectionListener);
                    this.connection.addConnectionListener(this.connectionListener);
                    state = State.CONNECTED;
                }
            }
            catch (XMPPException ex) {
                log.error(null, (Throwable)ex);
                XMPPError error = ex.getXMPPError();
                if (error != null) {
                    if (error.getCode() == 504) {
                        state = State.CONNECTING;
                    }
                }
                state = State.ACCOUNT_CREATING;
            }
            return state;
        }

        public void stop() {
            this.runnableFlag = false;
            if (this.me != null) {
                this.me.interrupt();
            }
            if (this.doneSignal != null) {
                this.doneSignal.countDown();
            }
        }

        public boolean changePassword(String newPassword) {
            XMPPConnection c = this.connection;
            if (c == null) {
                return false;
            }
            try {
                if (!c.isAuthenticated() || !c.isConnected()) {
                    return false;
                }
                AccountManager accountManager = c.getAccountManager();
                if (accountManager == null) {
                    return false;
                }
                accountManager.changePassword(newPassword);
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
                return false;
            }
            return true;
        }

        public boolean isLogin() {
            XMPPConnection c = this.connection;
            if (c == null) {
                return false;
            }
            return c.isAuthenticated() && c.isConnected();
        }
    }

    public static enum State {
        CONNECTING,
        CONNECTED,
        ACCOUNT_CREATING,
        ACCOUNT_CREATED,
        ROOM_CREATING,
        ROOM_CREATED,
        END;

    }
}

