/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.alert;

import java.util.concurrent.atomic.AtomicInteger;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;

public enum SMSLimiter {
    INSTANCE;

    private long epoch = System.currentTimeMillis() / 1000L;
    private AtomicInteger atomic = new AtomicInteger();

    public boolean isSMSAllowed() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        int max = jStockOptions.getMaxSMSPerDay();
        if (max <= 0) {
            return true;
        }
        long current = System.currentTimeMillis() / 1000L;
        long secondsInADay = 86400L;
        if (this.epoch / 86400L != current / 86400L) {
            this.epoch = current;
            this.atomic.lazySet(0);
        }
        return this.atomic.get() < max;
    }

    public void inc() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        int max = jStockOptions.getMaxSMSPerDay();
        if (max <= 0) {
            return;
        }
        this.atomic.incrementAndGet();
    }
}

