/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMStorable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaxDOMInput
implements DOMInput {
    private HashMap<String, Object> idobjects = new HashMap();
    private Document document;
    private Node current;
    private DOMFactory factory;
    protected static DocumentBuilder documentBuilder;

    protected static DocumentBuilder getBuilder() throws IOException {
        if (documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setXIncludeAware(false);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                documentBuilder = factory.newDocumentBuilder();
            }
            catch (Exception ex) {
                InternalError error = new InternalError("Unable to create DocumentBuilder");
                error.initCause(ex);
                throw error;
            }
        }
        return documentBuilder;
    }

    public JavaxDOMInput(DOMFactory factory, InputStream in) throws IOException {
        this.factory = factory;
        try {
            this.document = JavaxDOMInput.getBuilder().parse(in);
            this.current = this.document;
        }
        catch (SAXException ex) {
            IOException e = new IOException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    public JavaxDOMInput(DOMFactory factory, Reader in) throws IOException {
        this.factory = factory;
        try {
            this.document = JavaxDOMInput.getBuilder().parse(new InputSource(in));
            this.current = this.document;
        }
        catch (SAXException ex) {
            IOException e = new IOException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    @Override
    public String getTagName() {
        return ((Element)this.current).getTagName();
    }

    @Override
    public String getAttribute(String name, String defaultValue) {
        String value = ((Element)this.current).getAttribute(name);
        return value.length() == 0 ? defaultValue : value;
    }

    @Override
    public String getText() {
        return this.getText(null);
    }

    @Override
    public String getText(String defaultValue) {
        if (this.current.getChildNodes().getLength() == 0) {
            return defaultValue;
        }
        StringBuilder buf = new StringBuilder();
        JavaxDOMInput.getText(this.current, buf);
        return buf.toString();
    }

    private static void getText(Node n, StringBuilder buf) {
        if (n.getNodeValue() != null) {
            buf.append(n.getNodeValue());
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            JavaxDOMInput.getText(children.item(i), buf);
        }
    }

    @Override
    public List<String> getInheritedAttribute(String name) {
        LinkedList<String> values = new LinkedList<String>();
        for (Node node = this.current; node != null; node = node.getParentNode()) {
            String value = ((Element)node).getAttribute(name);
            values.addFirst(value);
        }
        return values;
    }

    @Override
    public int getAttribute(String name, int defaultValue) {
        String value = ((Element)this.current).getAttribute(name);
        return value.length() == 0 ? defaultValue : Long.decode(value).intValue();
    }

    @Override
    public double getAttribute(String name, double defaultValue) {
        String value = ((Element)this.current).getAttribute(name);
        return value.length() == 0 ? defaultValue : Double.parseDouble(value);
    }

    @Override
    public boolean getAttribute(String name, boolean defaultValue) {
        String value = ((Element)this.current).getAttribute(name);
        return value.length() == 0 ? defaultValue : Boolean.valueOf(value);
    }

    @Override
    public int getElementCount() {
        int count = 0;
        NodeList list = this.current.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getElementCount(String tagName) {
        int count = 0;
        NodeList list = this.current.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals(tagName)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void openElement(int index) {
        int count = 0;
        NodeList list = this.current.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || count++ != index) continue;
            this.current = node;
            return;
        }
    }

    @Override
    public void openElement(String tagName) {
        boolean count = false;
        NodeList list = this.current.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals(tagName)) continue;
            this.current = node;
            return;
        }
        throw new IllegalArgumentException("element not found:" + tagName);
    }

    @Override
    public void openElement(String tagName, int index) {
        int count = 0;
        NodeList list = this.current.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals(tagName) || count++ != index) continue;
            this.current = node;
            return;
        }
        throw new IllegalArgumentException("no such child " + tagName + "[" + index + "]");
    }

    @Override
    public void closeElement() {
        this.current = this.current.getParentNode();
    }

    @Override
    public Object readObject() throws IOException {
        return this.readObject(0);
    }

    @Override
    public Object readObject(int index) throws IOException {
        Object o;
        this.openElement(index);
        String tagName = this.getTagName();
        if (tagName.equals("null")) {
            o = null;
        } else if (tagName.equals("string")) {
            o = this.getText();
        } else if (tagName.equals("int")) {
            o = Integer.decode(this.getText());
        } else if (tagName.equals("long")) {
            o = Long.decode(this.getText());
        } else if (tagName.equals("float")) {
            o = new Float(Float.parseFloat(this.getText()));
        } else if (tagName.equals("double")) {
            o = new Double(Double.parseDouble(this.getText()));
        } else if (tagName.equals("boolean")) {
            o = Boolean.valueOf(this.getText());
        } else if (tagName.equals("color")) {
            o = new Color(this.getAttribute("rgba", 255));
        } else if (tagName.equals("intArray")) {
            int[] a = new int[this.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = (Integer)this.readObject(i);
            }
            o = a;
        } else if (tagName.equals("floatArray")) {
            float[] a = new float[this.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = ((Float)this.readObject(i)).floatValue();
            }
            o = a;
        } else if (tagName.equals("doubleArray")) {
            double[] a = new double[this.getElementCount()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = (Double)this.readObject(i);
            }
            o = a;
        } else if (tagName.equals("font")) {
            o = new Font(this.getAttribute("name", "Dialog"), this.getAttribute("style", 0), this.getAttribute("size", 0));
        } else if (tagName.equals("enum")) {
            o = this.factory.createEnum(this.getAttribute("type", null), this.getText());
        } else {
            String ref = this.getAttribute("ref", null);
            String id = this.getAttribute("id", ref);
            if (id == null) {
                o = this.factory.create(this.getTagName());
            } else if (this.idobjects.containsKey(id)) {
                o = this.idobjects.get(id);
            } else {
                o = this.factory.create(this.getTagName());
                this.idobjects.put(id, o);
            }
            if (ref == null && o instanceof DOMStorable) {
                ((DOMStorable)o).read(this);
            }
        }
        this.closeElement();
        return o;
    }
}

