/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;

public class DrawingComponentRepainter
extends FigureAdapter
implements PropertyChangeListener {
    private DrawingEditor editor;
    private JComponent component;

    public DrawingComponentRepainter(DrawingEditor editor, JComponent component) {
        this.editor = editor;
        this.component = component;
        if (editor != null) {
            if (editor.getActiveView() != null) {
                DrawingView view = editor.getActiveView();
                view.addPropertyChangeListener(this);
                if (view.getDrawing() != null) {
                    view.getDrawing().addFigureListener(this);
                }
            }
            editor.addPropertyChangeListener(this);
        }
    }

    @Override
    public void attributeChanged(FigureEvent evt) {
        this.component.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name == "activeView") {
            DrawingView view = (DrawingView)evt.getOldValue();
            if (view != null) {
                view.removePropertyChangeListener(this);
                if (view.getDrawing() != null) {
                    view.getDrawing().removeFigureListener(this);
                }
            }
            if ((view = (DrawingView)evt.getNewValue()) != null) {
                view.addPropertyChangeListener(this);
                if (view.getDrawing() != null) {
                    view.getDrawing().addFigureListener(this);
                }
            }
            this.component.repaint();
        } else if (name == "drawing") {
            Drawing drawing = (Drawing)evt.getOldValue();
            if (drawing != null) {
                drawing.removeFigureListener(this);
            }
            if ((drawing = (Drawing)evt.getNewValue()) != null) {
                drawing.addFigureListener(this);
            }
            this.component.repaint();
        } else {
            this.component.repaint();
        }
    }

    public void dispose() {
        if (this.editor != null) {
            if (this.editor.getActiveView() != null) {
                DrawingView view = this.editor.getActiveView();
                view.removePropertyChangeListener(this);
                if (view.getDrawing() != null) {
                    view.getDrawing().removeFigureListener(this);
                }
            }
            this.editor.removePropertyChangeListener(this);
            this.editor = null;
        }
        this.component = null;
    }
}

