/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.BoundedRangeModel;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.ImageInputFormat;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.io.BoundedRangeInputStream;
import org.jhotdraw.samples.svg.SVGDrawingPanel;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.gui.MessagePanel;
import org.jhotdraw.samples.svg.gui.ProgressIndicator;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;
import org.jhotdraw.samples.svg.io.SVGZOutputFormat;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGApplet
extends JApplet {
    private SVGDrawingPanel drawingComponent;
    private String version;
    private long start;

    public SVGApplet() {
        this.setBackground(Color.WHITE);
        this.start = System.currentTimeMillis();
        this.setName("JHotDraw SVG Applet");
        ((JComponent)this.getContentPane()).setBorder(new MatteBorder(new Insets(1, 1, 1, 1), new Color(0xA5A5A5)));
    }

    @Override
    public String getParameter(String name) {
        try {
            return super.getParameter(name);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public String getParameter(String name, String defaultValue) {
        try {
            String value = super.getParameter(name);
            return value == null ? defaultValue : value;
        }
        catch (NullPointerException e) {
            return defaultValue;
        }
    }

    @Override
    public final void init() {
        if (this.getParameter("Locale") != null) {
            Locale.setDefault(new Locale(this.getParameter("Locale")));
        }
        final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        Container c = this.getContentPane();
        final ProgressIndicator progress = new ProgressIndicator(this.getName(), labels.getString("progressInitializing"));
        c.add(progress);
        progress.revalidate();
        new Worker(){

            @Override
            public Object construct() {
                try {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            SVGApplet.this.drawingComponent = SVGApplet.this.createDrawingComponent();
                        }
                    };
                    t.start();
                    progress.setNote(labels.getString("progressLoading"));
                    Drawing drawing = SVGApplet.this.loadDrawing(progress);
                    progress.setNote(labels.getString("progressOpeningEditor"));
                    progress.setIndeterminate(true);
                    t.join();
                    return drawing;
                }
                catch (Throwable t) {
                    return t;
                }
            }

            @Override
            public void finished(Object result) {
                Container c = SVGApplet.this.getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                if (result instanceof Throwable) {
                    Throwable error = (Throwable)result;
                    error.printStackTrace();
                    String message = error.getMessage() == null ? error.toString() : error.getMessage();
                    MessagePanel mp = new MessagePanel(UIManager.getIcon("OptionPane.errorIcon"), labels.getFormatted("messageLoadFailed", SVGApplet.htmlencode(SVGApplet.this.getParameter("DrawingURL")), SVGApplet.htmlencode(message)));
                    c.add(mp);
                    mp.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            if (evt.getActionCommand().equals("close")) {
                                SVGApplet.this.close();
                            }
                        }
                    });
                } else {
                    c.add(SVGApplet.this.drawingComponent.getComponent());
                    SVGApplet.this.initComponents();
                    if (result != null) {
                        if (result instanceof Drawing) {
                            SVGApplet.this.setDrawing((Drawing)result);
                        } else if (result instanceof Throwable) {
                            SVGApplet.this.setDrawing(SVGApplet.this.createDrawing());
                            SVGApplet.this.getDrawing().add(new SVGTextFigure(result.toString()));
                            ((Throwable)result).printStackTrace();
                        }
                    }
                }
                c.validate();
                long end = System.currentTimeMillis();
                System.out.println("AbstractDrawingApplet startup latency:" + (end - SVGApplet.this.start));
            }
        }.start();
    }

    private void setDrawing(Drawing d) {
        this.drawingComponent.setDrawing(d);
    }

    private Drawing getDrawing() {
        return this.drawingComponent.getDrawing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        if (this.version == null) {
            BufferedReader r = null;
            try {
                InputStream resource = SVGApplet.class.getResourceAsStream("version.txt");
                r = new BufferedReader(new InputStreamReader(resource, "UTF-8"));
                this.version = r.readLine();
            }
            catch (IOException e) {
                this.version = "unknown";
            }
            catch (NullPointerException e) {
                this.version = "unknown";
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return this.version;
    }

    @Override
    public String getAppletInfo() {
        return this.getName() + "\nVersion " + this.getVersion() + "\n\nCopyright 1996-2009 (c) by the original authors of JHotDraw and all its contributors" + "\nThis software is licensed under LGPL or" + "\nCreative Commons 2.5 BY";
    }

    protected Drawing createDrawing() {
        DefaultDrawing drawing = new DefaultDrawing();
        LinkedList<InputFormat> inputFormats = new LinkedList<InputFormat>();
        inputFormats.add(new SVGZInputFormat());
        inputFormats.add(new ImageInputFormat(new SVGImageFigure()));
        LinkedList<OutputFormat> outputFormats = new LinkedList<OutputFormat>();
        outputFormats.add(new SVGOutputFormat());
        outputFormats.add(new SVGZOutputFormat());
        outputFormats.add(new ImageOutputFormat());
        outputFormats.add(new ImageOutputFormat("JPG", "Joint Photographics Experts Group (JPEG)", "jpg", 1));
        outputFormats.add(new ImageOutputFormat("BMP", "Windows Bitmap (BMP)", "bmp", 13));
        drawing.setInputFormats(inputFormats);
        drawing.setOutputFormats(outputFormats);
        return drawing;
    }

    protected SVGDrawingPanel createDrawingComponent() {
        return new SVGDrawingPanel();
    }

    protected SVGDrawingPanel getDrawingComponent() {
        return this.drawingComponent;
    }

    @Override
    public String[][] getParameterInfo() {
        return new String[][]{{"data", "String", "the data to be displayed by this applet."}, {"datafile", "URL", "an URL to a file containing the data to be displayed by this applet."}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Drawing loadDrawing(ProgressIndicator progress) throws IOException {
        Drawing drawing;
        block12: {
            drawing = this.createDrawing();
            InputStream in = null;
            try {
                if (this.getParameter("datafile") == null) break block12;
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                URL url = new URL(this.getDocumentBase(), this.getParameter("datafile"));
                URLConnection uc = url.openConnection();
                if (uc instanceof HttpURLConnection) {
                    ((HttpURLConnection)uc).setUseCaches(false);
                }
                int contentLength = uc.getContentLength();
                in = uc.getInputStream();
                if (contentLength != -1) {
                    in = new BoundedRangeInputStream(in);
                    ((BoundedRangeInputStream)in).setMaximum(contentLength + 1);
                    progress.setProgressModel((BoundedRangeModel)((Object)in));
                    progress.setIndeterminate(false);
                }
                BufferedInputStream bin = new BufferedInputStream(in);
                bin.mark(512);
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                IOException formatException = null;
                for (InputFormat format : drawing.getInputFormats()) {
                    try {
                        bin.reset();
                    }
                    catch (IOException e) {
                        uc = url.openConnection();
                        in = uc.getInputStream();
                        in = new BoundedRangeInputStream(in);
                        ((BoundedRangeInputStream)in).setMaximum(contentLength + 1);
                        progress.setProgressModel((BoundedRangeModel)((Object)in));
                        bin = new BufferedInputStream(in);
                        bin.mark(512);
                    }
                    try {
                        bin.reset();
                        format.read(bin, drawing, true);
                        formatException = null;
                        break;
                    }
                    catch (IOException e) {
                        formatException = e;
                    }
                }
                if (formatException != null) {
                    throw formatException;
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return drawing;
    }

    protected void close() {
        AppletContext appletContext;
        try {
            appletContext = this.getAppletContext();
        }
        catch (Throwable e) {
            appletContext = null;
        }
        if (appletContext == null) {
            System.exit(0);
        } else {
            try {
                appletContext.showDocument(new URL(this.getDocumentBase(), this.getParameter("PageURL")));
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static String htmlencode(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        block5: for (char ch : str.toCharArray()) {
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block5;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("JHotDraw SVG Sample Applet");
                f.setDefaultCloseOperation(3);
                SVGApplet a = new SVGApplet();
                f.getContentPane().add(a);
                a.init();
                f.setSize(500, 300);
                f.setVisible(true);
                a.start();
            }
        });
    }

    private void initComponents() {
    }
}

