/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.geom.Geom;

public class StraightLineFigure
extends AbstractAttributedFigure {
    private Line2D.Double line = new Line2D.Double();

    @Override
    protected void drawFill(Graphics2D g) {
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        g.draw(this.line);
    }

    @Override
    public void transform(AffineTransform ty) {
        Point2D.Double p1 = (Point2D.Double)this.line.getP1();
        Point2D.Double p2 = (Point2D.Double)this.line.getP2();
        this.line.setLine(ty.transform(p1, p1), ty.transform(p2, p2));
    }

    @Override
    public void setBounds(Point2D.Double start, Point2D.Double end) {
        this.line.setLine(start, end);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.line.getBounds2D();
    }

    @Override
    public Object getTransformRestoreData() {
        return this.line.clone();
    }

    @Override
    public void restoreTransformTo(Object restoreData) {
        this.line = (Line2D.Double)((Line2D.Double)restoreData).clone();
    }

    @Override
    public boolean contains(Point2D.Double p) {
        return Geom.lineContainsPoint(this.line.x1, this.line.y1, this.line.x2, this.line.y2, p.x, p.y, AttributeKeys.getStrokeTotalWidth(this));
    }

    @Override
    public StraightLineFigure clone() {
        StraightLineFigure that = (StraightLineFigure)super.clone();
        that.line = (Line2D.Double)this.line.clone();
        return that;
    }
}

