/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.fontchooser;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jhotdraw.gui.fontchooser.FontFamilyNode;

public class FontCollectionNode
implements MutableTreeNode,
Comparable<FontCollectionNode>,
Cloneable {
    private MutableTreeNode parent;
    private String name;
    private ArrayList<FontFamilyNode> children;
    private boolean isEditable;

    public FontCollectionNode(String name) {
        this.name = name;
        this.children = new ArrayList();
    }

    public FontCollectionNode(String name, ArrayList<FontFamilyNode> families) {
        this.name = name;
        this.children = families;
    }

    @Override
    public int compareTo(FontCollectionNode that) {
        return Collator.getInstance().compare(this.name, that.name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public FontCollectionNode clone() {
        FontCollectionNode that;
        try {
            that = (FontCollectionNode)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError("Clone failed");
            error.initCause(ex);
            throw error;
        }
        that.parent = null;
        that.children = new ArrayList();
        for (FontFamilyNode f : this.children) {
            that.insert(f.clone(), that.getChildCount());
        }
        return that;
    }

    public void add(FontFamilyNode newChild) {
        this.insert(newChild, this.getChildCount());
    }

    public void addAll(Collection<FontFamilyNode> c) {
        this.children.addAll(c);
    }

    @Override
    public void insert(MutableTreeNode newChild, int index) {
        FontCollectionNode oldParent = (FontCollectionNode)newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        this.children.add(index, (FontFamilyNode)newChild);
    }

    @Override
    public void remove(int childIndex) {
        FontFamilyNode child = this.getChildAt(childIndex);
        this.children.remove(childIndex);
        child.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(aChild));
    }

    @Override
    public void setUserObject(Object object) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this.parent = newParent;
    }

    @Override
    public FontFamilyNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public MutableTreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public List<FontFamilyNode> families() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isNodeChild(TreeNode aNode) {
        boolean retval = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retval;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean newValue) {
        this.isEditable = newValue;
    }
}

