/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class BezierControlPointHandle
extends AbstractHandle {
    protected int index;
    protected int controlPointIndex;
    private CompositeEdit edit;
    private Figure transformOwner;
    private BezierPath.Node oldNode;

    public BezierControlPointHandle(BezierFigure owner, int index, int coord) {
        this(owner, index, coord, owner);
    }

    public BezierControlPointHandle(BezierFigure owner, int index, int coord, Figure transformOwner) {
        super(owner);
        this.index = index;
        this.controlPointIndex = coord;
        this.transformOwner = transformOwner;
        transformOwner.addFigureListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.transformOwner.removeFigureListener(this);
        this.transformOwner = null;
    }

    protected BezierFigure getBezierFigure() {
        return this.getOwner();
    }

    protected Figure getTransformOwner() {
        return this.transformOwner;
    }

    protected Point getLocation() {
        if (this.getBezierFigure().getNodeCount() > this.index) {
            Point2D.Double p = this.getBezierFigure().getPoint(this.index, this.controlPointIndex);
            if (SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner()) != null) {
                ((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner())).transform(p, p);
            }
            return this.view.drawingToView(p);
        }
        return new Point(10, 10);
    }

    protected BezierPath.Node getBezierNode() {
        return this.getBezierFigure().getNodeCount() > this.index ? this.getBezierFigure().getNode(this.index) : null;
    }

    @Override
    public void draw(Graphics2D g) {
        BezierFigure f = this.getBezierFigure();
        if (f.getNodeCount() > this.index) {
            Color strokeColor2;
            Stroke stroke2;
            Color strokeColor1;
            Stroke stroke1;
            Color handleStrokeColor;
            Color handleFillColor;
            BezierPath.Node v = f.getNode(this.index);
            Point2D.Double p0 = new Point2D.Double(v.x[0], v.y[0]);
            Point2D.Double pc = new Point2D.Double(v.x[this.controlPointIndex], v.y[this.controlPointIndex]);
            if (SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner()) != null) {
                ((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner())).transform(p0, p0);
                ((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner())).transform(pc, pc);
            }
            if (this.getEditor().getTool().supportsHandleInteraction()) {
                handleFillColor = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_CONTROL_POINT_HANDLE_FILL_COLOR);
                handleStrokeColor = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_CONTROL_POINT_HANDLE_STROKE_COLOR);
                stroke1 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_STROKE_1);
                strokeColor1 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_COLOR_1);
                stroke2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_STROKE_2);
                strokeColor2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_COLOR_2);
            } else {
                handleFillColor = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_CONTROL_POINT_HANDLE_FILL_COLOR_DISABLED);
                handleStrokeColor = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_CONTROL_POINT_HANDLE_STROKE_COLOR_DISABLED);
                stroke1 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_STROKE_1_DISABLED);
                strokeColor1 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_COLOR_1_DISABLED);
                stroke2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_STROKE_2_DISABLED);
                strokeColor2 = this.getEditor().getHandleAttribute(HandleAttributeKeys.BEZIER_TANGENT_COLOR_2_DISABLED);
            }
            if (stroke1 != null && strokeColor1 != null) {
                g.setStroke(stroke1);
                g.setColor(strokeColor1);
                g.draw(new Line2D.Double(this.view.drawingToView(p0), this.view.drawingToView(pc)));
            }
            if (stroke2 != null && strokeColor2 != null) {
                g.setStroke(stroke2);
                g.setColor(strokeColor2);
                g.draw(new Line2D.Double(this.view.drawingToView(p0), this.view.drawingToView(pc)));
            }
            if (v.keepColinear && v.mask == 3 && (this.index > 0 && this.index < f.getNodeCount() - 1 || f.isClosed())) {
                this.drawCircle(g, handleStrokeColor, handleFillColor);
            } else {
                this.drawCircle(g, handleFillColor, handleStrokeColor);
            }
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.getLocation());
        int h = this.getHandlesize();
        r.x -= h / 2;
        r.y -= h / 2;
        r.width = r.height = h;
        return r;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        BezierFigure figure = this.getOwner();
        this.edit = new CompositeEdit("Punkt verschieben");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        Point2D.Double location = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(this.getLocation()));
        Point2D.Double p = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(anchor));
        this.oldNode = figure.getNode(this.index);
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        BezierFigure figure = this.getBezierFigure();
        Point2D.Double p = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(lead));
        BezierPath.Node v = figure.getNode(this.index);
        this.fireAreaInvalidated(v);
        figure.willChange();
        if (SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner()) != null) {
            try {
                ((AffineTransform)SVGAttributeKeys.TRANSFORM.get(this.getTransformOwner())).inverseTransform(p, p);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        if (!v.keepColinear) {
            figure.setPoint(this.index, this.controlPointIndex, p);
        } else {
            double a = Math.PI + Math.atan2(p.y - v.y[0], p.x - v.x[0]);
            int c2 = this.controlPointIndex == 1 ? 2 : 1;
            double r = Math.sqrt((v.x[c2] - v.x[0]) * (v.x[c2] - v.x[0]) + (v.y[c2] - v.y[0]) * (v.y[c2] - v.y[0]));
            double sina = Math.sin(a);
            double cosa = Math.cos(a);
            Point2D.Double p2 = new Point2D.Double(r * cosa + v.x[0], r * sina + v.y[0]);
            figure.setPoint(this.index, this.controlPointIndex, p);
            figure.setPoint(this.index, c2, p2);
        }
        figure.changed();
        this.fireAreaInvalidated(figure.getNode(this.index));
    }

    private void fireAreaInvalidated(BezierPath.Node v) {
        Rectangle2D.Double dr = new Rectangle2D.Double(v.x[0], v.y[0], 0.0, 0.0);
        for (int i = 1; i < 3; ++i) {
            dr.add(v.x[i], v.y[i]);
        }
        Rectangle vr = this.view.drawingToView(dr);
        vr.grow(this.getHandlesize(), this.getHandlesize());
        this.fireAreaInvalidated(vr);
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        BezierFigure figure = this.getBezierFigure();
        BezierPath.Node oldValue = (BezierPath.Node)this.oldNode.clone();
        BezierPath.Node newValue = figure.getNode(this.index);
        if ((modifiersEx & 0x3C0) != 0) {
            figure.willChange();
            boolean bl = newValue.keepColinear = !newValue.keepColinear;
            if (newValue.keepColinear) {
                Point2D.Double p = figure.getPoint(this.index, this.controlPointIndex);
                double a = Math.PI + Math.atan2(p.y - newValue.y[0], p.x - newValue.x[0]);
                int c2 = this.controlPointIndex == 1 ? 2 : 1;
                double r = Math.sqrt((newValue.x[c2] - newValue.x[0]) * (newValue.x[c2] - newValue.x[0]) + (newValue.y[c2] - newValue.y[0]) * (newValue.y[c2] - newValue.y[0]));
                double sina = Math.sin(a);
                double cosa = Math.cos(a);
                Point2D.Double p2 = new Point2D.Double(r * cosa + newValue.x[0], r * sina + newValue.y[0]);
                newValue.x[c2] = p2.x;
                newValue.y[c2] = p2.y;
            }
            figure.setNode(this.index, newValue);
            figure.changed();
        }
        this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(figure, this.index, oldValue, newValue){

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                BezierControlPointHandle.this.fireHandleRequestSecondaryHandles();
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                BezierControlPointHandle.this.fireHandleRequestSecondaryHandles();
            }
        });
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }

    @Override
    public boolean isCombinableWith(Handle h) {
        if (super.isCombinableWith(h)) {
            BezierControlPointHandle that = (BezierControlPointHandle)h;
            return that.index == this.index && that.controlPointIndex == this.controlPointIndex && that.getBezierFigure().getNodeCount() == this.getBezierFigure().getNodeCount();
        }
        return false;
    }

    @Override
    public String getToolTipText(Point p) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        BezierPath.Node node = this.getBezierNode();
        if (node == null) {
            return null;
        }
        if (node.mask == 3) {
            return labels.getFormatted("handle.bezierControlPoint.toolTipText", labels.getFormatted(node.keepColinear ? "handle.bezierControlPoint.cubicColinear.value" : "handle.bezierControlPoint.cubicUnconstrained.value", new Object[0]));
        }
        return labels.getString("handle.bezierControlPoint.quadratic.toolTipText");
    }

    @Override
    public BezierFigure getOwner() {
        return (BezierFigure)super.getOwner();
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        BezierFigure f = this.getOwner();
        BezierPath.Node oldNode = f.getNode(this.index);
        switch (evt.getKeyCode()) {
            case 38: {
                f.willChange();
                f.setPoint(this.index, this.controlPointIndex, new Point2D.Double(oldNode.x[this.controlPointIndex], oldNode.y[this.controlPointIndex] - 1.0));
                f.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, oldNode, f.getNode(this.index)));
                evt.consume();
                break;
            }
            case 40: {
                f.willChange();
                f.setPoint(this.index, this.controlPointIndex, new Point2D.Double(oldNode.x[this.controlPointIndex], oldNode.y[this.controlPointIndex] + 1.0));
                f.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, oldNode, f.getNode(this.index)));
                evt.consume();
                break;
            }
            case 37: {
                f.willChange();
                f.setPoint(this.index, this.controlPointIndex, new Point2D.Double(oldNode.x[this.controlPointIndex] - 1.0, oldNode.y[this.controlPointIndex]));
                f.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, oldNode, f.getNode(this.index)));
                evt.consume();
                break;
            }
            case 39: {
                f.willChange();
                f.setPoint(this.index, this.controlPointIndex, new Point2D.Double(oldNode.x[this.controlPointIndex] + 1.0, oldNode.y[this.controlPointIndex]));
                f.changed();
                this.view.getDrawing().fireUndoableEditHappened(new BezierNodeEdit(f, this.index, oldNode, f.getNode(this.index)));
                evt.consume();
                break;
            }
            case 8: 
            case 127: {
                evt.consume();
            }
        }
    }
}

