/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import org.jhotdraw.color.AbstractColorSystem;

public class RGBColorSystem
extends AbstractColorSystem {
    @Override
    public float[] toComponents(int r, int g, int b, float[] components) {
        if (components == null || components.length != 3) {
            components = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        }
        return components;
    }

    @Override
    public int toRGB(float ... components) {
        return 0xFF000000 | (int)(components[0] * 255.0f) << 16 | (int)(components[1] * 255.0f) << 8 | (int)(components[2] * 255.0f);
    }

    @Override
    public int getComponentCount() {
        return 3;
    }
}

