/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import org.jhotdraw.color.ColorSliderModel;
import org.jhotdraw.color.ColorSystem;
import org.jhotdraw.color.CompositeColor;
import org.jhotdraw.color.DefaultColorSliderModel;
import org.jhotdraw.color.HSLRYBColorSystem;
import org.jhotdraw.color.HarmonicColorModel;
import org.jhotdraw.color.HarmonicRule;

public class DefaultHarmonicColorModel
extends AbstractListModel
implements HarmonicColorModel {
    protected PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private ArrayList<CompositeColor> colors;
    private ColorSliderModel sliderModel;
    private int base;
    private ArrayList<HarmonicRule> rules;
    private float customHueConstraint = 0.083333336f;
    private int adjusting;

    public DefaultHarmonicColorModel() {
        HSLRYBColorSystem sys = new HSLRYBColorSystem();
        this.sliderModel = new DefaultColorSliderModel(sys);
        this.colors = new ArrayList();
        this.rules = new ArrayList();
        this.base = 0;
        this.add(new CompositeColor((ColorSystem)sys, Color.RED));
    }

    @Override
    public void setSize(int newValue) {
        int oldSize = this.size();
        while (this.colors.size() > newValue) {
            this.colors.remove(this.colors.size() - 1);
        }
        ColorSystem sys = this.sliderModel.getColorSystem();
        while (this.colors.size() < newValue) {
            this.colors.add(null);
        }
        if (oldSize < newValue) {
            this.fireIntervalRemoved(this, oldSize, newValue - 1);
        } else if (oldSize > newValue) {
            this.fireIntervalRemoved(this, newValue, oldSize - 1);
        }
    }

    @Override
    public int size() {
        return this.colors.size();
    }

    @Override
    public boolean isAdjusting() {
        return this.adjusting > 0;
    }

    @Override
    public void set(int index, CompositeColor newValue) {
        ++this.adjusting;
        CompositeColor oldValue = this.colors.set(index, newValue);
        for (HarmonicRule r : this.rules) {
            r.colorChanged(this, index, oldValue, newValue);
        }
        for (HarmonicRule r : this.rules) {
            if (r.getBaseIndex() != index) continue;
            r.apply(this);
        }
        --this.adjusting;
        this.fireContentsChanged(this, index, index);
    }

    @Override
    public void applyRules() {
        for (HarmonicRule r : this.rules) {
            if (r.getBaseIndex() != this.base) continue;
            r.apply(this);
        }
    }

    @Override
    public CompositeColor get(int index) {
        return this.colors.get(index);
    }

    @Override
    public boolean add(CompositeColor c) {
        boolean b = this.colors.add(c);
        if (b) {
            this.fireIntervalAdded(this, this.size() - 1, this.size() - 1);
        }
        return b;
    }

    @Override
    public void setBase(int newValue) {
        this.base = newValue;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public float[] RGBtoComponent(int rgb, float[] hsb) {
        return this.sliderModel.getColorSystem().toComponents(rgb, hsb);
    }

    @Override
    public int componentToRGB(float h, float s, float b) {
        return this.sliderModel.getColorSystem().toRGB(h, s, b);
    }

    @Override
    public int getSize() {
        return this.size();
    }

    public Object getElementAt(int index) {
        return this.get(index);
    }

    @Override
    public ColorSystem getColorSystem() {
        return this.sliderModel.getColorSystem();
    }

    @Override
    public void addRule(HarmonicRule newValue) {
        this.rules.add(newValue);
    }

    @Override
    public void removeAllRules() {
        this.rules.clear();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public DefaultHarmonicColorModel clone() {
        DefaultHarmonicColorModel that;
        try {
            that = (DefaultHarmonicColorModel)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError("Clone failed");
            error.initCause(ex);
            throw error;
        }
        that.propertySupport = new PropertyChangeSupport(that);
        return that;
    }

    @Override
    public void setColorSystem(ColorSystem newValue) {
        ColorSystem oldValue = this.sliderModel.getColorSystem();
        this.sliderModel.setColorSystem(newValue);
        this.firePropertyChange("colorSystem", oldValue, newValue);
        for (int i = 0; i < this.colors.size(); ++i) {
            if (this.get(i) == null) continue;
            this.set(i, new CompositeColor(newValue, this.get(i).getColor()));
        }
        this.fireContentsChanged(this, 0, this.size() - 1);
    }
}

