/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.util.LinkedList;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.color.AbstractColorSlidersModel;
import org.jhotdraw.color.ColorSliderUI;
import org.jhotdraw.color.ColorSystem;
import org.jhotdraw.color.CompositeColor;
import org.jhotdraw.color.HSLRGBColorSystem;

public class DefaultColorSliderModel
extends AbstractColorSlidersModel {
    protected ColorSystem system;
    protected LinkedList<JSlider> sliders = new LinkedList();
    protected DefaultBoundedRangeModel[] componentModels;

    public DefaultColorSliderModel() {
        this.setColorSystem(new HSLRGBColorSystem());
    }

    public DefaultColorSliderModel(ColorSystem sys) {
        this.setColorSystem(sys);
    }

    @Override
    public void setColorSystem(ColorSystem newValue) {
        ColorSystem oldValue = this.system;
        this.system = newValue;
        this.componentModels = new DefaultBoundedRangeModel[this.system.getComponentCount()];
        for (int i = 0; i < this.componentModels.length; ++i) {
            this.componentModels[i] = new DefaultBoundedRangeModel();
            final int componentIndex = i;
            this.componentModels[i].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DefaultColorSliderModel.this.fireColorChanged(componentIndex);
                    DefaultColorSliderModel.this.fireStateChanged();
                }
            });
        }
    }

    @Override
    public void configureSlider(int componentIndex, JSlider slider) {
        if (slider.getClientProperty("colorSliderModel") != null) {
            ((DefaultColorSliderModel)slider.getClientProperty("colorSliderModel")).unconfigureSlider(slider);
        }
        if (!(slider.getUI() instanceof ColorSliderUI)) {
            slider.setUI((ColorSliderUI)ColorSliderUI.createUI(slider));
        }
        slider.setModel(this.getBoundedRangeModel(componentIndex));
        slider.putClientProperty("colorSliderModel", this);
        slider.putClientProperty("colorComponentIndex", new Integer(componentIndex));
        this.addColorSlider(slider);
    }

    @Override
    public void unconfigureSlider(JSlider slider) {
        if (slider.getClientProperty("colorSliderModel") == this) {
            slider.setModel(new DefaultBoundedRangeModel());
            slider.putClientProperty("colorSliderModel", null);
            slider.putClientProperty("colorComponentIndex", null);
            this.removeColorSlider(slider);
        }
    }

    @Override
    public DefaultBoundedRangeModel getBoundedRangeModel(int componentIndex) {
        return this.componentModels[componentIndex];
    }

    public int getSliderValue(int componentIndex) {
        return this.componentModels[componentIndex].getValue();
    }

    public void setSliderValue(int componentIndex, int value) {
        this.componentModels[componentIndex].setValue(value);
    }

    protected void addColorSlider(JSlider slider) {
        this.sliders.add(slider);
    }

    protected void removeColorSlider(JSlider slider) {
        this.sliders.remove(slider);
    }

    protected void fireColorChanged(int componentIndex) {
        Integer index = new Integer(componentIndex);
        CompositeColor value = this.getCompositeColor();
        for (JSlider slider : this.sliders) {
            slider.putClientProperty("colorComponentChange", index);
            slider.putClientProperty("colorComponentValue", value);
        }
    }

    @Override
    public ColorSystem getColorSystem() {
        return this.system;
    }

    @Override
    public int getComponentCount() {
        return this.system.getComponentCount();
    }

    @Override
    public CompositeColor getCompositeColor() {
        float[] c = new float[this.system.getComponentCount()];
        int i = 0;
        for (DefaultBoundedRangeModel m : this.componentModels) {
            c[i] = (float)(m.getValue() - m.getMinimum()) / (float)(m.getMaximum() - m.getMinimum());
            ++i;
        }
        return new CompositeColor(this.system, c);
    }

    @Override
    public int getInterpolatedRGB(int componentIndex, float componentValue) {
        float[] c = new float[this.system.getComponentCount()];
        int i = 0;
        for (DefaultBoundedRangeModel m : this.componentModels) {
            c[i] = (float)(m.getValue() - m.getMinimum()) / (float)(m.getMaximum() - m.getMinimum());
            ++i;
        }
        c[componentIndex] = componentValue;
        return this.system.toRGB(c);
    }

    @Override
    public void setComponentValue(int componentIndex, float newValue) {
        DefaultBoundedRangeModel brm = this.componentModels[componentIndex];
        brm.setValue((int)((float)(brm.getMaximum() - brm.getMinimum()) * newValue) + brm.getMinimum());
    }

    @Override
    public float getComponentValue(int componentIndex) {
        DefaultBoundedRangeModel brm = this.componentModels[componentIndex];
        return (float)(brm.getValue() - brm.getMinimum()) / (float)(brm.getMaximum() - brm.getMinimum());
    }

    @Override
    public void setCompositeColor(CompositeColor newValue) {
        float[] c = newValue.getComponents();
        int i = 0;
        for (DefaultBoundedRangeModel m : this.componentModels) {
            m.setValue((int)(c[i] * (float)(m.getMaximum() - m.getMinimum() + m.getMinimum())));
            ++i;
        }
    }

    @Override
    public Color getColor() {
        return this.getCompositeColor().getColor();
    }

    @Override
    public void setColor(Color newValue) {
        this.setCompositeColor(new CompositeColor(this.system, newValue));
    }
}

