/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import org.jhotdraw.color.ColorSystem;
import org.jhotdraw.color.CompositeColor;

public class ColorWheelImageProducer
extends MemoryImageSource {
    protected int[] pixels;
    protected int w;
    protected int h;
    protected float verticalValue = 1.0f;
    protected boolean isLookupValid = false;
    protected boolean isPixelsValid = false;
    protected float[] angulars;
    protected float[] radials;
    protected int[] alphas;
    protected ColorSystem colorSystem;
    protected int radialIndex = 1;
    protected int angularIndex = 0;
    protected int verticalIndex = 2;

    public ColorWheelImageProducer(ColorSystem sys, int w, int h) {
        super(w, h, null, 0, w);
        this.pixels = new int[w * h];
        this.w = w;
        this.h = h;
        this.colorSystem = sys;
        this.setAnimated(true);
        this.newPixels(this.pixels, ColorModel.getRGBdefault(), 0, w);
    }

    public int getRadius() {
        return Math.min(this.w, this.h) / 2 - 2;
    }

    public void setRadialComponentIndex(int newValue) {
        this.radialIndex = newValue;
        this.isPixelsValid = false;
    }

    public void setAngularComponentIndex(int newValue) {
        this.angularIndex = newValue;
        this.isPixelsValid = false;
    }

    public void setVerticalComponentIndex(int newValue) {
        this.verticalIndex = newValue;
        this.isPixelsValid = false;
    }

    protected void generateLookupTables() {
        this.radials = new float[this.w * this.h];
        this.angulars = new float[this.w * this.h];
        this.alphas = new int[this.w * this.h];
        float radius = this.getRadius();
        float blend = (radius + 2.0f) / radius - 1.0f;
        int cx = this.w / 2;
        int cy = this.h / 2;
        for (int x = 0; x < this.w; ++x) {
            int kx = x - cx;
            int squarekx = kx * kx;
            for (int y = 0; y < this.h; ++y) {
                int ky = cy - y;
                int index = x + y * this.w;
                this.radials[index] = (float)Math.sqrt(squarekx + ky * ky) / radius;
                if (this.radials[index] <= 1.0f) {
                    this.alphas[index] = -16777216;
                } else {
                    this.alphas[index] = (int)((blend - Math.min(blend, this.radials[index] - 1.0f)) * 255.0f / blend) << 24;
                    this.radials[index] = 1.0f;
                }
                if (this.alphas[index] == 0) continue;
                this.angulars[index] = (float)(Math.atan2(ky, kx) / Math.PI / 2.0);
            }
        }
        this.isLookupValid = true;
    }

    public void setVerticalValue(float newValue) {
        this.isPixelsValid = this.isPixelsValid && this.verticalValue == newValue;
        this.verticalValue = newValue;
    }

    public boolean needsGeneration() {
        return !this.isPixelsValid;
    }

    public void regenerateColorWheel() {
        if (!this.isPixelsValid) {
            this.generateColorWheel();
        }
    }

    public void generateColorWheel() {
        if (!this.isLookupValid) {
            this.generateLookupTables();
        }
        float[] components = new float[this.colorSystem.getComponentCount()];
        float radius = Math.min(this.w, this.h);
        for (int index = 0; index < this.pixels.length; ++index) {
            if (this.alphas[index] == 0) continue;
            components[this.angularIndex] = this.angulars[index];
            components[this.radialIndex] = this.radials[index];
            components[this.verticalIndex] = this.verticalValue;
            this.pixels[index] = this.alphas[index] | 0xFFFFFF & this.colorSystem.toRGB(components);
        }
        this.newPixels();
        this.isPixelsValid = true;
    }

    protected Point getColorLocation(Color c, int width, int height) {
        float[] hsb = new float[3];
        hsb = this.colorSystem.toComponents(c.getRGB(), hsb);
        return this.getColorLocation(hsb[0], hsb[1], hsb[2], width, height);
    }

    protected Point getColorLocation(float hue, float saturation, float brightness, int width, int height) {
        float radial;
        float angular;
        switch (this.angularIndex) {
            default: {
                angular = hue;
                break;
            }
            case 1: {
                angular = saturation;
                break;
            }
            case 2: {
                angular = brightness;
            }
        }
        switch (this.radialIndex) {
            default: {
                radial = hue;
                break;
            }
            case 1: {
                radial = saturation;
                break;
            }
            case 2: {
                radial = brightness;
            }
        }
        float radius = (float)Math.min(width, height) / 2.0f;
        radial = Math.max(0.0f, Math.min(1.0f, radial));
        Point p = new Point(width / 2 + (int)((double)(radius * radial) * Math.cos((double)angular * Math.PI * 2.0)), height / 2 - (int)((double)(radius * radial) * Math.sin((double)angular * Math.PI * 2.0)));
        return p;
    }

    protected Point getColorLocation(CompositeColor c, int width, int height) {
        return this.getColorLocation(c.getComponents(), width, height);
    }

    protected Point getColorLocation(float[] components, int width, int height) {
        return this.getColorLocation(components[0], components[1], components[2], width, height);
    }

    protected float[] getColorAt(int x, int y, int width, int height) {
        float r = (float)Math.sqrt((x -= width / 2) * x + (y -= height / 2) * y);
        float theta = (float)Math.atan2(y, -x);
        float angular = (float)(0.5 + (double)theta / Math.PI / 2.0);
        float[] hsb = new float[3];
        hsb[this.angularIndex] = angular;
        hsb[this.radialIndex] = Math.min(1.0f, r / (float)this.getRadius());
        hsb[this.verticalIndex] = this.verticalValue;
        return hsb;
    }
}

