/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import org.jhotdraw.color.AbstractColorSystem;

public class CMYKICCColorSystem
extends AbstractColorSystem {
    private ICC_ColorSpace colorSpace;

    public CMYKICCColorSystem() {
        try {
            this.read(this.getClass().getResourceAsStream("Generic CMYK Profile.icc"));
        }
        catch (IOException e) {
            InternalError err = new InternalError("Couldn't load \"Generic CMYK Profile.icc\".");
            err.initCause(e);
            throw err;
        }
    }

    public CMYKICCColorSystem(InputStream iccProfile) throws IOException {
        this.read(iccProfile);
    }

    public void read(InputStream iccProfile) throws IOException {
        this.colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(iccProfile));
    }

    @Override
    public float[] toComponents(int r, int g, int b, float[] component) {
        if (component == null || component.length != 4) {
            component = new float[4];
        }
        component[0] = (float)r / 255.0f;
        component[1] = (float)g / 255.0f;
        component[2] = (float)b / 255.0f;
        float[] cmyk = this.colorSpace.fromRGB(component);
        System.arraycopy(cmyk, 0, component, 0, 4);
        return component;
    }

    @Override
    public int toRGB(float ... component) {
        float[] rgb = this.colorSpace.toRGB(component);
        return 0xFF000000 | (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
    }

    @Override
    public int getComponentCount() {
        return 4;
    }
}

