/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class OneChartFrame
extends ImageFrame
implements ChartReceiver {
    private CheckboxGroup timeGroup = new CheckboxGroup();
    private CheckboxGroup typeGroup = new CheckboxGroup();
    private Checkbox time1d;
    private Checkbox time5d;
    private Checkbox time10d;
    private Checkbox time3m;
    private Checkbox time6m;
    private Checkbox time1y;
    private Checkbox time2y;
    private Checkbox time3y;
    private Checkbox time5y;
    private Checkbox timemy;
    private Checkbox typeBalken;
    private Checkbox typeLinien;
    private Checkbox typeKerzen;
    private Checkbox typeOHLC;
    private ChartComponent chart;
    private final String wkn;
    private final String boerse;
    private int time;
    private int type;
    private Image[][] image = new Image[10][4];
    private ChartQuelle[][] quelle = new ChartQuelle[10][4];
    private byte[][][] data = new byte[10][4][];
    private int[][] status = new int[10][4];

    public OneChartFrame(ChartQuelle chartQuelle, String string, String string2, int n, int n2) {
        super("AktienMan - Chart " + string + "." + string2, "Chart", "gif", "GIFf");
        this.wkn = string;
        this.boerse = string2;
        this.time = n;
        this.type = n2;
        int n3 = 0;
        while (n3 < 10) {
            int n4 = 0;
            while (n4 < 4) {
                this.status[n3][n4] = 0;
                ++n4;
            }
            ++n3;
        }
        Panel panel = new Panel(new FlowLayout(0));
        Panel panel2 = new Panel(new GridLayout(5, 1));
        Panel panel3 = new Panel(new GridLayout(5, 1));
        Panel panel4 = new Panel(new GridLayout(5, 1));
        Panel panel5 = new Panel(new GridLayout(5, 1));
        this.chart = new ChartComponent(chartQuelle.getChartSize(), chartQuelle.getChartClipping());
        this.time1d = new Checkbox("1 Tag", false, this.timeGroup);
        this.time5d = new Checkbox("5 Tage", false, this.timeGroup);
        this.time10d = new Checkbox("10 Tage", false, this.timeGroup);
        this.time3m = new Checkbox("3 Monate", false, this.timeGroup);
        this.time6m = new Checkbox("6 Monate", false, this.timeGroup);
        this.time1y = new Checkbox("1 Jahr", false, this.timeGroup);
        this.time2y = new Checkbox("2 Jahre", false, this.timeGroup);
        this.time3y = new Checkbox("3 Jahre", false, this.timeGroup);
        this.time5y = new Checkbox("5 Jahre", false, this.timeGroup);
        this.timemy = new Checkbox("maximal", false, this.timeGroup);
        this.time1d.addItemListener(new 1());
        this.time5d.addItemListener(new 2());
        this.time10d.addItemListener(new 3());
        this.time3m.addItemListener(new 4());
        this.time6m.addItemListener(new 5());
        this.time1y.addItemListener(new 6());
        this.time2y.addItemListener(new 7());
        this.time3y.addItemListener(new 8());
        this.time5y.addItemListener(new 9());
        this.timemy.addItemListener(new 10());
        this.typeBalken = new Checkbox("Balken", false, this.typeGroup);
        this.typeLinien = new Checkbox("Linien", false, this.typeGroup);
        this.typeKerzen = new Checkbox("Kerzen", false, this.typeGroup);
        this.typeOHLC = new Checkbox("Open/Hi/Lo/Cls", false, this.typeGroup);
        this.typeBalken.addItemListener(new 11());
        this.typeLinien.addItemListener(new 12());
        this.typeKerzen.addItemListener(new 13());
        this.typeOHLC.addItemListener(new 14());
        panel2.add(new Label("Zeitraum:"));
        panel2.add(this.time1d);
        panel2.add(this.time5d);
        panel2.add(this.time10d);
        panel2.add(this.time3m);
        panel3.add(new Label(""));
        panel3.add(this.time6m);
        panel3.add(this.time1y);
        panel3.add(this.time2y);
        panel3.add(this.time3y);
        panel4.add(new Label(""));
        panel4.add(this.time5y);
        panel4.add(this.timemy);
        panel4.add(new Label(""));
        panel4.add(new Label(""));
        panel5.add(new Label("Typ:"));
        panel5.add(this.typeBalken);
        panel5.add(this.typeLinien);
        panel5.add(this.typeKerzen);
        panel5.add(this.typeOHLC);
        panel.add(new Label(" "));
        panel.add(panel2);
        panel.add(panel3);
        panel.add(panel4);
        panel.add(new Label("   "));
        panel.add(panel5);
        this.add((Component)panel, "North");
        this.add((Component)this.chart, "Center");
        this.checkButtons();
        this.pack();
        this.setupSize();
        ((Component)this).setVisible(true);
    }

    public void display() {
    }

    private void checkButtons() {
        Checkbox checkbox;
        this.time1d.setEnabled(ChartQuellen.hasAnyTime(0));
        this.time5d.setEnabled(ChartQuellen.hasAnyTime(1));
        this.time10d.setEnabled(ChartQuellen.hasAnyTime(2));
        this.time3m.setEnabled(ChartQuellen.hasAnyTime(3));
        this.time6m.setEnabled(ChartQuellen.hasAnyTime(4));
        this.time1y.setEnabled(ChartQuellen.hasAnyTime(5));
        this.time2y.setEnabled(ChartQuellen.hasAnyTime(6));
        this.time3y.setEnabled(ChartQuellen.hasAnyTime(7));
        this.time5y.setEnabled(ChartQuellen.hasAnyTime(8));
        this.timemy.setEnabled(ChartQuellen.hasAnyTime(9));
        this.typeBalken.setEnabled(ChartQuellen.hasAnyType(0));
        this.typeLinien.setEnabled(ChartQuellen.hasAnyType(1));
        this.typeKerzen.setEnabled(ChartQuellen.hasAnyType(2));
        this.typeOHLC.setEnabled(ChartQuellen.hasAnyType(3));
        switch (this.time) {
            case 0: {
                checkbox = this.time1d;
                break;
            }
            case 1: {
                checkbox = this.time5d;
                break;
            }
            case 2: {
                checkbox = this.time10d;
                break;
            }
            case 3: {
                checkbox = this.time3m;
                break;
            }
            case 4: {
                checkbox = this.time6m;
                break;
            }
            case 6: {
                checkbox = this.time2y;
                break;
            }
            case 7: {
                checkbox = this.time3y;
                break;
            }
            case 8: {
                checkbox = this.time5y;
                break;
            }
            case 9: {
                checkbox = this.timemy;
                break;
            }
            default: {
                checkbox = this.time1y;
            }
        }
        this.timeGroup.setSelectedCheckbox(checkbox);
        switch (this.type) {
            case 0: {
                checkbox = this.typeBalken;
                break;
            }
            case 2: {
                checkbox = this.typeKerzen;
                break;
            }
            case 3: {
                checkbox = this.typeOHLC;
                break;
            }
            default: {
                checkbox = this.typeLinien;
            }
        }
        this.typeGroup.setSelectedCheckbox(checkbox);
    }

    private void checkSizeAndRepaint() {
        int n;
        int n2 = ChartQuellen.time2Index(this.time);
        ChartQuelle chartQuelle = this.quelle[n2][n = ChartQuellen.type2Index(this.type)];
        if (chartQuelle != null) {
            this.chart.setImageSize(chartQuelle.getChartSize(), chartQuelle.getChartClipping());
            this.chart.invalidate();
            this.pack();
        }
        this.repaint();
    }

    private synchronized void switchTime(int n) {
        if (n != this.time) {
            this.time = n;
            this.checkSizeAndRepaint();
            if (this.getImage() == null) {
                ChartQuellen.displayChart(ChartQuellen.getChartQuelle(), this, this.wkn, this.boerse, n, this.type);
            }
        }
    }

    private synchronized void switchType(int n) {
        if (n != this.type) {
            this.type = n;
            this.checkSizeAndRepaint();
            if (this.getImage() == null) {
                ChartQuellen.displayChart(ChartQuellen.getChartQuelle(), this, this.wkn, this.boerse, this.time, n);
            }
        }
    }

    public synchronized void setImage(String string, String string2, int n, int n2, Image image, byte[] byArray, ChartQuelle chartQuelle, ChartQuelle chartQuelle2) {
        int n3 = ChartQuellen.time2Index(n);
        int n4 = ChartQuellen.type2Index(n2);
        if (image != null) {
            this.image[n3][n4] = image;
            this.data[n3][n4] = byArray;
            this.status[n3][n4] = 1;
            this.quelle[n3][n4] = chartQuelle2;
            if (n == this.time && n2 == this.type) {
                this.checkSizeAndRepaint();
            }
        } else {
            this.setError(string, string2, n, n2, -1, chartQuelle, chartQuelle2);
        }
    }

    public synchronized void setError(String string, String string2, int n, int n2, int n3, ChartQuelle chartQuelle, ChartQuelle chartQuelle2) {
        int n4;
        int n5 = ChartQuellen.time2Index(n);
        if (this.image[n5][n4 = ChartQuellen.type2Index(n2)] == null) {
            long l = ChartQuellen.getNextID(chartQuelle, chartQuelle2, n, n2);
            System.out.println("Fehler beim Einlesen der Chartdaten von " + string + "." + string2 + "  -> " + l);
            if (l == -1L) {
                this.status[n5][n4] = n3;
                if (n == this.time && n2 == this.type) {
                    this.chart.repaint();
                }
            } else {
                ChartQuellen.getChartQuelle(l).loadChart(this, string, string2, n, n2, chartQuelle);
            }
        }
    }

    public synchronized byte[] getImageData() {
        return this.data[this.currentTimeIndex()][this.currentTypeIndex()];
    }

    public synchronized Image getImage() {
        return this.image[this.currentTimeIndex()][this.currentTypeIndex()];
    }

    public String getDefaultFilename() {
        return String.valueOf(this.wkn) + "-" + this.boerse + "-" + new ADate().toTimestamp(false) + "." + this.getExt();
    }

    private synchronized int currentTimeIndex() {
        return ChartQuellen.time2Index(this.time);
    }

    private synchronized int currentTypeIndex() {
        return ChartQuellen.type2Index(this.type);
    }

    private String statusMessage() {
        switch (this.status[this.currentTimeIndex()][this.currentTypeIndex()]) {
            case 0: {
                return "Chart wird geladen...";
            }
            case -1: {
                return "Chart nicht verf\u00fcgbar.";
            }
            case -2: {
                return "Chart-Zeitraum nicht verf\u00fcgbar.";
            }
            case -3: {
                return "Chart-Typ nicht verf\u00fcgbar.";
            }
        }
        return "";
    }

    private final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchTime(0);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchTime(1);
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchTime(2);
            }
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchTime(3);
            }
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchTime(4);
            }
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchTime(5);
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchTime(6);
            }
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchTime(7);
            }
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchTime(8);
            }
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchTime(9);
            }
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchType(0);
            }
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchType(1);
            }
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchType(2);
            }
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                OneChartFrame.this.switchType(3);
            }
        }

        /* synthetic */ 14() {
        }
    }

    class ChartComponent
    extends Component {
        private static final int OFFSET = 5;
        private int chartWidth;
        private int chartHeight;
        private Dimension dim;
        private Insets clip;

        public ChartComponent(Dimension dimension, Insets insets) {
            this.setImageSize(dimension, insets);
        }

        public void setImageSize(Dimension dimension, Insets insets) {
            this.chartWidth = dimension.width;
            this.chartHeight = dimension.height;
            this.dim = new Dimension(this.chartWidth + 10, this.chartHeight + 10);
            this.clip = insets;
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.clearRect(0, 0, dimension.width, dimension.height);
            Image image = OneChartFrame.this.getImage();
            if (image != null) {
                graphics.drawImage(image, 5, 5, dimension.width - 5 - 1, dimension.height - 5 - 1, this.clip.left, this.clip.top, this.chartWidth - this.clip.right - 1, this.chartHeight - this.clip.bottom - 1, this);
            } else {
                graphics.drawString(OneChartFrame.this.statusMessage(), 50, 50);
            }
        }
    }
}

