/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class ADate
implements Serializable {
    static final long serialVersionUID = 1979090400000L;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    private static TimeZone timezone = TimeZone.getTimeZone("ECT");
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int serialDate;

    public ADate() {
        Calendar calendar = Calendar.getInstance(timezone);
        this.set(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public ADate(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public ADate(int n) {
        this.set(n);
    }

    private ADate(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.year = ADate.fixYear(n);
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        if (n7 < 0) {
            this.calculateSerialDate();
        } else {
            this.serialDate = n7;
        }
    }

    public void set(int n, int n2, int n3) {
        this.set(n, n2, n3, 0, 0, 0);
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.year = ADate.fixYear(n);
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.calculateSerialDate();
    }

    public void set(int n) {
        if ((long)n < 0L) {
            return;
        }
        this.serialDate = n;
        int n2 = 1900;
        int n3 = ADate.getDays(n2);
        while (n >= n3) {
            n -= n3;
            n3 = ADate.getDays(++n2);
        }
        int n4 = 1;
        n3 = ADate.getDays(n2, n4);
        while (n >= n3) {
            n -= n3;
            n3 = ADate.getDays(n2, ++n4);
        }
        this.year = n2;
        this.month = n4;
        this.day = n + 1;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
    }

    public int getSerialDate() {
        return this.serialDate;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public boolean before(ADate aDate) {
        return aDate.getSerialDate() > this.getSerialDate();
    }

    public boolean after(ADate aDate) {
        return aDate.getSerialDate() < this.getSerialDate();
    }

    public boolean equals(ADate aDate) {
        return aDate.getSerialDate() == this.getSerialDate();
    }

    public String toString() {
        return String.valueOf(this.getDay()) + "." + this.getMonth() + "." + this.getYear();
    }

    public String timeToString() {
        int n = this.getMinute();
        return String.valueOf(this.getHour()) + ":" + (n < 10 ? "0" : "") + n;
    }

    public String toTimestamp(boolean bl) {
        return this.toTimestamp(bl, false);
    }

    public String toTimestamp(boolean bl, boolean bl2) {
        int n = this.getMonth();
        int n2 = this.getDay();
        String string = String.valueOf(this.getYear()) + (n < 10 ? "0" : "") + n + (n2 < 10 ? "0" : "") + n2;
        if (bl) {
            int n3 = this.getMinute();
            int n4 = this.getHour();
            string = String.valueOf(string) + "-" + (n4 < 10 ? "0" : "") + n4 + (n3 < 10 ? "0" : "") + n3;
            if (bl2) {
                int n5 = this.getSecond();
                string = String.valueOf(string) + (n5 < 10 ? "0" : "") + n5 + "-" + this.getSerialDate();
            }
        }
        return string;
    }

    public static boolean isLeapYear(int n) {
        if ((n = ADate.fixYear(n)) % 4 == 0) {
            if (n % 100 == 0) {
                return n % 400 == 0;
            }
            return true;
        }
        return false;
    }

    public static int getDays(int n) {
        if (ADate.isLeapYear(n)) {
            return 366;
        }
        return 365;
    }

    public static int getDays(int n, int n2) {
        if (n2 == 2) {
            if (ADate.isLeapYear(n)) {
                return 29;
            }
            return 28;
        }
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 0;
    }

    public static ADate parse(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ".,/- ");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (stringTokenizer.hasMoreTokens()) {
                String string3;
                String string4 = stringTokenizer.nextToken().trim();
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken().trim();
                    if (stringTokenizer.hasMoreTokens()) {
                        throw new Exception();
                    }
                } else {
                    string3 = String.valueOf(new ADate().getYear());
                }
                int n = Integer.parseInt(string3);
                int n2 = Integer.parseInt(string4);
                int n3 = Integer.parseInt(string2);
                if ((n >= 0 && n <= 99 || n >= 1900 && n <= 2199) && n2 >= 1 && n2 <= 12 && n3 >= 1) {
                    if (n3 <= ADate.getDays(n, n2)) {
                        return new ADate(n, n2, n3);
                    }
                    throw new Exception();
                }
                throw new Exception();
            }
            throw new Exception();
        }
        throw new Exception();
    }

    public static ADate parseTimestamp(String string) throws Exception {
        if (string == null) {
            return null;
        }
        if (string.length() < 8) {
            throw new Exception("Ung\u00fcltiges Datum: " + string);
        }
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 6));
        int n3 = Integer.parseInt(string.substring(6, 8));
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        if (string.length() >= 15) {
            n4 = Integer.parseInt(string.substring(9, 11));
            n5 = Integer.parseInt(string.substring(11, 13));
            n6 = Integer.parseInt(string.substring(13, 15));
            if (string.length() > 16) {
                n7 = Integer.parseInt(string.substring(16));
            }
        }
        return new ADate(n, n2, n3, n4, n5, n6, n7);
    }

    private static int fixYear(int n) {
        if (n < 100) {
            n = n < 80 ? (n += 2000) : (n += 1900);
        }
        return n;
    }

    private void calculateSerialDate() {
        int n = this.getYear();
        int n2 = this.getMonth();
        this.serialDate = this.getDay() - 1;
        if (n < 1900) {
            n = 1900;
        }
        int n3 = 1900;
        while (n3 < n) {
            this.serialDate += ADate.getDays(n3);
            ++n3;
        }
        int n4 = 1;
        while (n4 < n2) {
            this.serialDate += ADate.getDays(n, n4);
            ++n4;
        }
    }
}

