/*
 * UrlDialog.
 *
 * JavaZOOM : jlgui@javazoom.net
 *            http://www.javazoom.net
 *
 *-----------------------------------------------------------------------
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------
 */
package javazoom.jlgui.player.amp.skin;

import javax.swing.JDialog;
import javax.swing.JFrame;

/**
 * UrlDialog class implements a DialogBox to get an URL.
 */
public class UrlDialog extends JDialog
{
    private String _url = null;

    /**
     * Creates new form ud
     */
    public UrlDialog(JFrame parent, String title, int x, int y, String url)
    {
        super(parent, title, true);
        _url = url;
        initComponents();
        if (_url != null) textField.setText(_url);
        this.setLocation(x, y);
    }

    /**
     * Returns URL.
     */
    public String getURL()
    {
        return _url;
    }

    /**
     * Returns filename.
     */
    public String getFile()
    {
        return _url;
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents()
    {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        textField = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        openButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        getContentPane().setLayout(new java.awt.GridBagLayout());
        jLabel1.setText("Enter an Internet location to open here :");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jLabel1, gridBagConstraints);
        jLabel2.setText("\"For example : http://www.server.com:8000\"");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jLabel2, gridBagConstraints);
        textField.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(textField, gridBagConstraints);
        openButton.setMnemonic('O');
        openButton.setText("Open");
        openButton.setToolTipText("Open");
        openButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                openHandler(evt);
            }
        });
        jPanel1.add(openButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.setToolTipText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                cancelHandler(evt);
            }
        });
        jPanel1.add(cancelButton);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jPanel1, gridBagConstraints);
        pack();
    }//GEN-END:initComponents

    private void cancelHandler(java.awt.event.ActionEvent evt)
    {//GEN-FIRST:event_cancelHandler
        _url = null;
        this.dispose();
    }//GEN-LAST:event_cancelHandler

    private void openHandler(java.awt.event.ActionEvent evt)
    {//GEN-FIRST:event_openHandler
        _url = textField.getText();
        this.dispose();
    }//GEN-LAST:event_openHandler
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton openButton;
    private javax.swing.JTextField textField;
    // End of variables declaration//GEN-END:variables
}
