/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.visual.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JPanel;
import javazoom.jlgui.player.amp.skin.AbsoluteConstraints;
import kj.dsp.KJDigitalSignalProcessingAudioDataConsumer;
import kj.dsp.KJDigitalSignalProcessor;
import kj.dsp.KJFFT;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpectrumTimeAnalyzer
extends JPanel
implements KJDigitalSignalProcessor {
    private static Log log = LogFactory.getLog((Class)SpectrumTimeAnalyzer.class);
    public static final int DISPLAY_MODE_SCOPE = 0;
    public static final int DISPLAY_MODE_SPECTRUM_ANALYSER = 1;
    public static final int DISPLAY_MODE_OFF = 2;
    public static final int DEFAULT_WIDTH = 256;
    public static final int DEFAULT_HEIGHT = 128;
    public static final int DEFAULT_FPS = 50;
    public static final int DEFAULT_SPECTRUM_ANALYSER_FFT_SAMPLE_SIZE = 512;
    public static final int DEFAULT_SPECTRUM_ANALYSER_BAND_COUNT = 19;
    public static final float DEFAULT_SPECTRUM_ANALYSER_DECAY = 0.05f;
    public static final int DEFAULT_SPECTRUM_ANALYSER_PEAK_DELAY = 20;
    public static final float DEFAULT_SPECTRUM_ANALYSER_PEAK_DELAY_FPS_RATIO = 0.4f;
    public static final float DEFAULT_SPECTRUM_ANALYSER_PEAK_DELAY_FPS_RATIO_RANGE = 0.1f;
    public static final float MIN_SPECTRUM_ANALYSER_DECAY = 0.02f;
    public static final float MAX_SPECTRUM_ANALYSER_DECAY = 0.08f;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(0, 0, 128);
    public static final Color DEFAULT_SCOPE_COLOR = new Color(255, 192, 0);
    public static final float DEFAULT_VU_METER_DECAY = 0.02f;
    private Image bi;
    private int displayMode = 0;
    private Color scopeColor = DEFAULT_SCOPE_COLOR;
    private Color[] spectrumAnalyserColors = SpectrumTimeAnalyzer.getDefaultSpectrumAnalyserColors();
    private KJDigitalSignalProcessingAudioDataConsumer dsp = null;
    private boolean dspStarted = false;
    private Color peakColor = null;
    private int[] peaks = new int[19];
    private int[] peaksDelay = new int[19];
    private int peakDelay = 20;
    private boolean peaksEnabled = true;
    private List visColors = null;
    private int barOffset = 1;
    private int width;
    private int height;
    private int height_2;
    private KJFFT fft;
    private float[] old_FFT;
    private int saFFTSampleSize;
    private int saBands;
    private float saColorScale;
    private float saMultiplier;
    private float saDecay = 0.05f;
    private float sad;
    private SourceDataLine m_line = null;
    private float oldLeft;
    private float oldRight;
    private float vuDecay = 0.02f;
    private float vuColorScale;
    private long lfu = 0L;
    private int fc = 0;
    private int fps = 50;
    private boolean showFPS = false;
    private AbsoluteConstraints constraints = null;

    public SpectrumTimeAnalyzer() {
        this.setOpaque(false);
        this.initialize();
    }

    public void setConstraints(AbsoluteConstraints absoluteConstraints) {
        this.constraints = absoluteConstraints;
    }

    public AbsoluteConstraints getConstraints() {
        return this.constraints;
    }

    public boolean isPeaksEnabled() {
        return this.peaksEnabled;
    }

    public void setPeaksEnabled(boolean bl) {
        this.peaksEnabled = bl;
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int n) {
        this.fps = n;
    }

    public void startDSP(SourceDataLine sourceDataLine) {
        if (this.displayMode == 2) {
            return;
        }
        if (sourceDataLine != null) {
            this.m_line = sourceDataLine;
        }
        if (this.dsp == null) {
            this.dsp = new KJDigitalSignalProcessingAudioDataConsumer(2048, this.fps);
            this.dsp.add((KJDigitalSignalProcessor)this);
        }
        if (this.dsp != null && this.m_line != null) {
            if (this.dspStarted) {
                this.stopDSP();
            }
            this.dsp.start(this.m_line);
            this.dspStarted = true;
            log.debug((Object)"DSP started");
        }
    }

    public void stopDSP() {
        if (this.dsp != null) {
            this.dsp.stop();
            this.dspStarted = false;
            log.debug((Object)"DSP stopped");
        }
    }

    public void closeDSP() {
        if (this.dsp != null) {
            this.stopDSP();
            this.dsp = null;
            log.debug((Object)"DSP closed");
        }
    }

    public void setupDSP(SourceDataLine sourceDataLine) {
        if (this.dsp != null) {
            int n = sourceDataLine.getFormat().getChannels();
            if (n == 1) {
                this.dsp.setChannelMode(1);
            } else {
                this.dsp.setChannelMode(2);
            }
            int n2 = sourceDataLine.getFormat().getSampleSizeInBits();
            if (n2 == 8) {
                this.dsp.setSampleType(1);
            } else {
                this.dsp.setSampleType(2);
            }
        }
    }

    public void writeDSP(byte[] byArray) {
        if (this.dsp != null && this.dspStarted) {
            this.dsp.writeAudioData(byArray);
        }
    }

    public KJDigitalSignalProcessingAudioDataConsumer getDSP() {
        return this.dsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisColor(String string) {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        string = string.toLowerCase();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        try {
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(this.getColor(string2));
            }
            Color[] colorArray = new Color[arrayList.size()];
            arrayList.toArray(colorArray);
            Color[] colorArray2 = new Color[15];
            System.arraycopy(colorArray, 2, colorArray2, 0, 15);
            List<Color> list = Arrays.asList(colorArray2);
            Collections.reverse(list);
            colorArray2 = list.toArray(colorArray2);
            this.setSpectrumAnalyserColors(colorArray2);
            this.setBackground((Color)arrayList.get(0));
            if (arrayList.size() > 23) {
                this.setPeakColor((Color)arrayList.get(23));
            }
            if (arrayList.size() > 18) {
                this.setScopeColor((Color)arrayList.get(18));
            }
        }
        catch (IOException iOException) {
            log.warn((Object)"Cannot parse viscolors", (Throwable)iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setPeakColor(Color color) {
        this.peakColor = color;
    }

    public void setPeakDelay(int n) {
        int n2 = Math.round(0.3f * (float)this.fps);
        int n3 = Math.round(0.5f * (float)this.fps);
        this.peakDelay = n >= n2 && n <= n3 ? n : Math.round(0.4f * (float)this.fps);
    }

    public int getPeakDelay() {
        return this.peakDelay;
    }

    public Color getColor(String string) {
        Color color = Color.BLACK;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            if (stringTokenizer.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() > 3) {
                    string2 = string2.substring(0, 3).trim();
                }
                n3 = Integer.parseInt(string2);
            }
            color = new Color(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            log.debug((Object)("Cannot parse viscolor : " + numberFormatException.getMessage()));
        }
        return color;
    }

    private void computeColorScale() {
        this.saColorScale = (float)this.spectrumAnalyserColors.length / (float)this.height * (float)this.barOffset * 1.0f;
        this.vuColorScale = (float)this.spectrumAnalyserColors.length / (float)(this.width - 32) * 2.0f;
    }

    private void computeSAMultiplier() {
        this.saMultiplier = this.saFFTSampleSize / 2 / this.saBands;
    }

    private void drawScope(Graphics graphics, float[] fArray) {
        int n;
        graphics.setColor(this.scopeColor);
        int n2 = (int)(fArray[0] * (float)this.height_2) + this.height_2;
        int n3 = n = 2;
        for (int i = 0; i < this.width; ++i) {
            int n4 = (int)(fArray[n3] * (float)this.height_2) + this.height_2;
            graphics.drawLine(i, n2, i + 1, n4);
            n2 = n4;
            n3 += n;
        }
    }

    private void drawSpectrumAnalyser(Graphics graphics, float[] fArray, float f) {
        float f2 = 0.0f;
        float[] fArray2 = this.fft.calculate(fArray);
        float f3 = this.saDecay * f;
        float f4 = (float)this.width / (float)this.saBands;
        int n = 0;
        for (int i = 0; i < this.saBands; ++i) {
            float f5 = 0.0f;
            int n2 = 0;
            while ((float)n2 < this.saMultiplier) {
                f5 += fArray2[n + n2];
                ++n2;
            }
            if ((f5 *= (float)Math.log(i + 2)) > 1.0f) {
                f5 = 1.0f;
            }
            if (f5 >= this.old_FFT[n] - f3) {
                this.old_FFT[n] = f5;
            } else {
                int n3 = n;
                this.old_FFT[n3] = this.old_FFT[n3] - f3;
                if (this.old_FFT[n] < 0.0f) {
                    this.old_FFT[n] = 0.0f;
                }
                f5 = this.old_FFT[n];
            }
            this.drawSpectrumAnalyserBar(graphics, (int)f2, this.height, (int)f4 - 1, (int)(f5 * (float)this.height), i);
            f2 += f4;
            n = (int)((float)n + this.saMultiplier);
        }
    }

    private void drawVUMeter(Graphics graphics, float[] fArray, float[] fArray2, float f) {
        int n;
        if (this.displayMode == 2) {
            return;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = this.vuDecay * f;
        for (n = 0; n < fArray.length; ++n) {
            f2 += Math.abs(fArray[n]);
            f3 += Math.abs(fArray2[n]);
        }
        f2 = f2 * 2.0f / (float)fArray.length;
        f3 = f3 * 2.0f / (float)fArray2.length;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f2 >= this.oldLeft - f4) {
            this.oldLeft = f2;
        } else {
            this.oldLeft -= f4;
            if (this.oldLeft < 0.0f) {
                this.oldLeft = 0.0f;
            }
        }
        if (f3 >= this.oldRight - f4) {
            this.oldRight = f3;
        } else {
            this.oldRight -= f4;
            if (this.oldRight < 0.0f) {
                this.oldRight = 0.0f;
            }
        }
        n = (this.height >> 1) - 24;
        this.drawVolumeMeterBar(graphics, 16, 16, (int)(this.oldLeft * (float)(this.width - 32)), n);
        this.drawVolumeMeterBar(graphics, 16, n + 32, (int)(this.oldRight * (float)(this.width - 32)), n);
    }

    private void drawSpectrumAnalyserBar(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        float f = 0.0f;
        for (int i = n2; i >= n2 - n4; i -= this.barOffset) {
            if ((f += this.saColorScale) < (float)this.spectrumAnalyserColors.length) {
                graphics.setColor(this.spectrumAnalyserColors[(int)f]);
            }
            graphics.fillRect(n, i, n3, 1);
        }
        if (this.peakColor != null && this.peaksEnabled) {
            graphics.setColor(this.peakColor);
            if (n4 > this.peaks[n5]) {
                this.peaks[n5] = n4;
                this.peaksDelay[n5] = this.peakDelay;
            } else {
                int n6 = n5;
                this.peaksDelay[n6] = this.peaksDelay[n6] - 1;
                if (this.peaksDelay[n5] < 0) {
                    int n7 = n5;
                    this.peaks[n7] = this.peaks[n7] - 1;
                }
                if (this.peaks[n5] < 0) {
                    this.peaks[n5] = 0;
                }
            }
            graphics.fillRect(n, n2 - this.peaks[n5], n3, 1);
        }
    }

    private void drawVolumeMeterBar(Graphics graphics, int n, int n2, int n3, int n4) {
        float f = 0.0f;
        for (int i = n; i <= n + n3; i += 2) {
            if ((f += this.vuColorScale) < 256.0f) {
                graphics.setColor(this.spectrumAnalyserColors[(int)f]);
            }
            graphics.fillRect(i, n2, 1, n4);
        }
    }

    private synchronized Image getDoubleBuffer() {
        if (this.bi == null || this.bi.getWidth(null) != this.getSize().width || this.bi.getHeight(null) != this.getSize().height) {
            this.width = this.getSize().width;
            this.height = this.getSize().height;
            this.height_2 = this.height >> 1;
            this.computeColorScale();
            this.bi = this.getGraphicsConfiguration().createCompatibleVolatileImage(this.width, this.height);
        }
        return this.bi;
    }

    public static Color[] getDefaultSpectrumAnalyserColors() {
        int n;
        Color[] colorArray = new Color[256];
        for (n = 0; n < 128; ++n) {
            colorArray[n] = new Color(0, (n >> 1) + 192, 0);
        }
        for (n = 0; n < 64; ++n) {
            colorArray[n + 128] = new Color(n << 2, 255, 0);
        }
        for (n = 0; n < 64; ++n) {
            colorArray[n + 192] = new Color(255, 255 - (n << 2), 0);
        }
        return colorArray;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public int getSpectrumAnalyserBandCount() {
        return this.saBands;
    }

    public float getSpectrumAnalyserDecay() {
        return this.saDecay;
    }

    public Color getScopeColor() {
        return this.scopeColor;
    }

    public Color[] getSpectrumAnalyserColors() {
        return this.spectrumAnalyserColors;
    }

    private void initialize() {
        this.setSize(256, 128);
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.prepareDisplayToggleListener();
        this.setSpectrumAnalyserBandCount(19);
        this.setSpectrumAnalyserFFTSampleSize(512);
    }

    public boolean isShowingFPS() {
        return this.showFPS;
    }

    public void paintComponent(Graphics graphics) {
        if (this.displayMode == 2) {
            return;
        }
        if (this.dspStarted) {
            graphics.drawImage(this.getDoubleBuffer(), 0, 0, null);
        } else {
            super.paintComponent(graphics);
        }
    }

    private void prepareDisplayToggleListener() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    if (SpectrumTimeAnalyzer.this.displayMode + 1 > 1) {
                        SpectrumTimeAnalyzer.this.displayMode = 0;
                    } else {
                        SpectrumTimeAnalyzer.this.displayMode++;
                    }
                }
            }
        });
    }

    public synchronized void process(float[] fArray, float[] fArray2, float f) {
        if (this.displayMode == 2) {
            return;
        }
        Graphics graphics = this.getDoubleBuffer().getGraphics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        switch (this.displayMode) {
            case 0: {
                this.drawScope(graphics, this.stereoMerge(fArray, fArray2));
                break;
            }
            case 1: {
                this.drawSpectrumAnalyser(graphics, this.stereoMerge(fArray, fArray2), f);
                break;
            }
            case 2: {
                this.drawVUMeter(graphics, fArray, fArray2, f);
            }
        }
        if (this.showFPS) {
            if (System.currentTimeMillis() >= this.lfu + 1000L) {
                this.lfu = System.currentTimeMillis();
                this.fps = this.fc;
                this.fc = 0;
            }
            ++this.fc;
            graphics.setColor(Color.yellow);
            graphics.drawString("FPS: " + this.fps + " (FRRH: " + f + ")", 0, this.height - 1);
        }
        if (this.getGraphics() != null) {
            this.getGraphics().drawImage(this.getDoubleBuffer(), 0, 0, null);
        }
    }

    public synchronized void setDisplayMode(int n) {
        this.displayMode = n;
    }

    public synchronized void setScopeColor(Color color) {
        this.scopeColor = color;
    }

    public synchronized void setShowFPS(boolean bl) {
        this.showFPS = bl;
    }

    public synchronized void setSpectrumAnalyserBandCount(int n) {
        this.saBands = n;
        this.peaks = new int[this.saBands];
        this.peaksDelay = new int[this.saBands];
        this.computeSAMultiplier();
    }

    public synchronized void setSpectrumAnalyserDecay(float f) {
        this.saDecay = f >= 0.02f && f <= 0.08f ? f : 0.05f;
    }

    public synchronized void setSpectrumAnalyserColors(Color[] colorArray) {
        this.spectrumAnalyserColors = colorArray;
        this.computeColorScale();
    }

    public synchronized void setSpectrumAnalyserFFTSampleSize(int n) {
        this.saFFTSampleSize = n;
        this.fft = new KJFFT(this.saFFTSampleSize);
        this.old_FFT = new float[this.saFFTSampleSize];
        this.computeSAMultiplier();
    }

    private float[] stereoMerge(float[] fArray, float[] fArray2) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (fArray[i] + fArray2[i]) / 2.0f;
        }
        return fArray;
    }
}

