/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.tag;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jlgui.player.amp.tag.TagInfo;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class OggVorbisInfo
implements TagInfo {
    protected int serial = 0;
    protected int channels = 0;
    protected int version = 0;
    protected int rate = 0;
    protected int minbitrate = 0;
    protected int maxbitrate = 0;
    protected int averagebitrate = 0;
    protected int nominalbitrate = 0;
    protected long totalms = 0L;
    protected String vendor = "";
    protected String location = null;
    protected long size = 0L;
    protected int track = -1;
    protected String year = null;
    protected String genre = null;
    protected String title = null;
    protected String artist = null;
    protected String album = null;
    protected Vector comments = new Vector();

    public void load(File file) throws IOException, UnsupportedAudioFileException {
        this.size = file.length();
        this.location = file.getPath();
        this.loadInfo(file);
    }

    public void load(URL uRL) throws IOException, UnsupportedAudioFileException {
        this.location = uRL.toString();
        this.loadInfo(uRL);
    }

    public void load(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        this.loadInfo(inputStream);
    }

    protected void loadInfo(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(inputStream);
        this.loadInfo(audioFileFormat);
    }

    protected void loadInfo(File file) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(file);
        this.loadInfo(audioFileFormat);
    }

    protected void loadInfo(URL uRL) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(uRL);
        this.loadInfo(audioFileFormat);
        this.loadExtendedInfo(audioFileFormat);
    }

    protected void loadInfo(AudioFileFormat audioFileFormat) throws UnsupportedAudioFileException {
        String string = audioFileFormat.getType().toString();
        if (!string.equalsIgnoreCase("ogg")) {
            throw new UnsupportedAudioFileException("Not Ogg Vorbis audio format");
        }
        if (audioFileFormat instanceof TAudioFileFormat) {
            Map map = ((TAudioFileFormat)audioFileFormat).properties();
            if (map.containsKey("ogg.channels")) {
                this.channels = (Integer)map.get("ogg.channels");
            }
            if (map.containsKey("ogg.frequency.hz")) {
                this.rate = (Integer)map.get("ogg.frequency.hz");
            }
            if (map.containsKey("ogg.bitrate.nominal.bps")) {
                this.nominalbitrate = (Integer)map.get("ogg.bitrate.nominal.bps");
            }
            this.averagebitrate = this.nominalbitrate;
            if (map.containsKey("ogg.bitrate.max.bps")) {
                this.maxbitrate = (Integer)map.get("ogg.bitrate.max.bps");
            }
            if (map.containsKey("ogg.bitrate.min.bps")) {
                this.minbitrate = (Integer)map.get("ogg.bitrate.min.bps");
            }
            if (map.containsKey("ogg.version")) {
                this.version = (Integer)map.get("ogg.version");
            }
            if (map.containsKey("ogg.serial")) {
                this.serial = (Integer)map.get("ogg.serial");
            }
            if (map.containsKey("ogg.comment.encodedby")) {
                this.vendor = (String)map.get("ogg.comment.encodedby");
            }
            if (map.containsKey("copyright")) {
                this.comments.add((String)map.get("copyright"));
            }
            if (map.containsKey("title")) {
                this.title = (String)map.get("title");
            }
            if (map.containsKey("author")) {
                this.artist = (String)map.get("author");
            }
            if (map.containsKey("album")) {
                this.album = (String)map.get("album");
            }
            if (map.containsKey("date")) {
                this.year = (String)map.get("date");
            }
            if (map.containsKey("comment")) {
                this.comments.add((String)map.get("comment"));
            }
            if (map.containsKey("duration")) {
                this.totalms = Math.round((Long)map.get("duration") / 1000000L);
            }
            if (map.containsKey("ogg.comment.genre")) {
                this.genre = (String)map.get("ogg.comment.genre");
            }
            if (map.containsKey("ogg.comment.track")) {
                try {
                    this.track = Integer.parseInt((String)map.get("ogg.comment.track"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (map.containsKey("ogg.comment.ext.1")) {
                this.comments.add((String)map.get("ogg.comment.ext.1"));
            }
            if (map.containsKey("ogg.comment.ext.2")) {
                this.comments.add((String)map.get("ogg.comment.ext.2"));
            }
            if (map.containsKey("ogg.comment.ext.3")) {
                this.comments.add((String)map.get("ogg.comment.ext.3"));
            }
        }
    }

    protected void loadExtendedInfo(AudioFileFormat audioFileFormat) throws IOException, UnsupportedAudioFileException {
        String string = audioFileFormat.getType().toString();
        if (!string.equalsIgnoreCase("ogg")) {
            throw new UnsupportedAudioFileException("Not Ogg Vorbis audio format");
        }
        if (audioFileFormat instanceof TAudioFileFormat) {
            // empty if block
        }
    }

    public int getSerial() {
        return this.serial;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMinBitrate() {
        return this.minbitrate;
    }

    public int getMaxBitrate() {
        return this.maxbitrate;
    }

    public int getAverageBitrate() {
        return this.averagebitrate;
    }

    public long getSize() {
        return this.size;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getLocation() {
        return this.location;
    }

    public int getSamplingRate() {
        return this.rate;
    }

    public int getBitRate() {
        return this.nominalbitrate;
    }

    public long getPlayTime() {
        return this.totalms;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public int getTrack() {
        return this.track;
    }

    public String getGenre() {
        return this.genre;
    }

    public Vector getComment() {
        return this.comments;
    }

    public String getYear() {
        return this.year;
    }
}

