/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.tag;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jlgui.player.amp.tag.TagInfo;
import org.tritonus.share.sampled.TAudioFormat;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class APEInfo
implements TagInfo {
    protected int channels = -1;
    protected int bitspersample = -1;
    protected int samplerate = -1;
    protected int bitrate = -1;
    protected int version = -1;
    protected String compressionlevel = null;
    protected int totalframes = -1;
    protected int blocksperframe = -1;
    protected int finalframeblocks = -1;
    protected int totalblocks = -1;
    protected int peaklevel = -1;
    protected long duration = -1L;
    protected String author = null;
    protected String title = null;
    protected String copyright = null;
    protected Date date = null;
    protected String comment = null;
    protected String track = null;
    protected String genre = null;
    protected String album = null;
    protected long size = 0L;
    protected String location = null;

    public void load(File file) throws IOException, UnsupportedAudioFileException {
        this.size = file.length();
        this.location = file.getPath();
        this.loadInfo(file);
    }

    public void load(URL uRL) throws IOException, UnsupportedAudioFileException {
        this.location = uRL.toString();
        this.loadInfo(uRL);
    }

    public void load(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        this.loadInfo(inputStream);
    }

    protected void loadInfo(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(inputStream);
        this.loadInfo(audioFileFormat);
    }

    protected void loadInfo(File file) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(file);
        this.loadInfo(audioFileFormat);
    }

    protected void loadInfo(AudioFileFormat audioFileFormat) throws UnsupportedAudioFileException {
        String string = audioFileFormat.getType().toString();
        if (!string.equalsIgnoreCase("Monkey's Audio (ape)") && !string.equalsIgnoreCase("Monkey's Audio (mac)")) {
            throw new UnsupportedAudioFileException("Not APE audio format");
        }
        if (audioFileFormat instanceof TAudioFileFormat) {
            Map map = ((TAudioFileFormat)audioFileFormat).properties();
            if (map.containsKey("duration")) {
                this.duration = (Long)map.get("duration");
            }
            if (map.containsKey("author")) {
                this.author = (String)map.get("author");
            }
            if (map.containsKey("title")) {
                this.title = (String)map.get("title");
            }
            if (map.containsKey("copyright")) {
                this.copyright = (String)map.get("copyright");
            }
            if (map.containsKey("date")) {
                this.date = (Date)map.get("date");
            }
            if (map.containsKey("comment")) {
                this.comment = (String)map.get("comment");
            }
            if (map.containsKey("album")) {
                this.album = (String)map.get("album");
            }
            if (map.containsKey("track")) {
                this.track = (String)map.get("track");
            }
            if (map.containsKey("genre")) {
                this.genre = (String)map.get("genre");
            }
            AudioFormat audioFormat = audioFileFormat.getFormat();
            this.channels = audioFormat.getChannels();
            this.samplerate = (int)audioFormat.getSampleRate();
            this.bitspersample = audioFormat.getSampleSizeInBits();
            if (audioFormat instanceof TAudioFormat) {
                map = ((TAudioFormat)audioFormat).properties();
                if (map.containsKey("bitrate")) {
                    this.bitrate = (Integer)map.get("bitrate");
                }
                if (map.containsKey("ape.version")) {
                    this.version = (Integer)map.get("ape.version");
                }
                if (map.containsKey("ape.compressionlevel")) {
                    int n = (Integer)map.get("ape.compressionlevel");
                    switch (n) {
                        case 1000: {
                            this.compressionlevel = "Fast";
                            break;
                        }
                        case 2000: {
                            this.compressionlevel = "Normal";
                            break;
                        }
                        case 3000: {
                            this.compressionlevel = "High";
                            break;
                        }
                        case 4000: {
                            this.compressionlevel = "Extra High";
                            break;
                        }
                        case 5000: {
                            this.compressionlevel = "Insane";
                        }
                    }
                }
                if (map.containsKey("ape.totalframes")) {
                    this.totalframes = (Integer)map.get("ape.totalframes");
                }
                if (map.containsKey("ape.blocksperframe")) {
                    this.totalframes = (Integer)map.get("ape.blocksperframe");
                }
                if (map.containsKey("ape.finalframeblocks")) {
                    this.finalframeblocks = (Integer)map.get("ape.finalframeblocks");
                }
                if (map.containsKey("ape.totalblocks")) {
                    this.totalblocks = (Integer)map.get("ape.totalblocks");
                }
                if (map.containsKey("ape.peaklevel")) {
                    this.peaklevel = (Integer)map.get("ape.peaklevel");
                }
            }
        }
    }

    protected void loadInfo(URL uRL) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(uRL);
        this.loadInfo(audioFileFormat);
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.location;
    }

    public int getVersion() {
        return this.version;
    }

    public String getCompressionlevel() {
        return this.compressionlevel;
    }

    public int getTotalframes() {
        return this.totalframes;
    }

    public int getBlocksperframe() {
        return this.blocksperframe;
    }

    public int getFinalframeblocks() {
        return this.finalframeblocks;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSamplingRate() {
        return this.samplerate;
    }

    public int getBitsPerSample() {
        return this.bitspersample;
    }

    public int getTotalblocks() {
        return this.totalblocks;
    }

    public long getPlayTime() {
        return this.duration / 1000L;
    }

    public int getBitRate() {
        return this.bitrate * 1000;
    }

    public int getPeaklevel() {
        return this.peaklevel;
    }

    public int getTrack() {
        int n;
        try {
            n = Integer.parseInt(this.track);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public String getYear() {
        if (this.date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.date);
            return String.valueOf(calendar.get(1));
        }
        return null;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.author;
    }

    public String getAlbum() {
        return this.album;
    }

    public Vector getComment() {
        if (this.comment != null) {
            Vector<String> vector = new Vector<String>();
            vector.add(this.comment);
            return vector;
        }
        return null;
    }

    public String getCopyright() {
        return this.copyright;
    }
}

