/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.playlist;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javazoom.jlgui.player.amp.playlist.Playlist;
import javazoom.jlgui.player.amp.playlist.PlaylistItem;
import javazoom.jlgui.player.amp.util.Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasePlaylist
implements Playlist {
    protected Vector _playlist = new Vector();
    protected int _cursorPos = -1;
    protected boolean isModified;
    protected String M3UHome = null;
    protected String PLSHome = null;
    private static Log log = LogFactory.getLog((Class)BasePlaylist.class);

    public boolean isModified() {
        return this.isModified;
    }

    public boolean load(String string) {
        this.setModified(true);
        boolean bl = false;
        if (string != null && string.toLowerCase().endsWith(".m3u")) {
            bl = this.loadM3U(string);
        } else if (string != null && string.toLowerCase().endsWith(".pls")) {
            bl = this.loadPLS(string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadM3U(String string) {
        Config config = Config.getInstance();
        this._playlist = new Vector();
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = Config.startWithProtocol(string) ? new BufferedReader(new InputStreamReader(new URL(string).openStream())) : new BufferedReader(new FileReader(string));
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().length() == 0) continue;
                if (string2.startsWith("#")) {
                    int n;
                    if (!string2.toUpperCase().startsWith("#EXTINF")) continue;
                    int n2 = string2.indexOf(",", 0);
                    if (n2 != -1) {
                        string3 = string2.substring(n2 + 1, string2.length());
                    }
                    if ((n = string2.indexOf(":", 0)) == -1 || n >= n2) continue;
                    string5 = string2.substring(n + 1, n2).trim();
                    continue;
                }
                string4 = string2;
                if (string3 == null) {
                    string3 = string4;
                }
                if (string5 == null) {
                    string5 = "-1";
                }
                PlaylistItem playlistItem = null;
                if (Config.startWithProtocol(string4)) {
                    playlistItem = new PlaylistItem(string3, string4, Long.parseLong(string5), false);
                } else {
                    File file = new File(string4);
                    if (file.exists()) {
                        playlistItem = new PlaylistItem(string3, string4, Long.parseLong(string5), true);
                    } else {
                        file = new File(config.getLastDir() + string4);
                        if (file.exists()) {
                            playlistItem = new PlaylistItem(string3, config.getLastDir() + string4, Long.parseLong(string5), true);
                        } else if (this.M3UHome != null) {
                            playlistItem = Config.startWithProtocol(this.M3UHome) ? new PlaylistItem(string3, this.M3UHome + string4, Long.parseLong(string5), false) : new PlaylistItem(string3, this.M3UHome + string4, Long.parseLong(string5), true);
                        }
                    }
                }
                if (playlistItem != null) {
                    this.appendItem(playlistItem);
                }
                string4 = null;
                string3 = null;
                string5 = null;
            }
            bl = true;
        }
        catch (Exception exception) {
            log.debug((Object)"Can't load .m3u playlist", (Throwable)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                log.info((Object)"Can't close .m3u playlist", (Throwable)exception);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadPLS(String string) {
        Config config = Config.getInstance();
        this._playlist = new Vector();
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = Config.startWithProtocol(string) ? new BufferedReader(new InputStreamReader(new URL(string).openStream())) : new BufferedReader(new FileReader(string));
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object;
                if (string2.trim().length() == 0) continue;
                if (string2.toLowerCase().startsWith("file")) {
                    object = new StringTokenizer(string2, "=");
                    ((StringTokenizer)object).nextToken();
                    string4 = ((StringTokenizer)object).nextToken().trim();
                } else if (string2.toLowerCase().startsWith("title")) {
                    object = new StringTokenizer(string2, "=");
                    ((StringTokenizer)object).nextToken();
                    string3 = ((StringTokenizer)object).nextToken().trim();
                } else if (string2.toLowerCase().startsWith("length")) {
                    object = new StringTokenizer(string2, "=");
                    ((StringTokenizer)object).nextToken();
                    string5 = ((StringTokenizer)object).nextToken().trim();
                }
                if (string4 == null) continue;
                object = null;
                if (string3 == null) {
                    string3 = string4;
                }
                if (string5 == null) {
                    string5 = "-1";
                }
                if (Config.startWithProtocol(string4)) {
                    object = new PlaylistItem(string3, string4, Long.parseLong(string5), false);
                } else {
                    File file = new File(string4);
                    if (file.exists()) {
                        object = new PlaylistItem(string3, string4, Long.parseLong(string5), true);
                    } else {
                        file = new File(config.getLastDir() + string4);
                        if (file.exists()) {
                            object = new PlaylistItem(string3, config.getLastDir() + string4, Long.parseLong(string5), true);
                        } else if (this.PLSHome != null) {
                            object = Config.startWithProtocol(this.PLSHome) ? new PlaylistItem(string3, this.PLSHome + string4, Long.parseLong(string5), false) : new PlaylistItem(string3, this.PLSHome + string4, Long.parseLong(string5), true);
                        }
                    }
                }
                if (object != null) {
                    this.appendItem((PlaylistItem)object);
                }
                string3 = null;
                string4 = null;
                string5 = null;
            }
            bl = true;
        }
        catch (Exception exception) {
            log.debug((Object)"Can't load .pls playlist", (Throwable)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                log.info((Object)"Can't close .pls playlist", (Throwable)exception);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(String string) {
        if (this._playlist != null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string));
                bufferedWriter.write("#EXTM3U");
                bufferedWriter.newLine();
                Iterator iterator = this._playlist.iterator();
                while (iterator.hasNext()) {
                    PlaylistItem playlistItem = (PlaylistItem)iterator.next();
                    bufferedWriter.write("#EXTINF:" + playlistItem.getM3UExtInf());
                    bufferedWriter.newLine();
                    bufferedWriter.write(playlistItem.getLocation());
                    bufferedWriter.newLine();
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                log.info((Object)"Can't save playlist", (Throwable)iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    log.info((Object)"Can't close playlist", (Throwable)iOException);
                }
            }
        }
        return false;
    }

    public void addItemAt(PlaylistItem playlistItem, int n) {
        this._playlist.insertElementAt(playlistItem, n);
        this.setModified(true);
    }

    public void removeItem(PlaylistItem playlistItem) {
        this._playlist.remove(playlistItem);
        this.setModified(true);
    }

    public void removeItemAt(int n) {
        this._playlist.removeElementAt(n);
        this.setModified(true);
    }

    public void removeAllItems() {
        this._playlist.removeAllElements();
        this._cursorPos = -1;
        this.setModified(true);
    }

    public void appendItem(PlaylistItem playlistItem) {
        this._playlist.addElement(playlistItem);
        this.setModified(true);
    }

    public void sortItems(int n) {
    }

    public void shuffle() {
        int n = this._playlist.size();
        if (n < 2) {
            return;
        }
        Vector vector = this._playlist;
        this._playlist = new Vector(n);
        while ((n = vector.size()) > 0) {
            this._playlist.addElement(vector.remove((int)(Math.random() * (double)n)));
        }
        this.begin();
    }

    public void begin() {
        this._cursorPos = -1;
        if (this.getPlaylistSize() > 0) {
            this._cursorPos = 0;
        }
        this.setModified(true);
    }

    public PlaylistItem getItemAt(int n) {
        PlaylistItem playlistItem = null;
        playlistItem = (PlaylistItem)this._playlist.elementAt(n);
        return playlistItem;
    }

    public Collection getAllItems() {
        return null;
    }

    public int getPlaylistSize() {
        return this._playlist.size();
    }

    public PlaylistItem getCursor() {
        if (this._cursorPos < 0 || this._cursorPos >= this._playlist.size()) {
            return null;
        }
        return this.getItemAt(this._cursorPos);
    }

    public void nextCursor() {
        ++this._cursorPos;
    }

    public void previousCursor() {
        --this._cursorPos;
        if (this._cursorPos < 0) {
            this._cursorPos = 0;
        }
    }

    public boolean setModified(boolean bl) {
        this.isModified = bl;
        return this.isModified;
    }

    public void setCursor(int n) {
        this._cursorPos = n;
    }

    public int getSelectedIndex() {
        return this._cursorPos;
    }

    public int getIndex(PlaylistItem playlistItem) {
        int n = -1;
        for (int i = 0; i < this._playlist.size(); ++i) {
            n = i;
            PlaylistItem playlistItem2 = (PlaylistItem)this._playlist.elementAt(i);
            if (playlistItem2.equals(playlistItem)) break;
        }
        return n;
    }

    public String getM3UHome() {
        return this.M3UHome;
    }

    public void setM3UHome(String string) {
        this.M3UHome = string;
    }

    public String getPLSHome() {
        return this.PLSHome;
    }

    public void setPLSHome(String string) {
        this.PLSHome = string;
    }
}

